/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public final class SvnRepositoryLocation
implements RepositoryLocation {
    private final String myUrlValue;
    @Nullable
    private final Url myUrl;
    @Nullable
    private final Url myRepositoryUrl;
    @Nullable
    private final FilePath myRoot;

    public SvnRepositoryLocation(@NotNull String url) {
        this.myUrl = null;
        this.myUrlValue = url;
        this.myRepositoryUrl = null;
        this.myRoot = null;
    }

    public SvnRepositoryLocation(@NotNull Url url) {
        this(url, null, null);
    }

    public SvnRepositoryLocation(@NotNull Url url, @Nullable Url repositoryUrl, @Nullable FilePath root) {
        this.myUrl = url;
        this.myUrlValue = url.toString();
        this.myRepositoryUrl = repositoryUrl;
        this.myRoot = root;
    }

    public String toString() {
        return this.myUrlValue;
    }

    @NotNull
    public String toPresentableString() {
        return this.myUrlValue;
    }

    public String getURL() {
        return this.myUrlValue;
    }

    public String getKey() {
        return this.myUrlValue;
    }

    @Nullable
    public FilePath getRoot() {
        return this.myRoot;
    }

    @Nullable
    public Url getRepositoryUrl() {
        return this.myRepositoryUrl;
    }

    @NotNull
    public Url toSvnUrl() throws SvnBindException {
        return this.myUrl != null ? this.myUrl : SvnUtil.createUrl(this.myUrlValue);
    }
}

