/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.SvnRepositoryBinaryContentRevision;

public class SvnRepositoryContentRevision
extends SvnBaseContentRevision
implements ByteBackedContentRevision {
    @NotNull
    private final String myPath;
    private final long myRevision;

    public SvnRepositoryContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath remotePath, @Nullable FilePath localPath, long revision) {
        super(vcs, (FilePath)ObjectUtils.notNull((Object)localPath, (Object)remotePath));
        this.myPath = FileUtil.toSystemIndependentName((String)remotePath.getPath());
        this.myRevision = revision;
    }

    @NotNull
    public String getContent() throws VcsException {
        return ContentRevisionCache.getAsString((byte[])this.getContentAsBytes(), (FilePath)this.myFile, null);
    }

    public byte @NotNull [] getContentAsBytes() throws VcsException {
        try {
            if (this.myFile.getVirtualFile() == null) {
                LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myFile.getPath());
            }
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myVcs.getProject(), (FilePath)this.myFile, (VcsRevisionNumber)this.getRevisionNumber(), (VcsKey)this.myVcs.getKeyInstanceMethod(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, () -> this.loadContent().toByteArray());
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    @NotNull
    protected ByteArrayOutputStream loadContent() throws VcsException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ContentLoader loader = new ContentLoader(this.myPath, buffer, this.myRevision);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously((Runnable)loader, SvnBundle.message("progress.title.loading.file.content", new Object[0]), false, null);
        } else {
            loader.run();
        }
        Exception exception = loader.getException();
        if (exception != null) {
            throw new VcsException((Throwable)exception);
        }
        ContentRevisionCache.checkContentsSize((String)this.myPath, (long)buffer.size());
        return buffer;
    }

    @NotNull
    public SvnRevisionNumber getRevisionNumber() {
        return new SvnRevisionNumber(Revision.of(this.myRevision));
    }

    public static SvnRepositoryContentRevision create(@NotNull SvnVcs vcs, @NotNull String repositoryRoot, @NotNull String path, @Nullable FilePath localPath, long revision) {
        return SvnRepositoryContentRevision.create(vcs, Url.append(repositoryRoot, path), localPath, revision);
    }

    public static SvnRepositoryContentRevision createForRemotePath(@NotNull SvnVcs vcs, @NotNull String repositoryRoot, @NotNull String path, boolean isDirectory, long revision) {
        FilePath remotePath = VcsUtil.getFilePathOnNonLocal((String)Url.append(repositoryRoot, path), (boolean)isDirectory);
        return SvnRepositoryContentRevision.create(vcs, remotePath, remotePath, revision);
    }

    public static SvnRepositoryContentRevision create(@NotNull SvnVcs vcs, @NotNull String fullPath, @Nullable FilePath localPath, long revision) {
        FilePath remotePath = VcsUtil.getFilePathOnNonLocal((String)fullPath, (boolean)false);
        return SvnRepositoryContentRevision.create(vcs, remotePath, localPath == null ? remotePath : localPath, revision);
    }

    public static SvnRepositoryContentRevision create(@NotNull SvnVcs vcs, @NotNull FilePath remotePath, @Nullable FilePath localPath, long revision) {
        return remotePath.getFileType().isBinary() ? new SvnRepositoryBinaryContentRevision(vcs, remotePath, localPath, revision) : new SvnRepositoryContentRevision(vcs, remotePath, localPath, revision);
    }

    public String toString() {
        return this.myFile.getIOFile() + "#" + this.myRevision;
    }

    @NotNull
    public String getFullPath() {
        return this.myPath;
    }

    public String getRelativePath(@NotNull String repositoryUrl) {
        return SvnUtil.getRelativePath(repositoryUrl, this.myPath);
    }

    @NotNull
    public Url getUrl() throws SvnBindException {
        return SvnUtil.createUrl(this.getFullPath(), false);
    }

    @NotNull
    public Target toTarget() throws SvnBindException {
        return Target.on(this.getUrl(), this.getRevisionNumber().getRevision());
    }

    private class ContentLoader
    implements Runnable {
        private final String myPath;
        private final long myRevision;
        private final OutputStream myDst;
        private Exception myException;

        ContentLoader(String path, OutputStream dst, long revision) {
            this.myPath = path;
            this.myDst = dst;
            this.myRevision = revision;
        }

        public Exception getException() {
            return this.myException;
        }

        @Override
        public void run() {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            if (progress != null) {
                progress.setText(SvnBundle.message("progress.text.loading.contents", this.myPath));
                progress.setText2(SvnBundle.message("progress.text2.revision.information", this.myRevision));
            }
            try {
                Revision revision = Revision.of(this.myRevision);
                byte[] contents = SvnUtil.getFileContents(SvnRepositoryContentRevision.this.myVcs, Target.on(SvnRepositoryContentRevision.this.getUrl()), revision, revision);
                this.myDst.write(contents);
            }
            catch (VcsException | IOException e) {
                this.myException = e;
            }
        }
    }
}

