/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBaseContentRevision;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.PropertyRevision;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;

public class SvnLazyPropertyContentRevision
extends SvnBaseContentRevision
implements PropertyRevision {
    private static final String ourPropertiesDelimiter = "\n";
    @NotNull
    private final VcsRevisionNumber myNumber;
    @NotNull
    private final Target myTarget;
    private List<PropertyData> myContent;

    public SvnLazyPropertyContentRevision(@NotNull SvnVcs vcs, @NotNull FilePath file, @NotNull VcsRevisionNumber number, @NotNull Target target) {
        super(vcs, file);
        this.myNumber = number;
        this.myTarget = target;
    }

    @Override
    @Nullable
    public List<PropertyData> getProperties() throws VcsException {
        if (this.myContent == null) {
            this.myContent = this.loadContent();
        }
        return this.myContent;
    }

    public String getContent() throws VcsException {
        return SvnLazyPropertyContentRevision.toSortedStringPresentation(this.getProperties());
    }

    private List<PropertyData> loadContent() throws VcsException {
        Ref ref = new Ref();
        Ref exceptionRef = new Ref();
        Runnable runnable = () -> {
            try {
                ref.set(SvnLazyPropertyContentRevision.getPropertyList(this.myVcs, this.myTarget, this.myTarget.getPegRevision()));
            }
            catch (VcsException e) {
                exceptionRef.set((Object)e);
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, SvnBundle.message("progress.title.loading.file.properties", new Object[0]), true, this.myVcs.getProject());
            if (!completed) {
                throw new VcsException(SvnBundle.message("error.properties.loading.for.revision.canceled", this.getRevisionNumber().asString()));
            }
        } else {
            runnable.run();
        }
        if (!exceptionRef.isNull()) {
            throw (VcsException)((Object)exceptionRef.get());
        }
        return (List)ref.get();
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.myNumber;
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull Target target, @Nullable Revision revision) throws SvnBindException {
        ArrayList<PropertyData> lines = new ArrayList<PropertyData>();
        PropertyConsumer propertyHandler = SvnLazyPropertyContentRevision.createHandler(revision, lines);
        vcs.getFactory(target).createPropertyClient().list(target, revision, Depth.EMPTY, propertyHandler);
        return lines;
    }

    @NotNull
    private static PropertyConsumer createHandler(Revision revision, final @NotNull List<? super PropertyData> lines) {
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
            indicator.setText(SvnBundle.message("show.properties.diff.progress.text.revision.information", revision.toString()));
        }
        return new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) {
                this.registerProperty(property);
            }

            @Override
            public void handleProperty(Url url, PropertyData property) {
                this.registerProperty(property);
            }

            private void registerProperty(@NotNull PropertyData property) {
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(SvnBundle.message("show.properties.diff.progress.text2.property.information", property.getName()));
                }
                lines.add(property);
            }
        };
    }

    @NotNull
    public static String toSortedStringPresentation(@NotNull List<? extends PropertyData> lines) {
        StringBuilder sb = new StringBuilder();
        lines.sort(Comparator.comparing(PropertyData::getName));
        for (PropertyData propertyData : lines) {
            SvnLazyPropertyContentRevision.addPropertyPresentation(propertyData, sb);
        }
        return sb.toString();
    }

    private static void addPropertyPresentation(@NotNull PropertyData property, @NotNull StringBuilder sb) {
        if (sb.length() != 0) {
            sb.append(ourPropertiesDelimiter);
        }
        sb.append(property.getName()).append("=").append(property.getValue());
    }
}

