/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.BaseDiffFromHistoryHandler;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.diff.DirectoryWithBranchComparer;
import org.jetbrains.idea.svn.history.SvnFileRevision;

public class SvnDiffFromHistoryHandler
extends BaseDiffFromHistoryHandler<SvnFileRevision> {
    @NotNull
    private final SvnVcs myVcs;

    public SvnDiffFromHistoryHandler(@NotNull SvnVcs vcs) {
        super(vcs.getProject());
        this.myVcs = vcs;
    }

    @NotNull
    protected List<Change> getChangesBetweenRevisions(@NotNull FilePath path, @NotNull SvnFileRevision rev1, @Nullable SvnFileRevision rev2) throws VcsException {
        File file = path.getIOFile();
        Target target1 = Target.on(rev1.getURL(), rev1.getRevision());
        Target target2 = rev2 != null ? Target.on(rev2.getURL(), rev2.getRevision()) : Target.on(file);
        return this.executeDiff(path, target1, target2);
    }

    @NotNull
    protected List<Change> getAffectedChanges(@NotNull FilePath path, @NotNull SvnFileRevision rev) throws VcsException {
        Target target1 = Target.on(rev.getURL(), Revision.of(0L));
        Target target2 = Target.on(rev.getURL(), rev.getRevision());
        return this.executeDiff(path, target1, target2);
    }

    @NotNull
    protected String getPresentableName(@NotNull SvnFileRevision revision) {
        return revision.getRevisionNumber().asString();
    }

    @NotNull
    private List<Change> executeDiff(@NotNull FilePath path, @NotNull Target target1, @NotNull Target target2) throws VcsException {
        File file = path.getIOFile();
        ClientFactory factory = target2.isUrl() ? this.myVcs.getFactory(file) : DirectoryWithBranchComparer.getClientFactory(this.myVcs, file);
        return factory.createDiffClient().compare(target1, target2);
    }
}

