/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;

public class SvnCopyPathTracker {
    private static final Logger LOG = Logger.getInstance(SvnCopyPathTracker.class);
    @NotNull
    private String myCurrentPath;
    @NotNull
    private final Url myRepositoryUrl;
    private boolean myHadChanged;

    public SvnCopyPathTracker(@NotNull Url repositoryUrl, @NotNull String repositoryRelativeUrl) {
        this.myRepositoryUrl = repositoryUrl;
        this.myCurrentPath = repositoryRelativeUrl;
    }

    public void accept(@NotNull LogEntry entry) {
        for (LogEntryPath entryPath : entry.getChangedPaths().values()) {
            if (entryPath == null || 'A' != entryPath.getType() || entryPath.getCopyPath() == null) continue;
            if (this.myCurrentPath.equals(entryPath.getPath())) {
                this.myHadChanged = true;
                this.myCurrentPath = entryPath.getCopyPath();
                return;
            }
            if (!Url.isAncestor(entryPath.getPath(), this.myCurrentPath)) continue;
            this.myCurrentPath = Url.append(entryPath.getCopyPath(), Url.getRelative(entryPath.getPath(), this.myCurrentPath));
            this.myHadChanged = true;
            return;
        }
    }

    @Nullable
    public FilePath getFilePath(@NotNull SvnVcs vcs) throws SvnBindException {
        if (!this.myHadChanged) {
            return null;
        }
        Url currentUrl = SvnUtil.append(this.myRepositoryUrl, this.myCurrentPath);
        File localPath = vcs.getSvnFileUrlMapping().getLocalPath(currentUrl);
        if (localPath == null) {
            LOG.info("Cannot find local path for url: " + currentUrl);
            return null;
        }
        return VcsUtil.getFilePath((File)localPath, (boolean)false);
    }
}

