/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.ConfigureBranchesAction;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.MergeInfoUpdatesListener;
import org.jetbrains.idea.svn.history.MergeSourceHierarchyBuilder;
import org.jetbrains.idea.svn.history.RootsAndBranches;
import org.jetbrains.idea.svn.history.ShowHideMergePanelAction;
import org.jetbrains.idea.svn.history.SingleCommittedListProvider;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedListsZipper;
import org.jetbrains.idea.svn.history.SvnMergeSourceTracker;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.history.SvnVersionFilterComponent;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnCommittedChangesProvider
implements CachingCommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> {
    private static final Logger LOG = Logger.getInstance(SvnCommittedChangesProvider.class);
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final MessageBusConnection myConnection;
    private MergeInfoUpdatesListener myMergeInfoUpdatesListener;
    @NotNull
    private final SvnCommittedListsZipper myZipper;
    public static final int VERSION_WITH_COPY_PATHS_ADDED = 2;
    public static final int VERSION_WITH_REPLACED_PATHS = 3;

    public SvnCommittedChangesProvider(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
        this.myZipper = new SvnCommittedListsZipper(this.myVcs);
        this.myConnection = this.myVcs.getProject().getMessageBus().connect();
        this.myConnection.subscribe(VcsConfigurationChangeListener.BRANCHES_CHANGED_RESPONSE, (project, vcsRoot, cachedList) -> ApplicationManager.getApplication().invokeLater(() -> cachedList.stream().filter(SvnChangeList.class::isInstance).map(SvnChangeList.class::cast).filter(list -> vcsRoot == null || vcsRoot.equals(list.getVcsRoot())).forEach(SvnChangeList::forceReloadCachedInfo), project.getDisposed()));
    }

    @NotNull
    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new SvnVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public RepositoryLocation getLocationFor(@NotNull FilePath root) {
        Info info2 = this.myVcs.getInfo(root.getIOFile());
        return info2 != null && info2.getUrl() != null ? new SvnRepositoryLocation(info2.getUrl(), info2.getRepositoryRootUrl(), root) : null;
    }

    @NotNull
    public VcsCommittedListsZipper getZipper() {
        return this.myZipper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, @NotNull AsynchConsumer<? super CommittedChangeList> consumer) throws VcsException {
        try {
            SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
            Url repositoryRoot = this.getRepositoryRoot(svnLocation);
            ChangeBrowserSettings.Filter filter = settings.createFilter();
            ThrowableConsumer resultConsumer = logEntry -> {
                SvnChangeList list = new SvnChangeList(this.myVcs, svnLocation, (LogEntry)logEntry, repositoryRoot);
                if (filter.accepts((CommittedChangeList)list)) {
                    consumer.consume((Object)list);
                }
            };
            Target target = Target.on(svnLocation.toSvnUrl(), SvnCommittedChangesProvider.createBeforeRevision(settings));
            this.getCommittedChangesImpl(settings, target, maxCount, (ThrowableConsumer<LogEntry, SvnBindException>)resultConsumer, false, true);
        }
        finally {
            consumer.finished();
        }
    }

    @NotNull
    public List<SvnChangeList> getCommittedChanges(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount) throws VcsException {
        SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        ArrayList<SvnChangeList> result = new ArrayList<SvnChangeList>();
        Url repositoryRoot = this.getRepositoryRoot(svnLocation);
        ThrowableConsumer resultConsumer = logEntry -> result.add(new SvnChangeList(this.myVcs, svnLocation, (LogEntry)logEntry, repositoryRoot));
        Target target = Target.on(svnLocation.toSvnUrl(), SvnCommittedChangesProvider.createBeforeRevision(settings));
        this.getCommittedChangesImpl(settings, target, maxCount, (ThrowableConsumer<LogEntry, SvnBindException>)resultConsumer, false, true);
        settings.filterChanges(result);
        return result;
    }

    public void getCommittedChangesWithMergedRevisons(@NotNull ChangeBrowserSettings settings, @NotNull RepositoryLocation location, int maxCount, @NotNull PairConsumer<SvnChangeList, LogHierarchyNode> finalConsumer) throws VcsException {
        SvnRepositoryLocation svnLocation = (SvnRepositoryLocation)location;
        Url repositoryRoot = this.getRepositoryRoot(svnLocation);
        MergeSourceHierarchyBuilder builder = new MergeSourceHierarchyBuilder((Consumer<? super LogHierarchyNode>)((Consumer)node -> finalConsumer.consume((Object)new SvnChangeList(this.myVcs, svnLocation, node.getMe(), repositoryRoot), node)));
        SvnMergeSourceTracker mergeSourceTracker = new SvnMergeSourceTracker(builder);
        this.getCommittedChangesImpl(settings, Target.on(svnLocation.toSvnUrl()), maxCount, mergeSourceTracker, true, false);
        builder.finish();
    }

    @NotNull
    private Url getRepositoryRoot(@NotNull SvnRepositoryLocation svnLocation) throws VcsException {
        Url url = svnLocation.toSvnUrl();
        Url rootUrl = SvnUtil.getRepositoryRoot(this.myVcs, url);
        if (rootUrl == null) {
            throw new SvnBindException(SvnBundle.message("error.can.not.find.repository.root.for.url", url.toDecodedString()));
        }
        return rootUrl;
    }

    private void getCommittedChangesImpl(@NotNull ChangeBrowserSettings settings, @NotNull Target target, int maxCount, @NotNull ThrowableConsumer<LogEntry, SvnBindException> resultConsumer, boolean includeMergedRevisions, boolean filterOutByDate) throws VcsException {
        ProgressManager.progress((String)SvnBundle.message("progress.text.changes.collecting.changes", new Object[0]), (String)SvnBundle.message("progress.text2.changes.establishing.connection", target.getPath()));
        String author = settings.getUserFilter();
        Revision revisionBefore = SvnCommittedChangesProvider.createBeforeRevision(settings);
        Revision revisionAfter = SvnCommittedChangesProvider.createAfterRevision(settings);
        this.myVcs.getFactory(target).createHistoryClient().doLog(target, revisionBefore, revisionAfter, settings.STOP_ON_COPY, true, includeMergedRevisions, maxCount, null, this.createLogHandler(resultConsumer, filterOutByDate, author));
    }

    @NotNull
    private static Revision createBeforeRevision(@NotNull ChangeBrowserSettings settings) {
        return SvnCommittedChangesProvider.createRevision(settings.getDateBeforeFilter(), settings.getChangeBeforeFilter(), Revision.HEAD);
    }

    @NotNull
    private static Revision createAfterRevision(@NotNull ChangeBrowserSettings settings) {
        return SvnCommittedChangesProvider.createRevision(settings.getDateAfterFilter(), settings.getChangeAfterFilter(), Revision.of(1L));
    }

    @NotNull
    private static Revision createRevision(@Nullable Date date, @Nullable Long change, @NotNull Revision defaultValue) {
        Revision result = date != null ? Revision.of(date) : (change != null ? Revision.of(change) : defaultValue);
        return result;
    }

    @NotNull
    private LogEntryConsumer createLogHandler(@NotNull ThrowableConsumer<LogEntry, SvnBindException> resultConsumer, boolean filterOutByDate, @Nullable String author) {
        return logEntry -> {
            if (this.myVcs.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (logEntry != LogEntry.EMPTY) {
                ProgressManager.progress2((String)SvnBundle.message("progress.text2.processing.revision", logEntry.getRevision()));
            }
            if (filterOutByDate && logEntry.getDate() == null) {
                return;
            }
            if (author == null || author.equalsIgnoreCase(logEntry.getAuthor())) {
                resultConsumer.consume(logEntry);
            }
        };
    }

    public ChangeListColumn @NotNull [] getColumns() {
        return new ChangeListColumn[]{new ChangeListColumn.ChangeListNumberColumn(SvnBundle.message("revision.title", new Object[0])), ChangeListColumn.NAME, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION};
    }

    private void refreshMergeInfo(@NotNull RootsAndBranches action) {
        if (this.myMergeInfoUpdatesListener == null) {
            this.myMergeInfoUpdatesListener = new MergeInfoUpdatesListener(this.myVcs.getProject(), this.myConnection);
        }
        this.myMergeInfoUpdatesListener.addPanel(action);
    }

    @NotNull
    public VcsCommittedViewAuxiliary createActions(@NotNull DecoratorManager manager, @Nullable RepositoryLocation location) {
        RootsAndBranches rootsAndBranches = new RootsAndBranches(this.myVcs, manager, location);
        this.refreshMergeInfo(rootsAndBranches);
        DefaultActionGroup popup = DefaultActionGroup.createPopupGroup(() -> this.myVcs.getDisplayName());
        popup.add((AnAction)rootsAndBranches.getIntegrateAction());
        popup.add((AnAction)rootsAndBranches.getUndoIntegrateAction());
        popup.add((AnAction)new ConfigureBranchesAction());
        ShowHideMergePanelAction action = new ShowHideMergePanelAction(manager, rootsAndBranches.getStrategy());
        return new VcsCommittedViewAuxiliary(Collections.singletonList(popup), () -> {
            if (this.myMergeInfoUpdatesListener != null) {
                this.myMergeInfoUpdatesListener.removePanel(rootsAndBranches);
                rootsAndBranches.dispose();
            }
        }, Collections.singletonList(action));
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    @Nullable
    public Pair<SvnChangeList, FilePath> getOneList(@NotNull VirtualFile file, @NotNull VcsRevisionNumber number) throws VcsException {
        return new SingleCommittedListProvider(this.myVcs, file, number).run();
    }

    @NotNull
    public RepositoryLocation getForNonLocal(@NotNull VirtualFile file) {
        return new SvnRepositoryLocation(FileUtil.toSystemIndependentName((String)file.getPresentableUrl()));
    }

    public int getFormatVersion() {
        return 3;
    }

    public void writeChangeList(@NotNull DataOutput dataStream, @NotNull SvnChangeList list) throws IOException {
        list.writeToStream(dataStream);
    }

    @NotNull
    public SvnChangeList readChangeList(@NotNull RepositoryLocation location, @NotNull DataInput stream) throws IOException {
        int version = this.getFormatVersion();
        return new SvnChangeList(this.myVcs, (SvnRepositoryLocation)location, stream, 2 <= version, 3 <= version);
    }

    @Nullable
    public Collection<FilePath> getIncomingFiles(@NotNull RepositoryLocation location) throws VcsException {
        FilePath root = null;
        if (Registry.is((String)"svn.use.incoming.optimization") && (root = ((SvnRepositoryLocation)location).getRoot()) == null) {
            LOG.info("Working copy root is not provided for repository location " + location);
        }
        return root != null ? this.getIncomingFiles(root) : null;
    }

    @NotNull
    private Collection<FilePath> getIncomingFiles(@NotNull FilePath root) throws SvnBindException {
        HashSet<FilePath> result = new HashSet<FilePath>();
        File rootFile = root.getIOFile();
        this.myVcs.getFactory(rootFile).createStatusClient().doStatus(rootFile, Depth.INFINITY, true, false, false, false, status -> {
            boolean changedOnServer;
            File file = status.getFile();
            boolean bl = changedOnServer = SvnCommittedChangesProvider.isNotNone(status.getRemoteItemStatus()) || SvnCommittedChangesProvider.isNotNone(status.getRemotePropertyStatus());
            if (changedOnServer) {
                result.add(VcsUtil.getFilePath((File)file));
            }
        });
        return result;
    }

    private static boolean isNotNone(@Nullable StatusType status) {
        return status != null && !StatusType.STATUS_NONE.equals((Object)status);
    }

    public String getChangelistTitle() {
        return SvnBundle.message("changes.browser.revision.term", new Object[0]);
    }

    public boolean refreshIncomingWithCommitted() {
        return true;
    }

    public void deactivate() {
        this.myConnection.disconnect();
    }
}

