/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool.properties;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContext;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.ProxySimpleDiffRequest;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffRequest;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public final class SvnPropertiesDiffViewer
extends TwosideTextDiffViewer {
    @NonNls
    private static final String HELP_ID = "topicId758145";
    @NotNull
    private final List<DiffChange> myDiffChanges;
    private boolean myFirstRediff = true;

    @NotNull
    public static SvnPropertiesDiffViewer create(@NotNull DiffContext context, @NotNull SvnPropertiesDiffRequest request) {
        return SvnPropertiesDiffViewer.create(context, request, false);
    }

    @NotNull
    public static SvnPropertiesDiffViewer create(@NotNull DiffContext context, @NotNull SvnPropertiesDiffRequest request, boolean embedded) {
        Pair<ContentDiffRequest, List<DiffChange>> pair = SvnPropertiesDiffViewer.convertRequest(request, embedded);
        return new SvnPropertiesDiffViewer(context, (ContentDiffRequest)pair.first, (List)pair.second);
    }

    private SvnPropertiesDiffViewer(@NotNull DiffContext context, @NotNull ContentDiffRequest request, @NotNull List<DiffChange> diffChanges) {
        super(context, request);
        this.myDiffChanges = diffChanges;
        for (EditorEx editor : this.getEditors()) {
            if (editor == null) continue;
            EditorSettings settings = editor.getSettings();
            settings.setAdditionalLinesCount(0);
            settings.setAdditionalColumnsCount(1);
            settings.setRightMarginShown(false);
            settings.setFoldingOutlineShown(false);
            settings.setLineNumbersShown(false);
            settings.setLineMarkerAreaShown(false);
            settings.setIndentGuidesShown(false);
            settings.setVirtualSpace(false);
            settings.setWheelFontChangeEnabled(false);
            settings.setAdditionalPageAtBottom(false);
            settings.setCaretRowShown(false);
            settings.setUseSoftWraps(false);
            editor.reinitSettings();
        }
        for (DiffChange change : this.myDiffChanges) {
            DiffDrawUtil.createBorderLineMarker((Editor)this.getEditor(Side.LEFT), (int)change.myEndLine1, (SeparatorPlacement)SeparatorPlacement.TOP);
            DiffDrawUtil.createBorderLineMarker((Editor)this.getEditor(Side.RIGHT), (int)change.myEndLine2, (SeparatorPlacement)SeparatorPlacement.TOP);
        }
        DiffSplitter splitter = this.myContentPanel.getSplitter();
        splitter.setDividerWidth(120);
        splitter.setShowDividerIcon(false);
    }

    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter((DiffSplitter.Painter)new MyDividerPainter());
    }

    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        if (!this.myFirstRediff) {
            return new EmptyRunnable();
        }
        this.myFirstRediff = false;
        for (DiffChange change : this.myDiffChanges) {
            PropertyRecord record = change.getRecord();
            String before = record.getBefore();
            String after = record.getAfter();
            assert (before != null || after != null);
            if (before == null) {
                change.setFragments(SvnPropertiesDiffViewer.createEverythingChanged(0, after.length(), 0, StringUtil.countNewLines((CharSequence)after) + 1));
                continue;
            }
            if (after == null) {
                change.setFragments(SvnPropertiesDiffViewer.createEverythingChanged(before.length(), 0, StringUtil.countNewLines((CharSequence)before) + 1, 0));
                continue;
            }
            try {
                ComparisonManager manager = ComparisonManager.getInstance();
                change.setFragments(manager.squash(manager.compareLinesInner((CharSequence)before, (CharSequence)after, ComparisonPolicy.DEFAULT, indicator)));
            }
            catch (DiffTooBigException e) {
                change.setFragments(SvnPropertiesDiffViewer.createEverythingChanged(before.length(), after.length(), StringUtil.countNewLines((CharSequence)before) + 1, StringUtil.countNewLines((CharSequence)after) + 1));
            }
        }
        return () -> {
            for (DiffChange change : this.myDiffChanges) {
                this.setupHighlighting(change, Side.LEFT);
                this.setupHighlighting(change, Side.RIGHT);
            }
        };
    }

    private void setupHighlighting(@NotNull DiffChange change, @NotNull Side side) {
        List<? extends LineFragment> fragments = change.getFragments();
        assert (fragments != null);
        EditorEx editor = this.getEditor(side);
        DocumentEx document = editor.getDocument();
        int changeStartLine = change.getStartLine(side);
        for (LineFragment lineFragment : fragments) {
            List innerFragments = lineFragment.getInnerFragments();
            int startLine = side.getStartLine(lineFragment) + changeStartLine;
            int endLine = side.getEndLine(lineFragment) + changeStartLine;
            int start = document.getLineStartOffset(startLine);
            TextDiffType type = DiffUtil.getLineDiffType((LineFragment)lineFragment);
            DiffDrawUtil.createHighlighter((Editor)editor, (int)startLine, (int)endLine, (TextDiffType)type, (innerFragments != null ? 1 : 0) != 0);
            if (innerFragments == null) continue;
            for (DiffFragment innerFragment : innerFragments) {
                int innerStart = side.getStartOffset(innerFragment);
                int innerEnd = side.getEndOffset(innerFragment);
                TextDiffType innerType = DiffUtil.getDiffType((DiffFragment)innerFragment);
                DiffDrawUtil.createInlineHighlighter((Editor)editor, (int)(innerStart += start), (int)(innerEnd += start), (TextDiffType)innerType);
            }
        }
    }

    @NotNull
    private static List<? extends LineFragment> createEverythingChanged(int length1, int length2, int lines1, int lines2) {
        return Collections.singletonList(new LineFragmentImpl(0, lines1, 0, lines2, 0, length1, 0, length2));
    }

    protected void onDocumentChange(@NotNull DocumentEvent event) {
        LOG.warn("Document changes are not supported");
    }

    @Nullable
    protected SyncScrollSupport.SyncScrollable getSyncScrollable() {
        return new SyncScrollSupport.SyncScrollable(){

            public boolean isSyncScrollEnabled() {
                return true;
            }

            public int transfer(@NotNull Side side, int line) {
                return line;
            }

            @NotNull
            public Range getRange(@NotNull Side baseSide, int line) {
                return BaseSyncScrollable.idRange((int)line);
            }
        };
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    @NotNull
    private static Pair<ContentDiffRequest, List<DiffChange>> convertRequest(@NotNull SvnPropertiesDiffRequest request, boolean embedded) {
        List<PropertyRecord> records = SvnPropertiesDiffViewer.collectRecords(request);
        StringBuilder builder1 = new StringBuilder();
        StringBuilder builder2 = new StringBuilder();
        ArrayList<DiffChange> diffChanges = new ArrayList<DiffChange>();
        int totalLines = 0;
        for (PropertyRecord record : records) {
            int start = totalLines;
            String before = StringUtil.notNullize((String)record.getBefore());
            String after = StringUtil.notNullize((String)record.getAfter());
            builder1.append(before);
            builder2.append(after);
            int lines1 = StringUtil.countNewLines((CharSequence)before);
            int lines2 = StringUtil.countNewLines((CharSequence)after);
            int appendedLines = Math.max(lines1, lines2) + 1;
            builder1.append("\n".repeat(appendedLines - lines1));
            builder2.append("\n".repeat(appendedLines - lines2));
            diffChanges.add(new DiffChange(record, start, totalLines += appendedLines, start, totalLines));
        }
        DocumentContent content1 = DiffContentFactory.getInstance().create(null, (Document)new DocumentImpl((CharSequence)builder1));
        DocumentContent content2 = DiffContentFactory.getInstance().create(null, (Document)new DocumentImpl((CharSequence)builder2));
        List<DiffContent> contents = Arrays.asList(content1, content2);
        List<String> titles = embedded ? Arrays.asList(null, null) : request.getContentTitles();
        ProxySimpleDiffRequest proxyRequest = new ProxySimpleDiffRequest(request.getTitle(), contents, titles, (UserDataHolder)request);
        proxyRequest.putUserData(DiffUserDataKeys.FORCE_READ_ONLY, (Object)true);
        return Pair.create((Object)proxyRequest, diffChanges);
    }

    @NotNull
    private static List<PropertyRecord> collectRecords(@NotNull SvnPropertiesDiffRequest request) {
        List<DiffContent> originalContents = request.getContents();
        List<PropertyData> properties1 = SvnPropertiesDiffViewer.getProperties(originalContents.get(0));
        List<PropertyData> properties2 = SvnPropertiesDiffViewer.getProperties(originalContents.get(1));
        HashMap<String, PropertyValue> before = new HashMap<String, PropertyValue>();
        HashMap<String, PropertyValue> after = new HashMap<String, PropertyValue>();
        if (properties1 != null) {
            for (PropertyData data : properties1) {
                before.put(data.getName(), data.getValue());
            }
        }
        if (properties2 != null) {
            for (PropertyData data : properties2) {
                after.put(data.getName(), data.getValue());
            }
        }
        ArrayList<PropertyRecord> records = new ArrayList<PropertyRecord>();
        for (String name : ContainerUtil.union(before.keySet(), after.keySet())) {
            records.add(SvnPropertiesDiffViewer.createRecord(name, (PropertyValue)before.get(name), (PropertyValue)after.get(name)));
        }
        ContainerUtil.sort(records, (o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
        return records;
    }

    @Nullable
    private static List<PropertyData> getProperties(@NotNull DiffContent content) {
        if (content instanceof SvnPropertiesDiffRequest.PropertyContent) {
            return ((SvnPropertiesDiffRequest.PropertyContent)content).getProperties();
        }
        return null;
    }

    @NotNull
    private static PropertyRecord createRecord(@NotNull String name, @Nullable PropertyValue value1, @Nullable PropertyValue value2) {
        String text2;
        assert (value1 != null || value2 != null);
        String text1 = value1 != null ? value1.toString() : null;
        String string = text2 = value2 != null ? value2.toString() : null;
        if (text1 != null) {
            text1 = StringUtil.convertLineSeparators((String)text1);
        }
        if (text2 != null) {
            text2 = StringUtil.convertLineSeparators((String)text2);
        }
        return new PropertyRecord(name, text1, text2);
    }

    private static class DiffChange {
        @NotNull
        private final PropertyRecord myRecord;
        private final int myStartLine1;
        private final int myEndLine1;
        private final int myStartLine2;
        private final int myEndLine2;
        @Nullable
        private List<? extends LineFragment> myFragments;

        DiffChange(@NotNull PropertyRecord record, int startLine1, int endLine1, int startLine2, int endLine2) {
            this.myRecord = record;
            this.myStartLine1 = startLine1;
            this.myEndLine1 = endLine1;
            this.myStartLine2 = startLine2;
            this.myEndLine2 = endLine2;
        }

        @NotNull
        public PropertyRecord getRecord() {
            return this.myRecord;
        }

        public int getStartLine(@NotNull Side side) {
            return side.select(this.myStartLine1, this.myStartLine2);
        }

        public int getEndLine(@NotNull Side side) {
            return side.select(this.myEndLine1, this.myEndLine2);
        }

        public void setFragments(@Nullable List<? extends LineFragment> fragments) {
            this.myFragments = fragments;
        }

        @Nullable
        public List<? extends LineFragment> getFragments() {
            return this.myFragments;
        }
    }

    private static class PropertyRecord {
        @NotNull
        private final String myName;
        @Nullable
        private final String myBefore;
        @Nullable
        private final String myAfter;

        PropertyRecord(@NotNull String name, @Nullable String before, @Nullable String after) {
            assert (before != null || after != null);
            this.myName = name;
            this.myBefore = before;
            this.myAfter = after;
        }

        @NlsSafe
        @NotNull
        public String getName() {
            return this.myName;
        }

        @Nullable
        public String getBefore() {
            return this.myBefore;
        }

        @Nullable
        public String getAfter() {
            return this.myAfter;
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        @NotNull
        private final JBLabel myLabel = new JBLabel();

        MyDividerPainter() {
            this.myLabel.setFont(StartupUiUtil.getLabelFont());
            this.myLabel.setHorizontalAlignment(0);
            this.myLabel.setVerticalAlignment(1);
        }

        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics((Graphics)g, (Component)divider, (Component)SvnPropertiesDiffViewer.this.getEditor1().getComponent());
            Rectangle clip = gg.getClipBounds();
            if (clip == null) {
                return;
            }
            gg.setColor(DiffDrawUtil.getDividerColor());
            gg.fill(clip);
            EditorEx editor1 = SvnPropertiesDiffViewer.this.getEditor1();
            EditorEx editor2 = SvnPropertiesDiffViewer.this.getEditor2();
            JComponent header1 = editor1.getHeaderComponent();
            JComponent header2 = editor2.getHeaderComponent();
            int headerOffset1 = header1 == null ? 0 : header1.getHeight();
            int headerOffset2 = header2 == null ? 0 : header2.getHeight();
            int shift1 = editor1.getScrollingModel().getVerticalScrollOffset() - headerOffset1;
            int shift2 = editor2.getScrollingModel().getVerticalScrollOffset() - headerOffset2;
            double rotate = shift1 == shift2 ? 0.0 : Math.atan2(shift2 - shift1, clip.width);
            DiffDividerDrawUtil.paintPolygons((Graphics2D)gg, (int)divider.getWidth(), (rotate == 0.0 ? 1 : 0) != 0, (Editor)editor1, (Editor)editor2, (DiffDividerDrawUtil.DividerPaintable)this);
            for (DiffChange change : SvnPropertiesDiffViewer.this.myDiffChanges) {
                int y1 = editor1.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)change.getStartLine((Side)Side.LEFT), (int)0)).y - shift1;
                int y2 = editor2.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)change.getStartLine((Side)Side.RIGHT), (int)0)).y - shift2;
                int endY1 = editor1.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)change.getEndLine((Side)Side.LEFT), (int)0)).y - shift1;
                int endY2 = editor2.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)change.getEndLine((Side)Side.RIGHT), (int)0)).y - shift2;
                AffineTransform oldTransform = gg.getTransform();
                gg.translate(0, y1);
                if (rotate != 0.0) {
                    gg.rotate(-rotate);
                }
                this.myLabel.setText(change.getRecord().getName());
                this.myLabel.setForeground(this.getRecordTitleColor(change));
                this.myLabel.setBounds(clip);
                this.myLabel.paint((Graphics)gg);
                gg.setTransform(oldTransform);
                gg.setColor(JBColor.border());
                gg.drawLine(0, y1 - 1, clip.width, y2 - 1);
                gg.drawLine(0, endY1 - 1, clip.width, endY2 - 1);
            }
            gg.dispose();
        }

        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            for (DiffChange diffChange : SvnPropertiesDiffViewer.this.myDiffChanges) {
                TextDiffType type = this.getDiffType(diffChange);
                if (type == null) continue;
                int shift1 = diffChange.getStartLine(Side.LEFT);
                int shift2 = diffChange.getStartLine(Side.RIGHT);
                List<? extends LineFragment> fragments = diffChange.getFragments();
                if (fragments == null) continue;
                for (LineFragment lineFragment : diffChange.getFragments()) {
                    if (handler.process(Side.LEFT.getStartLine(lineFragment) + shift1, Side.LEFT.getEndLine(lineFragment) + shift1, Side.RIGHT.getStartLine(lineFragment) + shift2, Side.RIGHT.getEndLine(lineFragment) + shift2, DiffUtil.getLineDiffType((LineFragment)lineFragment))) continue;
                    return;
                }
            }
        }

        @Nullable
        private Color getRecordTitleColor(@NotNull DiffChange change) {
            TextDiffType type = this.getDiffType(change);
            if (type == TextDiffType.INSERTED) {
                return FileStatus.ADDED.getColor();
            }
            if (type == TextDiffType.DELETED) {
                return FileStatus.DELETED.getColor();
            }
            if (type == TextDiffType.MODIFIED) {
                return FileStatus.MODIFIED.getColor();
            }
            return JBColor.black;
        }

        @Nullable
        public TextDiffType getDiffType(@NotNull DiffChange change) {
            if (change.getRecord().getBefore() == null) {
                return TextDiffType.INSERTED;
            }
            if (change.getRecord().getAfter() == null) {
                return TextDiffType.DELETED;
            }
            if (change.getFragments() != null && !change.getFragments().isEmpty()) {
                return TextDiffType.MODIFIED;
            }
            return null;
        }
    }
}

