/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browserCache;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vcs.VcsException;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.Loader;
import org.jetbrains.idea.svn.dialogs.browserCache.NodeLoadState;
import org.jetbrains.idea.svn.dialogs.browserCache.RepositoryLoader;
import org.jetbrains.idea.svn.dialogs.browserCache.SvnRepositoryCache;

public class CacheLoader
extends Loader {
    @NotNull
    private final Loader myRepositoryLoader;

    public static Loader getInstance() {
        return (Loader)ApplicationManager.getApplication().getService(Loader.class);
    }

    public CacheLoader() {
        super(SvnRepositoryCache.getInstance());
        this.myRepositoryLoader = new RepositoryLoader(this.myCache);
    }

    @Override
    public void load(@NotNull RepositoryTreeNode node, @NotNull Expander expander) {
        SwingUtilities.invokeLater(() -> {
            VcsException error;
            List<DirectoryEntry> cached = this.myCache.getChildren(node.getURL());
            if (cached != null) {
                this.refreshNode(node, cached, expander);
            }
            if ((error = this.myCache.getError(node.getURL())) != null) {
                this.refreshNodeError(node, error);
            }
            this.myRepositoryLoader.load(node, expander);
        });
    }

    @Override
    @NotNull
    protected NodeLoadState getNodeLoadState() {
        return NodeLoadState.CACHED;
    }
}

