/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.WorkingCopyFormat;

public class UpgradeFormatDialog
extends DialogWrapper {
    private final ButtonGroup formatGroup = new ButtonGroup();
    private final List<JRadioButton> formatButtons = new ArrayList<JRadioButton>();
    private JBLoadingPanel myLoadingPanel;
    protected final File myPath;
    private final boolean isVersioned;

    public UpgradeFormatDialog(Project project, File path, boolean canBeParent) {
        this(project, path, canBeParent, true);
    }

    protected UpgradeFormatDialog(Project project, File path, boolean canBeParent, boolean initHere) {
        super(project, canBeParent);
        this.myPath = path;
        this.isVersioned = SvnUtil.seemsLikeVersionedDir(this.myPath);
        this.setResizable(false);
        this.setTitle(SvnBundle.message("dialog.upgrade.wcopy.format.title", new Object[0]));
        if (initHere) {
            this.init();
        }
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn.upgradeDialog";
    }

    public void setData(@NotNull WorkingCopyFormat selectedFormat) {
        for (JRadioButton button : this.formatButtons) {
            if (selectedFormat != UpgradeFormatDialog.getFormat(button)) continue;
            button.setSelected(true);
            break;
        }
    }

    public void setSupported(@NotNull Collection<WorkingCopyFormat> supported) {
        for (JRadioButton button : this.formatButtons) {
            button.setEnabled(supported.contains((Object)UpgradeFormatDialog.getFormat(button)));
        }
    }

    public void startLoading() {
        this.enableFormatButtons(false);
        this.getOKAction().setEnabled(false);
        this.myLoadingPanel.startLoading();
    }

    private void enableFormatButtons(boolean enabled) {
        for (JRadioButton button : this.formatButtons) {
            button.setEnabled(enabled);
        }
    }

    public void stopLoading() {
        this.getOKAction().setEnabled(true);
        this.myLoadingPanel.stopLoading();
    }

    @NlsContexts.Label
    @NotNull
    protected String getTopMessage() {
        return this.isVersioned ? SvnBundle.message("label.configure.upgrade.label", new Object[0]) : SvnBundle.message("label.configure.create.label", ApplicationNamesInfo.getInstance().getFullProductName());
    }

    @NlsContexts.RadioButton
    @NotNull
    protected String getFormatText(@NotNull WorkingCopyFormat format) {
        switch (format) {
            case ONE_DOT_SIX: {
                return this.isVersioned ? SvnBundle.message("radio.configure.upgrade.auto.16format", new Object[0]) : SvnBundle.message("radio.configure.create.auto.16format", new Object[0]);
            }
            case ONE_DOT_SEVEN: {
                return this.isVersioned ? SvnBundle.message("radio.configure.upgrade.auto.17format", new Object[0]) : SvnBundle.message("radio.configure.create.auto.17format", new Object[0]);
            }
            case ONE_DOT_EIGHT: {
                return this.isVersioned ? SvnBundle.message("radio.configure.upgrade.auto.18format", new Object[0]) : SvnBundle.message("radio.configure.create.auto.18format", new Object[0]);
            }
        }
        throw new IllegalArgumentException("unsupported format " + format);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        gb.insets = JBUI.insets((int)2);
        gb.weightx = 1.0;
        gb.weighty = 0.0;
        gb.gridwidth = 2;
        gb.gridheight = 1;
        gb.gridx = 0;
        gb.gridy = 0;
        gb.anchor = 17;
        gb.fill = 2;
        JLabel topLabel = new JLabel(this.getTopMessage());
        topLabel.setUI((LabelUI)new MultiLineLabelUI());
        panel2.add((Component)topLabel, gb);
        ++gb.gridy;
        this.registerFormat(WorkingCopyFormat.ONE_DOT_SIX, panel2, gb);
        this.registerFormat(WorkingCopyFormat.ONE_DOT_SEVEN, panel2, gb);
        this.registerFormat(WorkingCopyFormat.ONE_DOT_EIGHT, panel2, gb);
        JPanel auxiliaryPanel = this.getBottomAuxiliaryPanel();
        if (auxiliaryPanel != null) {
            panel2.add((Component)auxiliaryPanel, gb);
            ++gb.gridy;
        }
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), this.getDisposable());
        this.myLoadingPanel.add((Component)panel2, (Object)"Center");
        return this.myLoadingPanel;
    }

    private void registerFormat(@NotNull WorkingCopyFormat format, @NotNull JPanel panel2, @NotNull GridBagConstraints gb) {
        JRadioButton button = new JRadioButton(this.getFormatText(format));
        button.putClientProperty("format", (Object)format);
        panel2.add((Component)button, gb);
        ++gb.gridy;
        this.formatGroup.add(button);
        this.formatButtons.add(button);
    }

    @Nullable
    protected JPanel getBottomAuxiliaryPanel() {
        return null;
    }

    protected boolean showHints() {
        return true;
    }

    @NotNull
    private static WorkingCopyFormat getFormat(@NotNull JRadioButton button) {
        Object format = button.getClientProperty("format");
        return format instanceof WorkingCopyFormat ? (WorkingCopyFormat)((Object)format) : WorkingCopyFormat.UNKNOWN;
    }

    @NotNull
    public WorkingCopyFormat getUpgradeMode() {
        WorkingCopyFormat result = WorkingCopyFormat.UNKNOWN;
        for (JRadioButton button : this.formatButtons) {
            if (!button.isSelected()) continue;
            result = UpgradeFormatDialog.getFormat(button);
            break;
        }
        return result;
    }
}

