/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.net.ssl.CertificateInfoPanel;
import com.intellij.util.net.ssl.CertificateWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.security.cert.X509Certificate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.auth.AcceptResult;

public class ServerSSLDialog
extends DialogWrapper {
    @NotNull
    private final String myCertificateInfo;
    private Action myTempAction;
    private AcceptResult myResult;

    public ServerSSLDialog(Project project, @NotNull X509Certificate cert, boolean store) {
        this(project, ServerSSLDialog.getServerCertificateInfo(cert), store);
    }

    public ServerSSLDialog(Project project, @NotNull String certificateInfo, boolean store) {
        super(project, true);
        this.myCertificateInfo = certificateInfo;
        this.myResult = AcceptResult.REJECTED;
        this.setOKButtonText(SvnBundle.message("button.text.ssl.accept", new Object[0]));
        this.setOKActionEnabled(store);
        this.setCancelButtonText(SvnBundle.message("button.text.ssl.reject", new Object[0]));
        this.setTitle(SvnBundle.message("dialog.title.ssl.examine.server.crertificate", new Object[0]));
        this.setResizable(true);
        this.init();
    }

    public boolean shouldCloseOnCross() {
        return false;
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{this.getOKAction(), this.getTempAction(), this.getCancelAction()};
    }

    private Action getTempAction() {
        if (this.myTempAction == null) {
            this.myTempAction = new AbstractAction(SvnBundle.message("server.ssl.accept.temporary.action.name", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ServerSSLDialog.this.myResult = AcceptResult.ACCEPTED_TEMPORARILY;
                    ServerSSLDialog.this.close(0);
                }
            };
        }
        return this.myTempAction;
    }

    protected void doOKAction() {
        this.myResult = AcceptResult.ACCEPTED_PERMANENTLY;
        super.doOKAction();
    }

    public void doCancelAction() {
        this.myResult = AcceptResult.REJECTED;
        super.doCancelAction();
    }

    public AcceptResult getResult() {
        return this.myResult;
    }

    protected String getDimensionServiceKey() {
        return "svn.sslDialog";
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(5, 5));
        panel2.add((Component)new JLabel(SvnBundle.message("label.ssl.server.provided.certificate", new Object[0])), "North");
        JTextArea area = new JTextArea(5, 50);
        area.setText(this.myCertificateInfo);
        area.setEditable(false);
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)area), "Center");
        return panel2;
    }

    @NotNull
    private static String getServerCertificateInfo(@NotNull X509Certificate cert) {
        return " - Subject: " + cert.getSubjectDN().getName() + '\n' + " - Valid: " + "from " + cert.getNotBefore() + " until " + cert.getNotAfter() + '\n' + " - Issuer: " + cert.getIssuerDN().getName() + '\n' + " - Fingerprint: " + CertificateInfoPanel.formatHex((String)new CertificateWrapper(cert).getSha1Fingerprint(), (boolean)false);
    }
}

