/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.auth.AcceptResult;

public class ServerSSHDialog
extends DialogWrapper {
    private AcceptResult myResult;
    @NlsSafe
    @NotNull
    private final String myFingerprints;
    private JCheckBox myJCheckBox;
    private final boolean myStore;
    private final String myHost;
    private final String myAlgorithm;

    public ServerSSHDialog(Project project, boolean store, @NotNull String host, @Nullable String algorithm, @NlsSafe @NotNull String fingerprints) {
        super(project, true);
        this.myStore = store;
        this.myHost = host;
        this.myAlgorithm = StringUtil.notNullize((String)algorithm);
        this.myFingerprints = fingerprints;
        this.myResult = AcceptResult.REJECTED;
        this.setOKButtonText(SvnBundle.message("button.text.ssh.accept", new Object[0]));
        this.setCancelButtonText(SvnBundle.message("button.text.ssh.reject", new Object[0]));
        this.setTitle(SvnBundle.message("dialog.title.ssh.examine.server.fingerprints", new Object[0]));
        this.init();
        this.setResizable(false);
    }

    public boolean shouldCloseOnCross() {
        return false;
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    protected void doOKAction() {
        this.myResult = this.myJCheckBox.isSelected() ? AcceptResult.ACCEPTED_PERMANENTLY : AcceptResult.ACCEPTED_TEMPORARILY;
        super.doOKAction();
    }

    public void doCancelAction() {
        this.myResult = AcceptResult.REJECTED;
        super.doCancelAction();
    }

    public AcceptResult getResult() {
        return this.myResult;
    }

    protected String getDimensionServiceKey() {
        return "org.jetbrains.idea.svn.dialogs.ServerSSHDialog";
    }

    protected JComponent createCenterPanel() {
        BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((int)5, (int)5);
        JPanel wrapper = new JPanel();
        BoxLayout boxLayout = new BoxLayout(wrapper, 1);
        wrapper.setLayout(boxLayout);
        JLabel label = new JLabel(SvnBundle.message("label.ssh.server.provided.fingerprints", this.myHost));
        wrapper.add(label);
        JLabel label2 = new JLabel(SvnBundle.message("label.ssh.server.provided.fingerprints2", this.myAlgorithm));
        wrapper.add(label2);
        JTextField textField = new JTextField(this.myFingerprints);
        textField.setEditable(false);
        textField.setBorder((Border)JBUI.Borders.empty((int)10, (int)0));
        wrapper.add(textField);
        JLabel label3 = new JLabel(SvnBundle.message("label.ssh.server.provided.fingerprints3", new Object[0]));
        label3.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
        wrapper.add(label3);
        panel2.add((Component)wrapper, "Center");
        this.myJCheckBox = new JCheckBox(SvnBundle.message("checkbox.svn.ssh.cache.fingerprint", new Object[0]));
        this.myJCheckBox.setSelected(this.myStore);
        this.myJCheckBox.setEnabled(this.myStore);
        panel2.add((Component)this.myJCheckBox, "South");
        return panel2;
    }
}

