/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopiesContent;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.branchConfig.SelectBranchPopup;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.ChangeFormatDialog;
import org.jetbrains.idea.svn.dialogs.SvnFormatWorker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.dialogs.WorkingCopyInfoPanel;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.QuickMergeInteractionImpl;

public class CopiesPanel
extends SimpleToolWindowPanel {
    private static final Logger LOG = Logger.getInstance(CopiesPanel.class);
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroupManager.getInstance().getNotificationGroup("Svn Roots Detection Errors");
    private static final String TOOLBAR_GROUP = "Svn.WorkingCopiesView.Toolbar";
    private static final String TOOLBAR_PLACE = "Svn.WorkingCopiesView";
    private final Project myProject;
    private final JPanel myPanel = new JBPanel((LayoutManager)new VerticalLayout(8));
    private boolean isRefreshing;
    @NonNls
    private static final String HELP_ID = "reference.vcs.svn.working.copies.information";
    @NonNls
    static final String CHANGE_FORMAT = "CHANGE_FORMAT";
    @NonNls
    static final String CLEANUP = "CLEANUP";
    @NonNls
    static final String FIX_DEPTH = "FIX_DEPTH";
    @NonNls
    static final String CONFIGURE_BRANCHES = "CONFIGURE_BRANCHES";
    @NonNls
    static final String MERGE_FROM = "MERGE_FROM";

    public CopiesPanel(@NotNull Project project) {
        super(false, true);
        this.myProject = project;
        this.myProject.getMessageBus().connect().subscribe(SvnVcs.ROOTS_RELOADED, this::rootsReloaded);
        this.myPanel.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myPanel));
        ActionGroup toolbarGroup = (ActionGroup)ActionManager.getInstance().getAction(TOOLBAR_GROUP);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar(TOOLBAR_PLACE, toolbarGroup, false);
        this.setToolbar(toolbar.getComponent());
        this.rootsReloaded(true);
        this.refresh();
    }

    @RequiresEdt
    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    @RequiresEdt
    public void refresh() {
        if (this.isRefreshing) {
            return;
        }
        this.isRefreshing = true;
        this.getVcs().invokeRefreshSvnRoots();
    }

    @NotNull
    private SvnVcs getVcs() {
        return SvnVcs.getInstance(this.myProject);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (PlatformCoreDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    private void rootsReloaded(boolean rootsChanged) {
        if (rootsChanged) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.doRefresh();
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(this::doRefresh);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.isRefreshing = false;
            }, ModalityState.NON_MODAL);
        }
    }

    private void doRefresh() {
        List<WCInfo> infoList = this.getVcs().getWcInfosWithErrors();
        boolean hasErrors = !this.getVcs().getSvnFileUrlMapping().getErrorRoots().isEmpty();
        List<WorkingCopyFormat> supportedFormats = this.getSupportedFormats();
        ApplicationManager.getApplication().invokeLater(() -> this.setWorkingCopies(infoList, hasErrors, supportedFormats), ModalityState.NON_MODAL);
    }

    @RequiresEdt
    private void setWorkingCopies(@NotNull List<WCInfo> infoList, boolean hasErrors, List<WorkingCopyFormat> supportedFormats) {
        infoList.sort(Comparator.comparing(WCInfo::getPath));
        this.updateList(infoList, supportedFormats);
        this.isRefreshing = false;
        this.showErrorNotification(hasErrors);
    }

    private void updateList(@NotNull List<WCInfo> infoList, @NotNull List<WorkingCopyFormat> supportedFormats) {
        this.myPanel.removeAll();
        for (final WCInfo wcInfo : infoList) {
            final Set<WorkingCopyFormat> upgradeFormats = CopiesPanel.getUpgradeFormats(wcInfo, supportedFormats);
            final WorkingCopyInfoPanel infoPanel = new WorkingCopyInfoPanel();
            infoPanel.setInfo(wcInfo);
            infoPanel.setUpgradeFormats(upgradeFormats);
            infoPanel.setFocusable(true);
            infoPanel.setBorder(null);
            infoPanel.update();
            infoPanel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    CopiesPanel.this.performAction(wcInfo, upgradeFormats, infoPanel, e.getDescription());
                }
            });
            this.myPanel.add((Component)((Object)infoPanel));
        }
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @NotNull
    private List<WorkingCopyFormat> getSupportedFormats() {
        ArrayList<WorkingCopyFormat> result = new ArrayList<WorkingCopyFormat>();
        ClientFactory factory = this.getVcs().getFactory();
        try {
            result.addAll(factory.createUpgradeClient().getSupportedFormats());
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    public static Set<WorkingCopyFormat> getUpgradeFormats(@NotNull WCInfo info2, @NotNull List<WorkingCopyFormat> supportedFormats) {
        EnumSet<WorkingCopyFormat> canUpgradeTo = EnumSet.noneOf(WorkingCopyFormat.class);
        for (WorkingCopyFormat format : supportedFormats) {
            if (!format.isOrGreater(info2.getFormat())) continue;
            canUpgradeTo.add(format);
        }
        canUpgradeTo.add(info2.getFormat());
        return canUpgradeTo;
    }

    private boolean checkRoot(@NotNull VirtualFile root, @NlsActions.ActionText @NotNull String actionName) {
        if (root.isValid()) {
            return true;
        }
        Messages.showWarningDialog((Project)this.myProject, (String)SvnBundle.message("dialog.message.invalid.working.copy.root", root.getPath()), (String)SvnBundle.message("dialog.title.can.not.invoke.action", actionName));
        return false;
    }

    private void performAction(@NotNull WCInfo wcInfo, @NotNull Collection<WorkingCopyFormat> upgradeFormats, @NotNull WorkingCopyInfoPanel infoPanel, @NonNls @Nullable String actionName) {
        if (CONFIGURE_BRANCHES.equals(actionName)) {
            this.configureBranches(wcInfo);
        } else if (FIX_DEPTH.equals(actionName)) {
            this.fixDepth(wcInfo);
        } else if (CHANGE_FORMAT.equals(actionName)) {
            this.changeFormat(wcInfo, upgradeFormats);
        } else if (MERGE_FROM.equals(actionName)) {
            this.mergeFrom(wcInfo, infoPanel);
        } else if (CLEANUP.equals(actionName)) {
            this.cleanup(wcInfo);
        }
    }

    private void configureBranches(@NotNull WCInfo info2) {
        VirtualFile root = info2.getRootInfo().getVirtualFile();
        if (!this.checkRoot(root, SvnBundle.message("action.name.configure.branches", new Object[0]))) {
            return;
        }
        BranchConfigurationDialog.configureBranches(this.myProject, root);
    }

    private void fixDepth(@NotNull WCInfo info2) {
        int result = Messages.showOkCancelDialog((Project)this.myProject, (String)SvnBundle.message("dialog.message.set.working.copy.infinity.depth", info2.getPath()), (String)SvnBundle.message("dialog.title.set.working.copy.infinity.depth", new Object[0]), (Icon)Messages.getWarningIcon());
        if (result == 0) {
            SvnCheckoutProvider.checkout(this.myProject, new File(info2.getPath()), info2.getUrl(), Revision.HEAD, Depth.INFINITY, false, null, info2.getFormat());
        }
    }

    private void mergeFrom(@NotNull WCInfo info2, @NotNull WorkingCopyInfoPanel infoPanel) {
        VirtualFile root = info2.getRootInfo().getVirtualFile();
        if (!this.checkRoot(root, SvnBundle.message("action.name.merge.from", new Object[0]))) {
            return;
        }
        SelectBranchPopup.showForBranchRoot(this.myProject, root, (project, configuration, branchUrl, revision) -> {
            try {
                Url workingCopyUrlInSelectedBranch = CopiesPanel.getCorrespondingUrlInOtherBranch(configuration, info2.getUrl(), branchUrl);
                MergeContext mergeContext = new MergeContext(this.getVcs(), workingCopyUrlInSelectedBranch, info2, branchUrl.getTail(), root);
                new QuickMerge(mergeContext, new QuickMergeInteractionImpl(mergeContext)).execute();
            }
            catch (SvnBindException e) {
                AbstractVcsHelper.getInstance((Project)this.myProject).showError((VcsException)e, SvnBundle.message("dialog.title.merge.from.branch", branchUrl.getTail()));
            }
        }, SvnBundle.message("popup.title.select.branch", new Object[0]), (Component)((Object)infoPanel));
    }

    private void cleanup(@NotNull WCInfo info2) {
        VirtualFile root = info2.getRootInfo().getVirtualFile();
        if (!this.checkRoot(root, SvnBundle.message("cleanup.action.name", new Object[0]))) {
            return;
        }
        new CleanupWorker(this.getVcs(), Collections.singletonList(root)).execute();
    }

    @NotNull
    private static Url getCorrespondingUrlInOtherBranch(@NotNull SvnBranchConfigurationNew configuration, @NotNull Url url, @NotNull Url otherBranchUrl) throws SvnBindException {
        return otherBranchUrl.appendPath(StringUtil.notNullize((String)configuration.getRelativeUrl(url)), false);
    }

    private void changeFormat(@NotNull WCInfo wcInfo, @NotNull Collection<WorkingCopyFormat> supportedFormats) {
        ChangeFormatDialog dialog = new ChangeFormatDialog(this.myProject, new File(wcInfo.getPath()), false, !wcInfo.isIsWcRoot());
        dialog.setSupported(supportedFormats);
        dialog.setData(wcInfo.getFormat());
        if (!dialog.showAndGet()) {
            return;
        }
        WorkingCopyFormat newFormat = dialog.getUpgradeMode();
        if (!wcInfo.getFormat().equals((Object)newFormat)) {
            StoreUtil.saveDocumentsAndProjectSettings((Project)this.myProject);
            SvnFormatWorker task = new SvnFormatWorker(this.myProject, newFormat, wcInfo){

                @Override
                public void onSuccess() {
                    super.onSuccess();
                    CopiesPanel.this.refresh();
                }
            };
            ProgressManager.getInstance().run((Task)task);
        }
    }

    private void showErrorNotification(boolean hasErrors) {
        NotificationsManager manager = NotificationsManager.getNotificationsManager();
        ErrorsFoundNotification[] notifications = (ErrorsFoundNotification[])manager.getNotificationsOfType(ErrorsFoundNotification.class, this.myProject);
        if (hasErrors) {
            if (notifications.length == 0) {
                new ErrorsFoundNotification(this.myProject).notify(this.myProject.isDefault() ? null : this.myProject);
            }
        } else {
            for (ErrorsFoundNotification notification : notifications) {
                notification.expire();
            }
        }
    }

    private static final class ErrorsFoundNotification
    extends Notification {
        private ErrorsFoundNotification(@NotNull Project project) {
            super(NOTIFICATION_GROUP.getDisplayId(), "", SvnBundle.message("subversion.roots.detection.errors.found.description", new Object[0]), NotificationType.ERROR);
            this.addAction((AnAction)NotificationAction.createSimpleExpiring((String)SvnBundle.message("subversion.roots.detection.errors.found.action.text", new Object[0]), () -> WorkingCopiesContent.show(project)));
        }
    }
}

