/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class AddRepositoryLocationDialog
extends DialogWrapper {
    @NotNull
    private final List<String> myPreviousLocations;
    private JComboBox<String> myCombo;
    private Url mySelected;
    private JTextField myComboField;

    public AddRepositoryLocationDialog(@NotNull Project project, @NotNull List<String> values) {
        super(project, true);
        this.myPreviousLocations = ContainerUtil.sorted(values);
        this.init();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCombo;
    }

    protected JComponent createCenterPanel() {
        JLabel selectText = new JLabel(SvnBundle.message("repository.browser.add.location.prompt", new Object[0]));
        selectText.setUI((LabelUI)new MultiLineLabelUI());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)5), 0, 0);
        mainPanel.add((Component)selectText, gb);
        ++gb.gridy;
        this.myCombo = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(this.myPreviousLocations));
        this.myCombo.setEditable(true);
        this.myCombo.setMinimumSize((Dimension)JBUI.size((int)250, (int)20));
        gb.fill = 2;
        mainPanel.add(this.myCombo, gb);
        gb.fill = 0;
        this.myComboField = (JTextField)this.myCombo.getEditor().getEditorComponent();
        JPanel wrapper = new JPanel(new GridBagLayout());
        wrapper.add((Component)mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        wrapper.setPreferredSize((Dimension)JBUI.size((int)400, (int)70));
        return wrapper;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        try {
            this.mySelected = SvnUtil.createUrl(this.myComboField.getText().trim(), false);
            return null;
        }
        catch (SvnBindException e) {
            return new ValidationInfo(SvnBundle.message("dialog.message.could.not.parse.url", new Object[0]), this.myCombo);
        }
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    @Nullable
    public Url getSelected() {
        return this.mySelected;
    }

    public void setSelected(@NotNull Url url) {
        this.myComboField.setText(url.toDecodedString());
    }
}

