/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.config;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Path;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.config.GroupsValidator;
import org.jetbrains.idea.svn.config.ServersFileManager;
import org.jetbrains.idea.svn.config.SvnConfigureProxiesComponent;
import org.jetbrains.idea.svn.config.SvnIniFile;
import org.jetbrains.idea.svn.config.TestConnectionPerformer;
import org.jetbrains.idea.svn.config.ValidationListener;

public class SvnConfigureProxiesDialog
extends DialogWrapper
implements ValidationListener,
TestConnectionPerformer {
    private final SvnConfigureProxiesComponent mySystemTab;
    private final SvnConfigureProxiesComponent myUserTab;
    private JPanel myPanel;
    private JTabbedPane myTabbedPane;
    private final GroupsValidator myValidator;
    private final Project myProject;
    private boolean valid = true;

    public SvnConfigureProxiesDialog(Project project) {
        super(project, true);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(SvnBundle.message("dialog.title.edit.http.proxies.settings", objectArray));
        ServersFileManager systemManager = new ServersFileManager(new SvnIniFile(((Path)SvnUtil.SYSTEM_CONFIGURATION_PATH.getValue()).resolve("servers")));
        ServersFileManager userManager = new ServersFileManager(SvnConfiguration.getInstance(project).getServersFile());
        this.myValidator = new GroupsValidator(this);
        this.mySystemTab = new SvnConfigureProxiesComponent(systemManager, this.myValidator, this);
        this.myUserTab = new SvnConfigureProxiesComponent(userManager, this.myValidator, this);
        this.init();
        this.mySystemTab.reset();
        this.myUserTab.reset();
        this.myValidator.run();
    }

    @Override
    public void onError(@NotNull String text, @NotNull JComponent component, boolean forbidSave) {
        this.myTabbedPane.setSelectedComponent(component);
        String errorPrefix = this.myTabbedPane.getTitleAt(this.myTabbedPane.indexOfComponent(component)) + ": ";
        this.setOKActionEnabled(!forbidSave);
        this.setInvalid(errorPrefix + text, this.myTabbedPane);
    }

    @Override
    public void onSuccess() {
        if (this.isVisible()) {
            this.setOKActionEnabled(true);
            this.setInvalid(null, null);
        }
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    private boolean applyToTab(SvnConfigureProxiesComponent component) {
        try {
            component.apply();
        }
        catch (ConfigurationException e) {
            this.myTabbedPane.setSelectedComponent(component.createComponent());
            this.setInvalid(e.getMessage(), this.myTabbedPane);
            return false;
        }
        return true;
    }

    public void doCancelAction() {
        this.myValidator.stop();
        super.doCancelAction();
    }

    private boolean applyImpl() {
        if (!this.applyToTab(this.myUserTab)) {
            return false;
        }
        return this.applyToTab(this.mySystemTab);
    }

    protected void doOKAction() {
        if (this.getOKAction().isEnabled()) {
            if (!this.applyImpl()) {
                return;
            }
            this.myValidator.stop();
            this.close(0);
        }
    }

    @Override
    public void execute(String url) {
        Messages.showInfoMessage((Project)this.myProject, (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.settings.will.be.stored.text", new Object[0]), (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.settings.will.be.stored.title", new Object[0]));
        if (!this.applyImpl()) {
            return;
        }
        Ref excRef = new Ref();
        ProgressManager pm = ProgressManager.getInstance();
        pm.runProcessWithProgressSynchronously(() -> {
            ProgressIndicator pi = pm.getProgressIndicator();
            if (pi != null) {
                pi.setText(SvnBundle.message("progress.message.connecting.to.url", url));
            }
            try {
                SvnVcs.getInstance(this.myProject).getInfo(SvnUtil.createUrl(url), Revision.HEAD);
            }
            catch (SvnBindException e) {
                excRef.set((Object)e);
            }
        }, SvnBundle.message("progress.title.test.connection", new Object[0]), true, this.myProject);
        if (!excRef.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)((Exception)excRef.get()).getMessage(), (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.error.title", new Object[0]));
        } else {
            Messages.showInfoMessage((Project)this.myProject, (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.success.text", new Object[0]), (String)SvnBundle.message("dialog.edit.http.proxies.settings.test.connection.success.title", new Object[0]));
        }
    }

    private void setInvalid(@NlsContexts.DialogMessage @Nullable String text, @Nullable JComponent component) {
        this.valid = StringUtil.isEmptyOrSpaces((String)text);
        this.setErrorText(text, component);
    }

    @Override
    public boolean enabled() {
        return this.valid;
    }

    protected JComponent createCenterPanel() {
        this.myTabbedPane = new JBTabbedPane();
        this.myTabbedPane.add((Component)this.myUserTab.createComponent(), SvnBundle.message("dialog.edit.http.proxies.settings.tab.edit.user.file.title", new Object[0]));
        this.myTabbedPane.add((Component)this.mySystemTab.createComponent(), SvnBundle.message("dialog.edit.http.proxies.settings.tab.edit.system.file.title", new Object[0]));
        this.myPanel.add((Component)this.myTabbedPane, "North");
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setAlignmentX(0.5f);
        jPanel.setMinimumSize(new Dimension(820, 630));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

