/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BinaryOutputReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnProcessHandler
extends OSProcessHandler {
    private final boolean myForceUtf8;
    private final boolean myForceBinary;
    @NotNull
    private final ByteArrayOutputStream myBinaryOutput;

    public SvnProcessHandler(@NotNull Process process2, @NotNull String commandLine, boolean forceUtf8, boolean forceBinary) {
        super(process2, commandLine);
        this.myForceUtf8 = forceUtf8;
        this.myForceBinary = forceBinary;
        this.myBinaryOutput = new ByteArrayOutputStream();
    }

    @NotNull
    public ByteArrayOutputStream getBinaryOutput() {
        return this.myBinaryOutput;
    }

    @Nullable
    public Charset getCharset() {
        return this.myForceUtf8 ? StandardCharsets.UTF_8 : super.getCharset();
    }

    @NotNull
    protected BaseDataReader createOutputDataReader() {
        if (this.myForceBinary) {
            return new SimpleBinaryOutputReader(this.myProcess.getInputStream(), this.readerOptions().policy());
        }
        return super.createOutputDataReader();
    }

    private final class SimpleBinaryOutputReader
    extends BinaryOutputReader {
        private SimpleBinaryOutputReader(@NotNull InputStream stream, BaseDataReader.SleepingPolicy sleepingPolicy) {
            super(stream, sleepingPolicy);
            this.start(SvnProcessHandler.this.myPresentableName);
        }

        protected void onBinaryAvailable(byte @NotNull [] data, int size) {
            SvnProcessHandler.this.myBinaryOutput.write(data, 0, size);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            return SvnProcessHandler.this.executeTask(runnable);
        }
    }
}

