/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkout;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.CloneableProjectsService;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.ExclusiveBackgroundVcsAction;
import org.jetbrains.idea.svn.actions.SvnExcludingIgnoredOperation;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkin.IdeaCommitHandler;
import org.jetbrains.idea.svn.checkout.CheckoutEventHandler;
import org.jetbrains.idea.svn.checkout.ExportClient;
import org.jetbrains.idea.svn.dialogs.CheckoutDialog;
import org.jetbrains.idea.svn.dialogs.SvnCloneDialogExtension;
import org.jetbrains.idea.svn.dialogs.UpgradeFormatDialog;

public class SvnCheckoutProvider
implements CheckoutProvider {
    public void doCheckout(@NotNull Project project, CheckoutProvider.Listener listener2) {
        CheckoutDialog dialog = new CheckoutDialog(project, listener2);
        dialog.show();
    }

    @Deprecated(forRemoval=true)
    public static void doCheckout(@NotNull Project project, @NotNull File target, String url, Revision revision, Depth depth, boolean ignoreExternals, @Nullable CheckoutProvider.Listener listener2) {
        SvnCheckoutProvider.doCheckout(project, target, SvnUtil.parseUrl(url), revision, depth, ignoreExternals, listener2);
    }

    public static void doCheckout(@NotNull Project project, @NotNull File target, @NotNull Url url, Revision revision, Depth depth, boolean ignoreExternals, @Nullable CheckoutProvider.Listener listener2) {
        WorkingCopyFormat selectedFormat;
        if (!target.exists()) {
            target.mkdirs();
        }
        if ((selectedFormat = SvnCheckoutProvider.promptForWCopyFormat(target, project)) != WorkingCopyFormat.UNKNOWN) {
            SvnCheckoutProvider.checkout(project, target, url, revision, depth, ignoreExternals, listener2, selectedFormat);
        }
    }

    @NotNull
    public static ClientFactory getFactory(@NotNull SvnVcs vcs) {
        return vcs.getFactoryFromSettings();
    }

    public static void checkout(final Project project, final File target, final @NotNull Url url, final Revision revision, final Depth depth, final boolean ignoreExternals, final CheckoutProvider.Listener listener2, final WorkingCopyFormat selectedFormat) {
        String projectAbsolutePath = target.getAbsolutePath();
        String projectPath = FileUtilRt.toSystemIndependentName((String)projectAbsolutePath);
        CloneableProjectsService.CloneTask cloneTask = new CloneableProjectsService.CloneTask(){
            final Ref<Boolean> checkoutSuccessful = new Ref();

            @NotNull
            public CloneableProjectsService.CloneTaskInfo taskInfo() {
                return new CloneableProjectsService.CloneTaskInfo(SvnBundle.message("progress.title.check.out", new Object[0]), SvnBundle.message("progress.title.check.out.cancel", new Object[0]), SvnBundle.message("checkout.repository", new Object[0]), SvnBundle.message("checkout.repository.tooltip", new Object[0]), SvnBundle.message("checkout.repository.failed", new Object[0]), SvnBundle.message("checkout.repository.canceled", new Object[0]), SvnBundle.message("checkout.stop.message.title", new Object[0]), SvnBundle.message("checkout.stop.message.description", url.toString()));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public CloneableProjectsService.CloneStatus run(@NotNull ProgressIndicator indicator) {
                WorkingCopyFormat format = selectedFormat == null ? WorkingCopyFormat.UNKNOWN : selectedFormat;
                SvnVcs vcs = SvnVcs.getInstance(project);
                CheckoutEventHandler handler = new CheckoutEventHandler(vcs, false, ProgressManager.getInstance().getProgressIndicator());
                indicator.setText(SvnBundle.message("progress.text.checking.out", target.getAbsolutePath()));
                try {
                    SvnCheckoutProvider.getFactory(vcs).createCheckoutClient().checkout(Target.on(url), target, revision, depth, ignoreExternals, true, format, handler);
                    this.checkoutSuccessful.set((Object)Boolean.TRUE);
                    CloneableProjectsService.CloneStatus cloneStatus = CloneableProjectsService.CloneStatus.SUCCESS;
                    return cloneStatus;
                }
                catch (VcsException exception) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.checkout", exception.getMessage()), (String)SvnBundle.message("dialog.title.check.out", new Object[0])));
                    CloneableProjectsService.CloneStatus cloneStatus = CloneableProjectsService.CloneStatus.FAILURE;
                    return cloneStatus;
                }
                finally {
                    VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(target);
                    if (vf != null) {
                        vf.refresh(true, true, () -> ApplicationManager.getApplication().invokeLater(() -> this.notifyListener()));
                    } else {
                        this.notifyListener();
                    }
                }
            }

            private void notifyListener() {
                SvnCheckoutProvider.notifyRootManagerIfUnderProject(project, target);
                if (listener2 != null) {
                    if (!this.checkoutSuccessful.isNull()) {
                        listener2.directoryCheckedOut(target, SvnVcs.getKey());
                    }
                    listener2.checkoutCompleted();
                }
            }
        };
        CloneableProjectsService.getInstance().runCloneTask(projectPath, cloneTask);
    }

    private static void notifyRootManagerIfUnderProject(@NotNull Project project, @NotNull File directory) {
        VirtualFile[] files;
        if (project.isDefault()) {
            return;
        }
        for (VirtualFile file : files = SvnVcs.getInstance(project).getSvnFileUrlMapping().getNotFilteredRoots()) {
            if (!FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)file), (File)directory, (boolean)false)) continue;
            ProjectLevelVcsManagerEx.getInstanceEx((Project)project).fireDirectoryMappingsChanged();
            return;
        }
    }

    @RequiresEdt
    @NotNull
    public static WorkingCopyFormat promptForWCopyFormat(@NotNull File target, @NotNull Project project) {
        return new CheckoutFormatFromUserProvider(project, target).prompt();
    }

    public static void doExport(Project project, File target, Url url, Depth depth, boolean ignoreExternals, boolean force, String eolStyle) {
        try {
            VcsException[] exception = new VcsException[1];
            SvnVcs vcs = SvnVcs.getInstance(project);
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                CheckoutEventHandler handler = new CheckoutEventHandler(vcs, true, progressIndicator);
                try {
                    progressIndicator.setText(SvnBundle.message("progress.text.export", target.getAbsolutePath()));
                    Target from = Target.on(url);
                    ExportClient client = vcs.getFactoryFromSettings().createExportClient();
                    client.export(from, target, Revision.HEAD, depth, eolStyle, force, ignoreExternals, handler);
                }
                catch (VcsException e) {
                    exception[0] = e;
                }
            }, SvnBundle.message("message.title.export", new Object[0]), true, project);
            if (exception[0] != null) {
                throw exception[0];
            }
        }
        catch (VcsException e1) {
            Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.export", e1.getMessage()), (String)SvnBundle.message("message.title.export", new Object[0]));
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void doImport(Project project, File target, Url url, Depth depth, boolean includeIgnored, String message) {
        @Nls Ref errorMessage = new Ref();
        SvnVcs vcs = SvnVcs.getInstance(project);
        String targetPath = target.getAbsolutePath();
        ExclusiveBackgroundVcsAction.run(project, () -> ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            FileIndexFacade facade = (FileIndexFacade)project.getService(FileIndexFacade.class);
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            try {
                progressIndicator.setText(SvnBundle.message("progress.text.import", targetPath));
                VirtualFile targetVf = SvnUtil.getVirtualFile(targetPath);
                if (targetVf == null) {
                    errorMessage.set((Object)SvnBundle.message("error.can.not.find.file", targetPath));
                } else {
                    boolean isInContent = (Boolean)ReadAction.compute(() -> facade.isInContent(targetVf));
                    IdeaCommitHandler handler = new IdeaCommitHandler(progressIndicator);
                    boolean useFileFilter = !project.isDefault() && isInContent;
                    MyFilter filter = useFileFilter ? new MyFilter(new SvnExcludingIgnoredOperation.Filter(project)) : null;
                    long revision = vcs.getFactoryFromSettings().createImportClient().doImport(target, url, depth, message, includeIgnored, handler, filter);
                    if (revision > 0L) {
                        StatusBar.Info.set((String)SvnBundle.message("status.text.committed.revision", revision), (Project)project);
                    }
                }
            }
            catch (VcsException e) {
                errorMessage.set((Object)e.getMessage());
            }
        }, SvnBundle.message("message.title.import", new Object[0]), true, project));
        if (!errorMessage.isNull()) {
            Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.import", errorMessage.get()), (String)SvnBundle.message("message.title.import", new Object[0]));
        }
    }

    public String getVcsName() {
        return "_Subversion";
    }

    @NotNull
    public VcsCloneComponent buildVcsCloneComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        return new SvnCloneDialogExtension(project);
    }

    public static class CheckoutFormatFromUserProvider {
        @NotNull
        private final Project myProject;
        @NotNull
        private final SvnVcs myVcs;
        @NotNull
        private final File myPath;
        @NotNull
        private final AtomicReference<String> error;

        public CheckoutFormatFromUserProvider(@NotNull Project project, @NotNull File path) {
            this.myProject = project;
            this.myVcs = SvnVcs.getInstance(project);
            this.myPath = path;
            this.error = new AtomicReference();
        }

        @RequiresEdt
        public WorkingCopyFormat prompt() {
            assert (!ApplicationManager.getApplication().isUnitTestMode());
            WorkingCopyFormat result = this.displayUpgradeDialog();
            ((Runnable)BackgroundTaskUtil.syncPublisher(SvnVcs.WC_CONVERTED)).run();
            return result;
        }

        @NotNull
        private WorkingCopyFormat displayUpgradeDialog() {
            UpgradeFormatDialog dialog = new UpgradeFormatDialog(this.myProject, this.myPath, false);
            ModalityState dialogState = ModalityState.any();
            dialog.startLoading();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                List<WorkingCopyFormat> formats = this.loadSupportedFormats();
                ApplicationManager.getApplication().invokeLater(() -> {
                    String errorMessage = this.error.get();
                    if (errorMessage != null) {
                        dialog.doCancelAction();
                        Messages.showErrorDialog((String)SvnBundle.message("message.text.cannot.load.supported.formats", errorMessage), (String)SvnBundle.message("dialog.title.check.out", new Object[0]));
                    } else {
                        dialog.setSupported(formats);
                        dialog.setData((WorkingCopyFormat)((Object)((Object)((Object)ContainerUtil.getFirstItem((Collection)formats, (Object)((Object)WorkingCopyFormat.UNKNOWN))))));
                        dialog.stopLoading();
                    }
                }, dialogState);
            });
            return dialog.showAndGet() ? dialog.getUpgradeMode() : WorkingCopyFormat.UNKNOWN;
        }

        @NotNull
        private List<WorkingCopyFormat> loadSupportedFormats() {
            ArrayList<WorkingCopyFormat> result = new ArrayList<WorkingCopyFormat>();
            try {
                result.addAll(this.myVcs.getFactoryFromSettings().createCheckoutClient().getSupportedFormats());
            }
            catch (VcsException e) {
                this.error.set(e.getMessage());
            }
            return result;
        }
    }

    private static final class MyFilter
    implements Predicate<File> {
        @NotNull
        private final LocalFileSystem myLfs = LocalFileSystem.getInstance();
        @NotNull
        private final SvnExcludingIgnoredOperation.Filter myFilter;

        private MyFilter(@NotNull SvnExcludingIgnoredOperation.Filter filter) {
            this.myFilter = filter;
        }

        @Override
        public boolean test(@NotNull File file) {
            VirtualFile vf = this.myLfs.findFileByIoFile(file);
            return vf != null && this.myFilter.accept(vf);
        }
    }
}

