/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;

public final class SvnCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance(SvnCheckinEnvironment.class);
    @NotNull
    private final SvnVcs mySvnVcs;

    public SvnCheckinEnvironment(@NotNull SvnVcs svnVcs) {
        this.mySvnVcs = svnVcs;
    }

    @NotNull
    public RefreshableOnComponent createCommitOptions(@NotNull CheckinProjectPanel commitPanel, @NotNull CommitContext commitContext) {
        return new KeepLocksComponent();
    }

    @Nullable
    public String getHelpId() {
        return null;
    }

    private void doCommit(@NotNull Collection<? extends FilePath> committables, String comment, List<VcsException> exception, @NotNull Set<? super String> feedback) {
        MultiMap<Pair<Url, WorkingCopyFormat>, ? extends FilePath> map = SvnUtil.splitIntoRepositoriesMap(this.mySvnVcs, committables, Convertor.self());
        for (Map.Entry entry : map.entrySet()) {
            try {
                this.doCommitOneRepo((Collection)entry.getValue(), comment, exception, feedback, (WorkingCopyFormat)((Object)((Pair)entry.getKey()).getSecond()));
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
                exception.add(e);
            }
        }
    }

    private void doCommitOneRepo(@NotNull Collection<? extends FilePath> committables, String comment, List<VcsException> exception, @NotNull Set<? super String> feedback, @NotNull WorkingCopyFormat format) throws VcsException {
        if (committables.isEmpty()) {
            return;
        }
        CommitInfo[] results = this.mySvnVcs.getFactory(format).createCheckinClient().commit(ChangesUtil.filePathsToFiles(committables), comment);
        StringBuilder committedRevisions = new StringBuilder();
        for (CommitInfo result : results) {
            if (result == CommitInfo.EMPTY || result.getRevisionNumber() <= 0L) continue;
            if (committedRevisions.length() > 0) {
                committedRevisions.append(", ");
            }
            committedRevisions.append(result.getRevisionNumber());
        }
        if (committedRevisions.length() > 0) {
            feedback.add("Subversion: " + SvnBundle.message("status.text.committed.revision", committedRevisions));
        }
    }

    @NotNull
    private Collection<FilePath> getCommitables(@NotNull List<? extends Change> changes) {
        Set result = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY);
        ChangesUtil.getPaths(changes.stream()).forEach(path -> {
            if (result.add(path)) {
                this.addParents(result, (FilePath)path);
            }
        });
        return result;
    }

    private void addParents(@NotNull Collection<FilePath> paths, @NotNull FilePath path) {
        FilePath parent = path;
        while ((parent = parent.getParentPath()) != null && this.isAddedOrReplaced(parent)) {
            paths.add(parent);
        }
    }

    private boolean isAddedOrReplaced(@NotNull FilePath file) {
        Status status = this.getStatus(file);
        return status != null && status.is(StatusType.STATUS_ADDED, StatusType.STATUS_REPLACED);
    }

    @Nullable
    private Status getStatus(@NotNull FilePath file) {
        Status result = null;
        try {
            result = this.mySvnVcs.getFactory(file.getIOFile()).createStatusClient().doStatus(file.getIOFile(), false);
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return result;
    }

    public String getCheckinOperationName() {
        return SvnBundle.message("checkin.operation.name", new Object[0]);
    }

    @NotNull
    public List<VcsException> commit(@NotNull List<? extends Change> changes, @NotNull String commitMessage, @NotNull CommitContext commitContext, @NotNull Set<? super String> feedback) {
        ArrayList<VcsException> exception = new ArrayList<VcsException>();
        Collection<FilePath> committables = this.getCommitables(changes);
        ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
        if (progress != null) {
            this.doCommit(committables, commitMessage, exception, feedback);
        } else if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> this.doCommit(committables, commitMessage, exception, feedback), SvnBundle.message("progress.title.commit", new Object[0]), false, this.mySvnVcs.getProject());
        } else {
            this.doCommit(committables, commitMessage, exception, feedback);
        }
        return exception;
    }

    public List<VcsException> scheduleMissingFileForDeletion(@NotNull List<? extends FilePath> filePaths) {
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        List files = ChangesUtil.filePathsToFiles(filePaths);
        for (File file : files) {
            try {
                this.mySvnVcs.getFactory(file).createDeleteClient().delete(file, true, false, null);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(@NotNull List<? extends VirtualFile> files) {
        return SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(this.mySvnVcs, files);
    }

    public static List<VcsException> scheduleUnversionedFilesForAddition(@NotNull SvnVcs vcs, List<? extends VirtualFile> files) {
        return SvnCheckinEnvironment.scheduleUnversionedFilesForAddition(vcs, files, false);
    }

    public static List<VcsException> scheduleUnversionedFilesForAddition(@NotNull SvnVcs vcs, List<? extends VirtualFile> files, boolean recursive) {
        files.sort((Comparator<? extends VirtualFile>)FilePathComparator.getInstance());
        SvnProgressCanceller eventHandler = new SvnProgressCanceller(){

            @Override
            public void consume(ProgressEvent event) {
                ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
                File file = event.getFile();
                if (indicator != null && file != null) {
                    indicator.setText(SvnBundle.message("progress.text2.adding", file.getName() + " (" + file.getParent() + ")"));
                }
            }
        };
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        Depth depth = Depth.allOrEmpty(recursive);
        for (VirtualFile virtualFile : files) {
            try {
                File convertedFile = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
                vcs.getFactory(convertedFile).createAddClient().add(convertedFile, depth, true, false, true, eventHandler);
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    private class KeepLocksComponent
    implements RefreshableOnComponent {
        @NotNull
        private final JCheckBox myKeepLocksBox;
        @NotNull
        private final JPanel myPanel = new JPanel(new BorderLayout());
        @NotNull
        private final JCheckBox myAutoUpdate;

        KeepLocksComponent() {
            this.myKeepLocksBox = new JCheckBox(SvnBundle.message("checkbox.checkin.keep.files.locked", new Object[0]));
            this.myAutoUpdate = new JCheckBox(SvnBundle.message("checkbox.checkin.auto.update.after.commit", new Object[0]));
            this.myPanel.add((Component)this.myAutoUpdate, "North");
            this.myPanel.add((Component)this.myKeepLocksBox, "Center");
        }

        public JComponent getComponent() {
            return this.myPanel;
        }

        public boolean isKeepLocks() {
            return this.myKeepLocksBox.isSelected();
        }

        public boolean isAutoUpdate() {
            return this.myAutoUpdate.isSelected();
        }

        public void saveState() {
            SvnConfiguration configuration = SvnCheckinEnvironment.this.mySvnVcs.getSvnConfiguration();
            configuration.setKeepLocks(this.isKeepLocks());
            configuration.setAutoUpdateAfterCommit(this.isAutoUpdate());
        }

        public void restoreState() {
            SvnConfiguration configuration = SvnCheckinEnvironment.this.mySvnVcs.getSvnConfiguration();
            this.myKeepLocksBox.setSelected(configuration.isKeepLocks());
            this.myAutoUpdate.setSelected(configuration.isAutoUpdateAfterCommit());
        }
    }
}

