/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.checkin;

import com.intellij.openapi.util.NlsSafe;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Revision;

public final class CommitInfo {
    public static final CommitInfo EMPTY = new Builder().setRevisionNumber(-1L).build();
    private final long myRevisionNumber;
    @NotNull
    private final Revision myRevision;
    private final Date myDate;
    private final String myAuthor;

    private CommitInfo(@NotNull Builder builder) {
        this.myRevisionNumber = builder.revisionNumber;
        this.myRevision = Revision.of(this.myRevisionNumber);
        this.myAuthor = builder.author;
        this.myDate = builder.date;
    }

    public long getRevisionNumber() {
        return this.myRevisionNumber;
    }

    @NotNull
    public Revision getRevision() {
        return this.myRevision;
    }

    @NlsSafe
    public String getAuthor() {
        return this.myAuthor;
    }

    public Date getDate() {
        return this.myDate;
    }

    @XmlAccessorType(value=XmlAccessType.NONE)
    @XmlType(name="commit")
    @XmlRootElement(name="commit")
    public static class Builder {
        @XmlAttribute(name="revision", required=true)
        private long revisionNumber;
        @XmlElement(name="author")
        private String author;
        @XmlElement(name="date")
        private Date date;

        public Builder() {
        }

        public Builder(long revisionNumber, Date date, String author) {
            this.revisionNumber = revisionNumber;
            this.date = date;
            this.author = author;
        }

        public long getRevisionNumber() {
            return this.revisionNumber;
        }

        public String getAuthor() {
            return this.author;
        }

        public Date getDate() {
            return this.date;
        }

        @NotNull
        public Builder setRevisionNumber(long revisionNumber) {
            this.revisionNumber = revisionNumber;
            return this;
        }

        @NotNull
        public Builder setAuthor(String author) {
            this.author = author;
            return this;
        }

        @NotNull
        public Builder setDate(Date date) {
            this.date = date;
            return this;
        }

        @NotNull
        public CommitInfo build() {
            return new CommitInfo(this);
        }
    }
}

