/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationData;
import org.jetbrains.idea.svn.auth.AuthenticationProvider;
import org.jetbrains.idea.svn.auth.ProxySvnAuthentication;
import org.jetbrains.idea.svn.config.SvnIniFile;

public final class SvnAuthenticationManager {
    @NonNls
    public static final String PASSWORD = "svn.simple";
    @NonNls
    public static final String SSL = "svn.ssl.client-passphrase";
    @NonNls
    public static final String SVN_SSH = "svn+ssh";
    @NonNls
    public static final String HTTP = "http";
    @NonNls
    public static final String HTTPS = "https";
    @NotNull
    private final Project myProject;
    @NotNull
    private final Path myConfigDirectory;
    private final NotNullLazyValue<Couple<SvnIniFile>> myConfigFile;
    private final NotNullLazyValue<Couple<SvnIniFile>> myServersFile;
    private AuthenticationProvider myProvider;
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;

    public SvnAuthenticationManager(@NotNull Project project, @NotNull Path configDirectory) {
        this.myProject = project;
        this.myConfigDirectory = configDirectory;
        this.myConfigFile = NotNullLazyValue.lazy(() -> {
            SvnIniFile userConfig = new SvnIniFile(this.myConfigDirectory.resolve("config"));
            SvnIniFile systemConfig = new SvnIniFile(((Path)SvnUtil.SYSTEM_CONFIGURATION_PATH.getValue()).resolve("config"));
            return Couple.of((Object)systemConfig, (Object)userConfig);
        });
        this.myServersFile = NotNullLazyValue.lazy(() -> {
            SvnIniFile userConfig = new SvnIniFile(this.myConfigDirectory.resolve("servers"));
            SvnIniFile systemConfig = new SvnIniFile(((Path)SvnUtil.SYSTEM_CONFIGURATION_PATH.getValue()).resolve("servers"));
            return Couple.of((Object)systemConfig, (Object)userConfig);
        });
    }

    public AuthenticationData requestFromCache(String kind, String realm) {
        return (AuthenticationData)SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(kind, realm);
    }

    public String getDefaultUsername() {
        return SystemProperties.getUserName();
    }

    public void setAuthenticationProvider(AuthenticationProvider provider) {
        this.myProvider = provider;
    }

    public AuthenticationProvider getProvider() {
        return this.myProvider;
    }

    @NotNull
    public HostOptions getHostOptions(@NotNull Url url) {
        return new HostOptions(url);
    }

    public void acknowledgeAuthentication(String kind, Url url, String realm, AuthenticationData authentication) {
        boolean authStorageEnabled = this.getHostOptions(url).isAuthStorageEnabled();
        AuthenticationData proxy = ProxySvnAuthentication.proxy(authentication, authStorageEnabled);
        SvnConfiguration.getInstance(this.myProject).acknowledge(kind, realm, proxy);
    }

    public int getReadTimeout(@NotNull Url url) {
        String protocol = url.getProtocol();
        if (HTTP.equals(protocol) || HTTPS.equals(protocol)) {
            String host = url.getHost();
            String timeout = SvnIniFile.getPropertyIdea(host, (Couple<SvnIniFile>)((Couple)this.myServersFile.getValue()), "http-timeout");
            if (timeout != null) {
                try {
                    return Integer.parseInt(timeout) * 1000;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 30000;
        }
        if (SVN_SSH.equals(protocol)) {
            return (int)SvnConfiguration.getInstance(this.myProject).getSshReadTimeout();
        }
        return 0;
    }

    public int getConnectTimeout(@NotNull Url url) {
        String protocol = url.getProtocol();
        if (SVN_SSH.equals(protocol)) {
            return (int)SvnConfiguration.getInstance(this.myProject).getSshConnectionTimeout();
        }
        return HTTP.equals(protocol) || HTTPS.equals(protocol) ? 60000 : 0;
    }

    public void warnOnAuthStorageDisabled() {
        VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)SvnBundle.message("svn.cannot.save.credentials.store-auth-creds", new Object[0]), (MessageType)MessageType.ERROR, (NamedRunnable[])new NamedRunnable[0]);
    }

    public final class HostOptions {
        @NotNull
        private final Url myUrl;

        private HostOptions(Url url) {
            this.myUrl = url;
        }

        public boolean isAuthStorageEnabled() {
            boolean storageEnabled;
            String perHostValue = SvnIniFile.getPropertyIdea(this.myUrl.getHost(), (Couple<SvnIniFile>)((Couple)SvnAuthenticationManager.this.myServersFile.getValue()), "store-auth-creds");
            boolean bl = storageEnabled = perHostValue != null ? SvnIniFile.isTurned(perHostValue, false) : SvnIniFile.isTurned(SvnIniFile.getValue((Couple<SvnIniFile>)((Couple)SvnAuthenticationManager.this.myConfigFile.getValue()), "auth", "store-auth-creds"), true);
            if (!storageEnabled) {
                SvnAuthenticationManager.this.warnOnAuthStorageDisabled();
            }
            return storageEnabled;
        }

        @Nullable
        public String getSSLClientCertFile() {
            return SvnIniFile.getPropertyIdea(this.myUrl.getHost(), (Couple<SvnIniFile>)((Couple)SvnAuthenticationManager.this.myServersFile.getValue()), "ssl-client-cert-file");
        }
    }
}

