/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.ClientOnlyTrustManager;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AcceptResult;
import org.jetbrains.idea.svn.auth.AuthenticationService;

public class CertificateTrustManager
extends ClientOnlyTrustManager {
    private static final Logger LOG = Logger.getInstance(CertificateTrustManager.class);
    @NonNls
    private static final String CMD_SSL_SERVER = "cmd.ssl.server";
    @NotNull
    private final AuthenticationService myAuthenticationService;
    @NotNull
    private final Url myRepositoryUrl;
    @NotNull
    private final String myRealm;

    public CertificateTrustManager(@NotNull AuthenticationService authenticationService, @NotNull Url repositoryUrl) {
        this.myAuthenticationService = authenticationService;
        this.myRepositoryUrl = repositoryUrl;
        this.myRealm = new URIBuilder().setScheme(repositoryUrl.getProtocol()).setHost(repositoryUrl.getHost()).setPort(repositoryUrl.getPort()).toString();
    }

    public void checkServerTrusted(X509Certificate @Nullable [] chain, String authType) throws CertificateException {
        X509Certificate certificate;
        if (chain != null && chain.length > 0 && chain[0] != null && !this.checkPassive(certificate = chain[0])) {
            if (!CertificateTrustManager.isAcceptedByIdea(chain, authType)) {
                this.checkActive(certificate);
            }
            this.acknowledge(certificate);
        }
    }

    private boolean checkPassive(@NotNull X509Certificate certificate) {
        Object cachedData = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(CMD_SSL_SERVER, this.myRealm);
        return certificate.equals(cachedData);
    }

    private static boolean isAcceptedByIdea(X509Certificate @NotNull [] chain, String authType) {
        boolean result;
        try {
            CertificateManager.getInstance().getTrustManager().checkServerTrusted(chain, authType, ConfirmingTrustManager.CertificateConfirmationParameters.doNotAskConfirmation());
            result = true;
        }
        catch (CertificateException e) {
            LOG.debug((Throwable)e);
            result = false;
        }
        return result;
    }

    private void checkActive(@NotNull X509Certificate certificate) throws CertificateException {
        boolean isStorageEnabled = this.myAuthenticationService.getAuthenticationManager().getHostOptions(this.myRepositoryUrl).isAuthStorageEnabled();
        AcceptResult result = this.myAuthenticationService.getAuthenticationManager().getProvider().acceptServerAuthentication(this.myRepositoryUrl, this.myRealm, certificate, isStorageEnabled);
        switch (result) {
            case ACCEPTED_PERMANENTLY: 
            case ACCEPTED_TEMPORARILY: {
                break;
            }
            case REJECTED: {
                throw new CertificateException("Server SSL certificate rejected");
            }
        }
    }

    private void acknowledge(@NotNull X509Certificate certificate) {
        this.myAuthenticationService.getVcs().getSvnConfiguration().acknowledge(CMD_SSL_SERVER, this.myRealm, certificate);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return CertificateManager.getInstance().getTrustManager().getAcceptedIssuers();
    }
}

