/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.status.StatusType;

public class ProgressEvent {
    private final File myFile;
    private final long myRevision;
    private final Url myURL;
    @NotNull
    private final StatusType myContentsStatus;
    @NotNull
    private final StatusType myPropertiesStatus;
    @Nullable
    private final String myErrorMessage;
    private final EventAction myAction;

    public ProgressEvent(@Nullable String errorMessage) {
        this(null, 0L, null, null, EventAction.SKIP, errorMessage, null);
    }

    public ProgressEvent(File file, long revision, @Nullable StatusType contentStatus, @Nullable StatusType propertiesStatus, EventAction action, @Nullable String errorMessage, Url url) {
        this.myFile = file != null ? file.getAbsoluteFile() : null;
        this.myRevision = revision;
        this.myContentsStatus = contentStatus == null ? StatusType.INAPPLICABLE : contentStatus;
        this.myPropertiesStatus = propertiesStatus == null ? StatusType.INAPPLICABLE : propertiesStatus;
        this.myAction = action;
        this.myErrorMessage = errorMessage;
        this.myURL = url;
    }

    public File getFile() {
        return this.myFile;
    }

    public EventAction getAction() {
        return this.myAction;
    }

    @NotNull
    public StatusType getContentsStatus() {
        return this.myContentsStatus;
    }

    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    @NotNull
    public StatusType getPropertiesStatus() {
        return this.myPropertiesStatus;
    }

    public long getRevision() {
        return this.myRevision;
    }

    public Url getURL() {
        return this.myURL;
    }

    @Nullable
    public String getPath() {
        return this.myFile != null ? this.myFile.getName() : (this.myURL != null ? this.myURL.toString() : null);
    }

    public String toString() {
        return this.getAction() + " " + this.getFile() + " " + this.getURL();
    }
}

