/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.containers.Convertor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;

public class FileStatusResultParser {
    @NotNull
    private final Pattern myLinePattern;
    @Nullable
    private final ProgressTracker handler;
    @NotNull
    private final Convertor<Matcher, ProgressEvent> myConvertor;

    public FileStatusResultParser(@NotNull Pattern linePattern, @Nullable ProgressTracker handler, @NotNull Convertor<Matcher, ProgressEvent> convertor) {
        this.myLinePattern = linePattern;
        this.handler = handler;
        this.myConvertor = convertor;
    }

    public void parse(@NotNull String output) throws VcsException {
        if (StringUtil.isEmpty((String)output)) {
            return;
        }
        for (String line : StringUtil.splitByLines((String)output)) {
            this.onLine(line);
        }
    }

    public void onLine(@NotNull String line) throws VcsException {
        Matcher matcher = this.myLinePattern.matcher(line);
        if (!matcher.matches()) {
            throw new VcsException(SvnBundle.message("error.parse.file.status.unknown.state.on.line", line));
        }
        this.process(matcher);
    }

    public void process(@NotNull Matcher matcher) throws VcsException {
        if (this.handler != null) {
            this.handler.consume((ProgressEvent)this.myConvertor.convert((Object)matcher));
        }
    }
}

