/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;

public enum Depth {
    UNKNOWN("unknown"),
    INFINITY("infinity"),
    IMMEDIATES("immediates"),
    FILES("files"),
    EMPTY("empty"),
    EXCLUDE("exclude");

    @NotNull
    private static final Map<String, Depth> ourAllDepths;
    @NonNls
    @NotNull
    private final String myName;

    private Depth(String name) {
        this.myName = name;
    }

    @NonNls
    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        switch (this) {
            case INFINITY: {
                return SvnBundle.message("label.depth.infinity", new Object[0]);
            }
            case IMMEDIATES: {
                return SvnBundle.message("label.depth.immediates", new Object[0]);
            }
            case FILES: {
                return SvnBundle.message("label.depth.files", new Object[0]);
            }
            case EMPTY: {
                return SvnBundle.message("label.depth.empty", new Object[0]);
            }
            case EXCLUDE: {
                return SvnBundle.message("label.depth.exclude", new Object[0]);
            }
        }
        return SvnBundle.message("label.depth.unknown", new Object[0]);
    }

    public String toString() {
        return this.myName;
    }

    private static void register(@NotNull Depth depth) {
        ourAllDepths.put(depth.myName, depth);
    }

    @NotNull
    public static Depth from(@NonNls @NotNull String depthName) {
        Depth result = ourAllDepths.get(depthName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown depth " + depthName);
        }
        return result;
    }

    @NotNull
    public static Depth allOrFiles(boolean recursive) {
        return recursive ? INFINITY : FILES;
    }

    @NotNull
    public static Depth allOrEmpty(boolean recursive) {
        return recursive ? INFINITY : EMPTY;
    }

    public static boolean isRecursive(@Nullable Depth depth) {
        return depth == null || depth == INFINITY || depth == UNKNOWN;
    }

    static {
        ourAllDepths = new HashMap<String, Depth>();
        for (Depth action : Depth.values()) {
            Depth.register(action);
        }
    }
}

