/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.dialogs.CopiesPanel;

public final class WorkingCopiesContent
implements ChangesViewContentProvider {
    @NotNull
    private final Project myProject;

    public WorkingCopiesContent(@NotNull Project project) {
        this.myProject = project;
    }

    public JComponent initContent() {
        return new CopiesPanel(this.myProject);
    }

    public static void show(@NotNull Project project) {
        ToolWindow window;
        ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
        if (manager != null && (window = manager.getToolWindow("Version Control")) != null) {
            window.show(null);
            ContentManager cm = window.getContentManager();
            Content content = cm.findContent(WorkingCopiesContent.getTabName());
            if (content != null) {
                cm.setSelectedContent(content, true);
            }
        }
    }

    @NotNull
    public static String getTabName() {
        return SvnBundle.message("dialog.show.svn.map.title", new Object[0]);
    }

    static final class DisplayNameSupplier
    implements Supplier<String> {
        DisplayNameSupplier() {
        }

        @Override
        public String get() {
            return SvnBundle.message("toolwindow.working.copies.info.title", new Object[0]);
        }
    }

    static final class VisibilityPredicate
    implements Predicate<Project> {
        VisibilityPredicate() {
        }

        @Override
        @NotNull
        public boolean test(@NotNull Project project) {
            return ProjectLevelVcsManager.getInstance((Project)project).checkVcsIsActive("svn");
        }
    }
}

