/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.FrameStateListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FilterDescendantVirtualFiles;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsAnnotationCachedProxy;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.RootsToWorkingCopies;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnChangeProvider;
import org.jetbrains.idea.svn.SvnChangelistListener;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnDiffProvider;
import org.jetbrains.idea.svn.SvnEditFileProvider;
import org.jetbrains.idea.svn.SvnEntriesFileListener;
import org.jetbrains.idea.svn.SvnFileStatus;
import org.jetbrains.idea.svn.SvnFileSystemListener;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnFilteringExceptionLogger;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnStatusUtil;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.UniqueRootsFilter;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.actions.CleanupWorker;
import org.jetbrains.idea.svn.actions.ExclusiveBackgroundVcsAction;
import org.jetbrains.idea.svn.actions.SvnMergeProvider;
import org.jetbrains.idea.svn.annotate.SvnAnnotationProvider;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.CmdClientFactory;
import org.jetbrains.idea.svn.api.CmdVersionClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.branchConfig.SvnLoadedBranchesStorage;
import org.jetbrains.idea.svn.checkin.SvnCheckinEnvironment;
import org.jetbrains.idea.svn.checkout.SvnCheckoutProvider;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnExecutableChecker;
import org.jetbrains.idea.svn.dialogs.WCInfo;
import org.jetbrains.idea.svn.history.LoadedRevisionsCache;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.history.SvnCommittedChangesProvider;
import org.jetbrains.idea.svn.history.SvnHistoryProvider;
import org.jetbrains.idea.svn.info.Info;
import org.jetbrains.idea.svn.info.InfoConsumer;
import org.jetbrains.idea.svn.integrate.SvnBranchPointsCalculator;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.rollback.SvnRollbackEnvironment;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusType;
import org.jetbrains.idea.svn.update.SvnIntegrateEnvironment;
import org.jetbrains.idea.svn.update.SvnUpdateEnvironment;

public final class SvnVcs
extends AbstractVcs {
    private static final Logger LOG = new SvnFilteringExceptionLogger(Logger.getInstance(SvnVcs.class));
    private static final Logger REFRESH_LOG = Logger.getInstance((String)"#svn_refresh");
    @NonNls
    @NotNull
    public static final String VCS_NAME = "svn";
    @NlsSafe
    @NotNull
    public static final String VCS_DISPLAY_NAME = "Subversion";
    @NlsSafe
    @NotNull
    private static final String VCS_SHORT_DISPLAY_NAME = "SVN";
    private static final VcsKey ourKey = SvnVcs.createKey((String)"svn");
    public static final Topic<Runnable> WC_CONVERTED = new Topic("WC_CONVERTED", Runnable.class);
    private final SvnEntriesFileListener myEntriesFileListener;
    private SvnFileSystemListener myFileOperationsHandler;
    private CheckinEnvironment myCheckinEnvironment;
    private RollbackEnvironment myRollbackEnvironment;
    private UpdateEnvironment mySvnUpdateEnvironment;
    private UpdateEnvironment mySvnIntegrateEnvironment;
    private AnnotationProvider myAnnotationProvider;
    private DiffProvider mySvnDiffProvider;
    private final VcsShowConfirmationOption myAddConfirmation;
    private final VcsShowConfirmationOption myDeleteConfirmation;
    private EditFileProvider myEditFilesProvider;
    private SvnCommittedChangesProvider myCommittedChangesProvider;
    private final VcsShowSettingOption myCheckoutOptions;
    private ChangeProvider myChangeProvider;
    private MergeProvider myMergeProvider;
    private final SvnChangelistListener myChangeListListener;
    private Disposable myFrameStateListenerDisposable;
    public static final Topic<Consumer> ROOTS_RELOADED = new Topic("ROOTS_RELOADED", Consumer.class);
    private SvnBranchPointsCalculator mySvnBranchPointsCalculator;
    private SvnCheckoutProvider myCheckoutProvider;
    @NotNull
    private final ClientFactory cmdClientFactory = new CmdClientFactory(this);
    private final boolean myLogExceptions;

    public SvnVcs(@NotNull Project project) {
        super(project, VCS_NAME);
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myAddConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, (AbstractVcs)this);
        this.myDeleteConfirmation = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, (AbstractVcs)this);
        this.myCheckoutOptions = vcsManager.getStandardOption(VcsConfiguration.StandardOption.CHECKOUT, (AbstractVcs)this);
        if (this.myProject.isDefault()) {
            this.myChangeListListener = null;
            this.myEntriesFileListener = null;
        } else {
            this.myEntriesFileListener = new SvnEntriesFileListener(project);
            this.myChangeListListener = new SvnChangelistListener(this);
        }
        Application app = ApplicationManager.getApplication();
        this.myLogExceptions = app != null && (app.isInternal() || app.isUnitTestMode());
    }

    private void postStartup() {
        if (this.myProject.isDefault()) {
            return;
        }
        if (!this.getSvnConfiguration().isCleanupRun()) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.cleanup17copies();
                this.getSvnConfiguration().setCleanupRun(true);
            }, ModalityState.NON_MODAL, this.myProject.getDisposed());
        } else {
            this.invokeRefreshSvnRoots();
        }
    }

    private void cleanup17copies() {
        Runnable callCleanupWorker = () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            new CleanupWorker(this, Collections.emptyList()){

                @Override
                protected void fillRoots() {
                    for (WCInfo info2 : SvnVcs.this.getAllWcInfos()) {
                        if (!WorkingCopyFormat.ONE_DOT_SEVEN.equals((Object)info2.getFormat())) continue;
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(info2.getRootInfo().getIoFile());
                        if (file == null) {
                            LOG.info("Wasn't able to find virtual file for wc root: " + info2.getPath());
                            continue;
                        }
                        this.myRoots.add(file);
                    }
                }
            }.execute();
        };
        this.getSvnFileUrlMappingImpl().scheduleRefresh(() -> ApplicationManager.getApplication().invokeLater(callCleanupWorker));
    }

    public boolean checkCommandLineVersion() {
        return ((SvnExecutableChecker)((Object)this.myProject.getService(SvnExecutableChecker.class))).checkExecutableAndNotifyIfNeeded();
    }

    public void invokeRefreshSvnRoots() {
        if (REFRESH_LOG.isDebugEnabled()) {
            REFRESH_LOG.debug("refresh: ", new Throwable());
        }
        this.getSvnFileUrlMappingImpl().scheduleRefresh();
    }

    private void setupChangeLists() {
        ChangeListManager.getInstance((Project)this.myProject).setReadOnly(LocalChangeList.getDefaultName(), true);
        if (!this.getSvnConfiguration().changeListsSynchronized()) {
            List changeLists = ChangeListManager.getInstance((Project)this.myProject).getChangeLists();
            ExclusiveBackgroundVcsAction.run(this.myProject, () -> this.synchronizeToNativeChangeLists(changeLists));
        }
        this.getSvnConfiguration().upgrade();
    }

    public void synchronizeToNativeChangeLists(@NotNull List<? extends LocalChangeList> lists) {
        for (LocalChangeList localChangeList : lists) {
            if (localChangeList.isDefault()) continue;
            for (Change change : localChangeList.getChanges()) {
                this.setNativeChangeList(ChangesUtil.getBeforePath((Change)change), localChangeList.getName());
                this.setNativeChangeList(ChangesUtil.getAfterPath((Change)change), localChangeList.getName());
            }
        }
    }

    private void setNativeChangeList(@Nullable FilePath path, @NotNull String changeListName) {
        if (path == null) {
            return;
        }
        if (!VcsUtil.isFileForVcs((FilePath)path, (Project)this.myProject, (AbstractVcs)this)) {
            return;
        }
        try {
            this.getFactory(path.getIOFile()).createChangeListClient().add(changeListName, path.getIOFile(), null);
        }
        catch (VcsException vcsException) {
            // empty catch block
        }
    }

    public void activate() {
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        if (!this.myProject.isDefault()) {
            busConnection.subscribe(ChangeListListener.TOPIC, (Object)this.myChangeListListener);
            busConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> this.invokeRefreshSvnRoots());
        }
        this.myFileOperationsHandler = new SvnFileSystemListener(this);
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        LoadedRevisionsCache.getInstance(this.myProject);
        if (this.myFrameStateListenerDisposable == null && !this.myProject.isDefault()) {
            this.myFrameStateListenerDisposable = Disposer.newDisposable();
            busConnection.subscribe(FrameStateListener.TOPIC, (Object)new MyFrameStateListener(ChangeListManager.getInstance((Project)this.myProject), VcsDirtyScopeManager.getInstance((Project)this.myProject)));
        }
        this.mySvnBranchPointsCalculator = new SvnBranchPointsCalculator(this);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.checkCommandLineVersion();
        }
        RootsToWorkingCopies.getInstance(this.myProject);
        ProjectLevelVcsManager.getInstance((Project)this.myProject).runAfterInitialization(() -> this.setupChangeLists());
        StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> this.postStartup());
        SvnLoadedBranchesStorage.getInstance(this.myProject).activate();
    }

    public void deactivate() {
        Disposable frameStateListenerDisposable = this.myFrameStateListenerDisposable;
        if (frameStateListenerDisposable != null) {
            this.myFrameStateListenerDisposable = null;
            Disposer.dispose((Disposable)frameStateListenerDisposable);
        }
        if (this.myEntriesFileListener != null) {
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myEntriesFileListener);
        }
        if (this.myFileOperationsHandler != null) {
            Disposer.dispose((Disposable)this.myFileOperationsHandler);
            this.myFileOperationsHandler = null;
        }
        if (this.myCommittedChangesProvider != null) {
            this.myCommittedChangesProvider.deactivate();
        }
        RootsToWorkingCopies.getInstance(this.myProject).clear();
        SvnAuthenticationNotifier.getInstance(this.myProject).clear();
        this.mySvnBranchPointsCalculator.deactivate();
        this.mySvnBranchPointsCalculator = null;
        SvnLoadedBranchesStorage.getInstance(this.myProject).deactivate();
    }

    public VcsShowConfirmationOption getAddConfirmation() {
        return this.myAddConfirmation;
    }

    public VcsShowConfirmationOption getDeleteConfirmation() {
        return this.myDeleteConfirmation;
    }

    public VcsShowSettingOption getCheckoutOptions() {
        return this.myCheckoutOptions;
    }

    public EditFileProvider getEditFileProvider() {
        if (this.myEditFilesProvider == null) {
            this.myEditFilesProvider = new SvnEditFileProvider(this);
        }
        return this.myEditFilesProvider;
    }

    @NotNull
    public ChangeProvider getChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new SvnChangeProvider(this);
        }
        return this.myChangeProvider;
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        if (this.mySvnIntegrateEnvironment == null) {
            this.mySvnIntegrateEnvironment = new SvnIntegrateEnvironment(this);
        }
        return this.mySvnIntegrateEnvironment;
    }

    public UpdateEnvironment createUpdateEnvironment() {
        if (this.mySvnUpdateEnvironment == null) {
            this.mySvnUpdateEnvironment = new SvnUpdateEnvironment(this);
        }
        return this.mySvnUpdateEnvironment;
    }

    @NotNull
    public String getDisplayName() {
        return VCS_DISPLAY_NAME;
    }

    @NotNull
    public String getShortName() {
        return VCS_SHORT_DISPLAY_NAME;
    }

    @Nls
    @NotNull
    public String getShortNameWithMnemonic() {
        return SvnBundle.message("svn.short.name.with.mnemonic", new Object[0]);
    }

    @NotNull
    public SvnConfiguration getSvnConfiguration() {
        return SvnConfiguration.getInstance(this.myProject);
    }

    public static SvnVcs getInstance(@NotNull Project project) {
        return (SvnVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(VCS_NAME);
    }

    @NotNull
    public CheckinEnvironment createCheckinEnvironment() {
        if (this.myCheckinEnvironment == null) {
            this.myCheckinEnvironment = new SvnCheckinEnvironment(this);
        }
        return this.myCheckinEnvironment;
    }

    @NotNull
    public RollbackEnvironment createRollbackEnvironment() {
        if (this.myRollbackEnvironment == null) {
            this.myRollbackEnvironment = new SvnRollbackEnvironment(this);
        }
        return this.myRollbackEnvironment;
    }

    @NotNull
    public SvnHistoryProvider getVcsHistoryProvider() {
        return new SvnHistoryProvider(this);
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    public AnnotationProvider getAnnotationProvider() {
        if (this.myAnnotationProvider == null) {
            this.myAnnotationProvider = new SvnAnnotationProvider(this);
        }
        return new VcsAnnotationCachedProxy((AbstractVcs)this, this.myAnnotationProvider);
    }

    public DiffProvider getDiffProvider() {
        if (this.mySvnDiffProvider == null) {
            this.mySvnDiffProvider = new SvnDiffProvider(this);
        }
        return this.mySvnDiffProvider;
    }

    @Nullable
    public PropertyValue getPropertyWithCaching(@NotNull VirtualFile file, @NotNull String propName) throws VcsException {
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        PropertyClient client = this.getFactory(ioFile).createPropertyClient();
        return client.getProperty(Target.on(ioFile, Revision.WORKING), propName, false, Revision.WORKING);
    }

    public boolean fileExistsInVcs(FilePath path) {
        File file = path.getIOFile();
        try {
            Status status = this.getFactory(file).createStatusClient().doStatus(file, false);
            if (status != null) {
                return status.is(StatusType.STATUS_ADDED) ? status.isCopied() : !status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_IGNORED, StatusType.STATUS_OBSTRUCTED);
            }
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return false;
    }

    public boolean fileIsUnderVcs(@NotNull FilePath path) {
        VirtualFile file = path.getVirtualFile();
        return file != null && SvnStatusUtil.isUnderControl(this, file);
    }

    @Nullable
    public Info getInfo(@NotNull Url url, Revision pegRevision, Revision revision) throws SvnBindException {
        return this.getFactory().createInfoClient().doInfo(Target.on(url, pegRevision), revision);
    }

    @Nullable
    public Info getInfo(@NotNull Url url, Revision revision) throws SvnBindException {
        return this.getInfo(url, Revision.UNDEFINED, revision);
    }

    @Nullable
    public Info getInfo(@NotNull VirtualFile file) {
        return this.getInfo(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @Nullable
    public Info getInfo(@NotNull String path) {
        return this.getInfo(new File(path));
    }

    @Nullable
    public Info getInfo(@NotNull File ioFile) {
        return this.getInfo(ioFile, Revision.UNDEFINED);
    }

    public void collectInfo(@NotNull Collection<File> files, @Nullable InfoConsumer handler) {
        File first = (File)ContainerUtil.getFirstItem(files);
        if (first != null) {
            try {
                this.getFactory(first).createInfoClient().doInfo(files, handler);
            }
            catch (SvnBindException e) {
                this.handleInfoException(e);
            }
        }
    }

    @Nullable
    public Info getInfo(@NotNull File ioFile, @NotNull Revision revision) {
        Info result = null;
        try {
            result = this.getFactory(ioFile).createInfoClient().doInfo(ioFile, revision);
        }
        catch (SvnBindException e) {
            this.handleInfoException(e);
        }
        return result;
    }

    private void handleInfoException(@NotNull SvnBindException e) {
        if (!this.myLogExceptions || SvnUtil.isUnversionedOrNotFound(e) || e.contains(ErrorCode.WC_UNSUPPORTED_FORMAT) || e.contains(ErrorCode.WC_UPGRADE_REQUIRED)) {
            LOG.debug((Throwable)((Object)e));
        } else {
            LOG.error((Throwable)((Object)e));
        }
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile) {
        return this.getWorkingCopyFormat(ioFile, true);
    }

    @NotNull
    public WorkingCopyFormat getWorkingCopyFormat(@NotNull File ioFile, boolean useMapping) {
        WorkingCopyFormat format = WorkingCopyFormat.UNKNOWN;
        if (useMapping) {
            RootUrlInfo rootInfo = this.getSvnFileUrlMapping().getWcRootForFilePath(VcsUtil.getFilePath((File)ioFile));
            format = rootInfo != null ? rootInfo.getFormat() : WorkingCopyFormat.UNKNOWN;
        }
        return WorkingCopyFormat.UNKNOWN.equals((Object)format) ? SvnFormatSelector.findRootAndGetFormat(ioFile) : format;
    }

    public boolean isWcRoot(@NotNull FilePath filePath) {
        WorkingCopy wcRoot;
        boolean isWcRoot = false;
        VirtualFile file = filePath.getVirtualFile();
        WorkingCopy workingCopy = wcRoot = file != null ? RootsToWorkingCopies.getInstance(this.myProject).getWcRoot(file) : null;
        if (wcRoot != null) {
            isWcRoot = wcRoot.getFile().getAbsolutePath().equals(filePath.getPath());
        }
        return isWcRoot;
    }

    public FileStatus[] getProvidedStatuses() {
        return new FileStatus[]{SvnFileStatus.EXTERNAL, SvnFileStatus.OBSTRUCTED, SvnFileStatus.REPLACED};
    }

    @NotNull
    public CommittedChangesProvider<SvnChangeList, ChangeBrowserSettings> getCommittedChangesProvider() {
        if (this.myCommittedChangesProvider == null) {
            this.myCommittedChangesProvider = new SvnCommittedChangesProvider(this);
        }
        return this.myCommittedChangesProvider;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        Revision revision = Revision.parse(revisionNumberString);
        if (revision.equals(Revision.UNDEFINED)) {
            return null;
        }
        return new SvnRevisionNumber(revision);
    }

    public String getRevisionPattern() {
        return "\\d+";
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return SvnUtil.seemsLikeVersionedDir(dir);
    }

    @NotNull
    public SvnFileUrlMapping getSvnFileUrlMapping() {
        return (SvnFileUrlMapping)this.myProject.getService(SvnFileUrlMapping.class);
    }

    @NotNull
    SvnFileUrlMappingImpl getSvnFileUrlMappingImpl() {
        return (SvnFileUrlMappingImpl)this.getSvnFileUrlMapping();
    }

    public List<WCInfo> getAllWcInfos() {
        SvnFileUrlMapping urlMapping = this.getSvnFileUrlMapping();
        List<RootUrlInfo> infoList = urlMapping.getAllWcInfos();
        ArrayList<WCInfo> infos = new ArrayList<WCInfo>();
        for (RootUrlInfo info2 : infoList) {
            File file = info2.getIoFile();
            infos.add(new WCInfo(info2, SvnUtil.isWorkingCopyRoot(file), SvnUtil.getDepth(this, file)));
        }
        return infos;
    }

    public List<WCInfo> getWcInfosWithErrors() {
        ArrayList<WCInfo> result = new ArrayList<WCInfo>(this.getAllWcInfos());
        for (RootUrlInfo info2 : this.getSvnFileUrlMapping().getErrorRoots()) {
            result.add(new WCInfo(info2, SvnUtil.isWorkingCopyRoot(info2.getIoFile()), Depth.UNKNOWN));
        }
        return result;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        if (this.myProject.isDefault()) {
            return null;
        }
        return this.getSvnFileUrlMapping();
    }

    public boolean needsLegacyDefaultMappings() {
        return false;
    }

    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider == null) {
            this.myMergeProvider = new SvnMergeProvider(this.myProject);
        }
        return this.myMergeProvider;
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    @NotNull
    public <S> List<S> filterUniqueRoots(@NotNull List<S> in, @NotNull Function<? super S, ? extends VirtualFile> convertor) {
        if (in.size() <= 1) {
            return in;
        }
        return Registry.is((String)"svn.filter.unique.roots.by.url") ? this.filterUniqueByUrl(in, convertor) : this.filterUniqueByWorkingCopy(in, convertor);
    }

    @NotNull
    private <S> List<S> filterUniqueByUrl(@NotNull List<? extends S> in, @NotNull Function<? super S, ? extends VirtualFile> convertor) {
        ArrayList<MyPair<S>> infos = new ArrayList<MyPair<S>>();
        ArrayList<S> notMatched = new ArrayList<S>();
        for (S s : in) {
            VirtualFile vf = convertor.apply(s);
            if (vf == null) continue;
            File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)vf);
            Url url = this.getSvnFileUrlMapping().getUrlForFile(ioFile);
            if (url == null && (url = SvnUtil.getUrl(this, ioFile)) == null) {
                notMatched.add(s);
                continue;
            }
            infos.add(new MyPair<S>(vf, url, s));
        }
        List filtered = new UniqueRootsFilter().filter(infos);
        List converted = ContainerUtil.map(filtered, MyPair::getSrc);
        return ContainerUtil.concat((List)converted, notMatched);
    }

    @NotNull
    private <S> List<S> filterUniqueByWorkingCopy(@NotNull List<? extends S> in, @NotNull Function<? super S, ? extends VirtualFile> convertor) {
        Map filesMap = StreamEx.of(in).mapToEntry(convertor, Function.identity()).distinctKeys().toMap();
        Map byWorkingCopy = StreamEx.of(filesMap.keySet()).mapToEntry(file -> {
            RootUrlInfo wcRoot = this.getSvnFileUrlMapping().getWcRootForFilePath(VcsUtil.getFilePath((VirtualFile)file));
            return wcRoot != null ? wcRoot.getVirtualFile() : SvnUtil.getWorkingCopyRoot(file);
        }, Function.identity()).nonNullKeys().grouping();
        return EntryStream.of((Map)byWorkingCopy).flatMapToValue((workingCopy, files) -> {
            FilterDescendantVirtualFiles.filter((List)files);
            return files.stream();
        }).values().map(filesMap::get).toList();
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public boolean isVcsBackgroundOperationsAllowed(@NotNull VirtualFile root) {
        ClientFactory factory = this.getFactory(VfsUtilCore.virtualToIoFile((VirtualFile)root));
        ThreeState authResult = SvnAuthenticationNotifier.getInstance(this.myProject).isAuthenticatedFor(root, factory == this.cmdClientFactory ? factory : null);
        return ThreeState.YES.equals((Object)authResult);
    }

    public SvnBranchPointsCalculator getSvnBranchPointsCalculator() {
        return this.mySvnBranchPointsCalculator;
    }

    public boolean areDirectoriesVersionedItems() {
        return true;
    }

    public CheckoutProvider getCheckoutProvider() {
        if (this.myCheckoutProvider == null) {
            this.myCheckoutProvider = new SvnCheckoutProvider();
        }
        return this.myCheckoutProvider;
    }

    @NotNull
    public ClientFactory getFactory() {
        return this.cmdClientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull WorkingCopyFormat format) {
        return this.cmdClientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file) {
        return this.cmdClientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull File file, boolean useMapping) {
        return this.cmdClientFactory;
    }

    @NotNull
    public ClientFactory getFactory(@NotNull Target target) {
        return target.isFile() ? this.getFactory(target.getFile()) : this.getFactory();
    }

    @NotNull
    public ClientFactory getFactoryFromSettings() {
        return this.cmdClientFactory;
    }

    @NotNull
    public ClientFactory getCommandLineFactory() {
        return this.cmdClientFactory;
    }

    @NotNull
    public WorkingCopyFormat getLowestSupportedFormatForCommandLine() {
        WorkingCopyFormat result;
        try {
            result = WorkingCopyFormat.from(CmdVersionClient.parseVersion(Registry.stringValue((String)"svn.lowest.supported.format.for.command.line")));
        }
        catch (SvnBindException ignore) {
            result = WorkingCopyFormat.ONE_DOT_SEVEN;
        }
        return result;
    }

    public boolean isSupportedByCommandLine(@NotNull WorkingCopyFormat format) {
        return format.isOrGreater(this.getLowestSupportedFormatForCommandLine());
    }

    public boolean is16SupportedByCommandLine() {
        return this.isSupportedByCommandLine(WorkingCopyFormat.ONE_DOT_SIX);
    }

    private static final class MyFrameStateListener
    implements FrameStateListener {
        private final ChangeListManager myClManager;
        private final VcsDirtyScopeManager myDirtyScopeManager;

        private MyFrameStateListener(ChangeListManager clManager, VcsDirtyScopeManager dirtyScopeManager) {
            this.myClManager = clManager;
            this.myDirtyScopeManager = dirtyScopeManager;
        }

        public void onFrameActivated() {
            List folders = ((ChangeListManagerImpl)this.myClManager).getLockedFolders();
            if (!folders.isEmpty()) {
                this.myDirtyScopeManager.filesDirty(null, (Collection)folders);
            }
        }
    }

    private static final class MyPair<T>
    implements RootUrlPair {
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final Url myUrl;
        private final T mySrc;

        private MyPair(@NotNull VirtualFile file, @NotNull Url url, T src) {
            this.myFile = file;
            this.myUrl = url;
            this.mySrc = src;
        }

        public T getSrc() {
            return this.mySrc;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            return this.myFile;
        }

        @Override
        @NotNull
        public Url getUrl() {
            return this.myUrl;
        }
    }
}

