/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnVcs;

public final class SvnStatusUtil {
    private SvnStatusUtil() {
    }

    public static boolean isUnderControl(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        return SvnStatusUtil.isUnderControl(vcs.getProject(), file);
    }

    public static boolean isUnderControl(@NotNull Project project, @NotNull VirtualFile file) {
        return !SvnStatusUtil.isIgnoredInAnySense(project, file) && !ChangeListManager.getInstance((Project)project).isUnversioned(file);
    }

    public static boolean isAdded(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        return FileStatus.ADDED.equals(FileStatusManager.getInstance((Project)vcs.getProject()).getStatus(file));
    }

    public static boolean isExplicitlyLocked(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        return ChangeListManagerImpl.getInstanceImpl((Project)vcs.getProject()).isLogicallyLocked(file);
    }

    public static boolean isIgnoredInAnySense(@NotNull Project project, @NotNull VirtualFile file) {
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        return manager.isIgnoredFile(file) || FileStatus.IGNORED.equals(manager.getStatus(file));
    }
}

