/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ForNestedRootChecker;
import org.jetbrains.idea.svn.NestedCopiesHolder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnUtilKtKt;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.status.Status;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002*+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J#\u0010\u0010\u001a\u0004\u0018\u00010\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001eH\u0002J\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001bH\u0002J\u001e\u0010&\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00160(H\u0002J\u001e\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00132\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/idea/svn/SvnRootsDetector;", "", "parent", "Lcom/intellij/openapi/Disposable;", "myVcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "myNestedCopiesHolder", "Lorg/jetbrains/idea/svn/NestedCopiesHolder;", "(Lcom/intellij/openapi/Disposable;Lorg/jetbrains/idea/svn/SvnVcs;Lorg/jetbrains/idea/svn/NestedCopiesHolder;)V", "myRepositoryRoots", "Lorg/jetbrains/idea/svn/SvnRootsDetector$RepositoryRoots;", "myResult", "Lorg/jetbrains/idea/svn/SvnRootsDetector$Result;", "addNestedRoots", "clearState", "", "detectCopyRoots", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;Z)Lorg/jetbrains/idea/svn/SvnRootsDetector$Result;", "findAncestorTopRoot", "Lorg/jetbrains/idea/svn/RootUrlInfo;", "file", "findTopRoot", "Ljava/io/File;", "getNestedRoots", "", "infos", "", "Lorg/jetbrains/idea/svn/NestedCopyInfo;", "refreshPointInfo", "info", "registerLonelyRoots", "", "vcsRoot", "foundRoots", "Lorg/jetbrains/idea/svn/Node;", "registerRootUrlFromNestedPoint", "nestedRoots", "", "registerTopRoots", "RepositoryRoots", "Result", "intellij.vcs.svn"})
public final class SvnRootsDetector {
    private final Result myResult;
    private final RepositoryRoots myRepositoryRoots;
    private final Disposable parent;
    private final SvnVcs myVcs;
    private final NestedCopiesHolder myNestedCopiesHolder;

    @Nullable
    public final Result detectCopyRoots(@NotNull VirtualFile[] roots, boolean clearState) {
        for (VirtualFile vcsRoot : roots) {
            List<Node> foundRoots = new ForNestedRootChecker(this.myVcs).getAllNestedWorkingCopies(vcsRoot);
            this.registerLonelyRoots(vcsRoot, foundRoots);
            this.registerTopRoots(vcsRoot, foundRoots);
        }
        return this.addNestedRoots(clearState);
    }

    private final void registerLonelyRoots(VirtualFile vcsRoot, List<? extends Node> foundRoots) {
        if (foundRoots.isEmpty()) {
            this.myResult.getLonelyRoots().add(vcsRoot);
        }
    }

    private final void registerTopRoots(VirtualFile vcsRoot, List<? extends Node> foundRoots) {
        for (Node node : foundRoots) {
            RootUrlInfo root = new RootUrlInfo(node, SvnFormatSelector.findRootAndGetFormat(node.getIoFile()), vcsRoot);
            if (!node.hasError()) {
                this.myRepositoryRoots.register(node.getRepositoryRootUrl());
                this.myResult.getTopRoots().add(root);
                continue;
            }
            this.myResult.getErrorRoots().add(root);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Result addNestedRoots(boolean clearState) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.myResult.getTopRoots();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            RootUrlInfo rootUrlInfo = (RootUrlInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = it.getVirtualFile();
            collection.add(virtualFile);
        }
        List basicVfRoots = (List)destination$iv$iv;
        if (clearState) {
            this.myNestedCopiesHolder.getAndClear();
            VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).filesDirty(null, (Collection)basicVfRoots);
        }
        return (Result)SvnUtilKtKt.computeAfterUpdateChanges(this.myVcs.getProject(), this.parent, (Function0)new Function0<Result>(this){
            final /* synthetic */ SvnRootsDetector this$0;

            @NotNull
            public final Result invoke() {
                Set<NestedCopyInfo> nestedCopies = SvnRootsDetector.access$getMyNestedCopiesHolder$p(this.this$0).getAndClear();
                SvnRootsDetector.access$getMyResult$p(this.this$0).getTopRoots().addAll(SvnRootsDetector.access$getNestedRoots(this.this$0, nestedCopies));
                return SvnRootsDetector.access$getMyResult$p(this.this$0);
            }
            {
                this.this$0 = svnRootsDetector;
                super(0);
            }
        });
    }

    private final List<RootUrlInfo> getNestedRoots(Set<? extends NestedCopyInfo> infos) {
        List nestedRoots = new ArrayList();
        for (NestedCopyInfo nestedCopyInfo : infos) {
            ProgressManager.checkCanceled();
            if (NestedCopyType.external == nestedCopyInfo.getType() || NestedCopyType.switched == nestedCopyInfo.getType()) {
                RootUrlInfo topRoot = this.findTopRoot(VfsUtilCore.virtualToIoFile((VirtualFile)nestedCopyInfo.getFile()));
                if (topRoot != null) {
                    topRoot.setType(nestedCopyInfo.getType());
                    continue;
                }
                if (!this.refreshPointInfo(nestedCopyInfo)) continue;
            }
            this.registerRootUrlFromNestedPoint(nestedCopyInfo, nestedRoots);
        }
        return nestedRoots;
    }

    private final void registerRootUrlFromNestedPoint(NestedCopyInfo info2, List<RootUrlInfo> nestedRoots) {
        block2: {
            RootUrlInfo rootUrlInfo;
            RootUrlInfo rootUrlInfo2 = this.findAncestorTopRoot(info2.getFile());
            if (rootUrlInfo2 == null) break block2;
            RootUrlInfo topRoot = rootUrlInfo = rootUrlInfo2;
            boolean bl = false;
            Url url = info2.getRootURL();
            if (url == null) {
                url = this.myRepositoryRoots.ask(info2.getUrl(), info2.getFile());
            }
            if (url != null) {
                Url url2;
                Url repoRoot = url2 = url;
                boolean bl2 = false;
                VirtualFile virtualFile = info2.getFile();
                Url url3 = info2.getUrl();
                Intrinsics.checkNotNull((Object)url3);
                Node node = new Node(virtualFile, url3, repoRoot);
                nestedRoots.add(new RootUrlInfo(node, info2.getFormat(), topRoot.getRoot(), info2.getType()));
            }
        }
    }

    private final boolean refreshPointInfo(NestedCopyInfo info2) {
        boolean refreshed = false;
        File infoFile = VfsUtilCore.virtualToIoFile((VirtualFile)info2.getFile());
        Status svnStatus = SvnUtil.getStatus(this.myVcs, infoFile);
        if (svnStatus != null && svnStatus.getUrl() != null) {
            info2.setUrl(svnStatus.getUrl());
            info2.setFormat(this.myVcs.getWorkingCopyFormat(infoFile, false));
            if (svnStatus.getRepositoryRootUrl() != null) {
                info2.setRootURL(svnStatus.getRepositoryRootUrl());
            }
            refreshed = true;
        }
        return refreshed;
    }

    private final RootUrlInfo findTopRoot(File file) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.myResult.getTopRoots();
            for (Object t : iterable2) {
                RootUrlInfo it = (RootUrlInfo)t;
                boolean bl = false;
                if (!FileUtil.filesEqual((File)it.getIoFile(), (File)file)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final RootUrlInfo findAncestorTopRoot(VirtualFile file) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.myResult.getTopRoots();
            for (Object t : iterable2) {
                RootUrlInfo it = (RootUrlInfo)t;
                boolean bl = false;
                if (!VfsUtilCore.isAncestor((VirtualFile)it.getVirtualFile(), (VirtualFile)file, (boolean)true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public SvnRootsDetector(@NotNull Disposable parent, @NotNull SvnVcs myVcs, @NotNull NestedCopiesHolder myNestedCopiesHolder) {
        this.parent = parent;
        this.myVcs = myVcs;
        this.myNestedCopiesHolder = myNestedCopiesHolder;
        this.myResult = new Result();
        this.myRepositoryRoots = new RepositoryRoots(this.myVcs);
    }

    public static final /* synthetic */ NestedCopiesHolder access$getMyNestedCopiesHolder$p(SvnRootsDetector $this) {
        return $this.myNestedCopiesHolder;
    }

    public static final /* synthetic */ Result access$getMyResult$p(SvnRootsDetector $this) {
        return $this.myResult;
    }

    public static final /* synthetic */ List access$getNestedRoots(SvnRootsDetector $this, Set infos) {
        return $this.getNestedRoots(infos);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/svn/SvnRootsDetector$RepositoryRoots;", "", "myVcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "(Lorg/jetbrains/idea/svn/SvnVcs;)V", "myRoots", "", "Lorg/jetbrains/idea/svn/api/Url;", "ask", "url", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "register", "", "intellij.vcs.svn"})
    private static final class RepositoryRoots {
        private final Set<Url> myRoots;
        private final SvnVcs myVcs;

        public final void register(@NotNull Url url) {
            this.myRoots.add(url);
        }

        @Nullable
        public final Url ask(@Nullable Url url, @NotNull VirtualFile file) {
            Url root;
            Url url2;
            Url url3;
            Url it;
            Url url4;
            Url url5 = url;
            if (url5 != null) {
                Object v1;
                block6: {
                    Iterable iterable;
                    it = url4 = url5;
                    boolean bl = false;
                    Iterable iterable2 = iterable = (Iterable)this.myRoots;
                    for (Object t : iterable2) {
                        Url root2 = (Url)t;
                        boolean bl2 = false;
                        if (!SvnUtil.isAncestor(root2, it)) continue;
                        v1 = t;
                        break block6;
                    }
                    v1 = null;
                }
                url3 = v1;
            } else {
                url3 = null;
            }
            if ((url2 = (root = url3)) == null) {
                Url url6 = SvnUtil.getRepositoryRoot(this.myVcs, VfsUtilCore.virtualToIoFile((VirtualFile)file));
                if (url6 != null) {
                    it = url4 = url6;
                    boolean bl = false;
                    this.myRoots.add(it);
                    url2 = url4;
                } else {
                    url2 = null;
                }
            }
            return url2;
        }

        public RepositoryRoots(@NotNull SvnVcs myVcs) {
            this.myVcs = myVcs;
            this.myRoots = new LinkedHashSet();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/svn/SvnRootsDetector$Result;", "", "()V", "errorRoots", "", "Lorg/jetbrains/idea/svn/RootUrlInfo;", "getErrorRoots", "()Ljava/util/List;", "lonelyRoots", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLonelyRoots", "topRoots", "getTopRoots", "intellij.vcs.svn"})
    public static final class Result {
        @NotNull
        private final List<VirtualFile> lonelyRoots = new ArrayList();
        @NotNull
        private final List<RootUrlInfo> topRoots = new ArrayList();
        @NotNull
        private final List<RootUrlInfo> errorRoots = new ArrayList();

        @NotNull
        public final List<VirtualFile> getLonelyRoots() {
            return this.lonelyRoots;
        }

        @NotNull
        public final List<RootUrlInfo> getTopRoots() {
            return this.topRoots;
        }

        @NotNull
        public final List<RootUrlInfo> getErrorRoots() {
            return this.errorRoots;
        }
    }
}

