/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.api.Url;

public class SvnMapping {
    private static final Comparator<String> FILE_PATHS_COMPARATOR = (path1, path2) -> FileUtil.comparePaths((String)path1, (String)path2);
    @NotNull
    private final List<VirtualFile> myLonelyRoots = new ArrayList<VirtualFile>();
    @NotNull
    private final TreeMap<String, RootUrlInfo> myFile2UrlMap = new TreeMap(FILE_PATHS_COMPARATOR);
    @NotNull
    private final Map<Url, RootUrlInfo> myUrl2FileMap = new HashMap<Url, RootUrlInfo>();
    @NotNull
    private final ClearableLazyValue<List<VirtualFile>> myPreCalculatedUnderVcsRoots = new ClearableLazyValue<List<VirtualFile>>(){

        @NotNull
        protected List<VirtualFile> compute() {
            return ContainerUtil.map(SvnMapping.this.myFile2UrlMap.values(), RootUrlInfo::getVirtualFile);
        }
    };

    public void copyFrom(@NotNull SvnMapping other) {
        this.myFile2UrlMap.clear();
        this.myUrl2FileMap.clear();
        this.myLonelyRoots.clear();
        this.myFile2UrlMap.putAll(other.myFile2UrlMap);
        this.myUrl2FileMap.putAll(other.myUrl2FileMap);
        this.myLonelyRoots.addAll(other.myLonelyRoots);
        this.myPreCalculatedUnderVcsRoots.drop();
    }

    public void addAll(@NotNull Collection<RootUrlInfo> roots) {
        roots.forEach(this::add);
    }

    public void add(@NotNull RootUrlInfo rootInfo) {
        this.myFile2UrlMap.put(rootInfo.getPath(), rootInfo);
        this.myUrl2FileMap.put(rootInfo.getUrl(), rootInfo);
    }

    @NotNull
    public List<VirtualFile> getUnderVcsRoots() {
        return (List)this.myPreCalculatedUnderVcsRoots.getValue();
    }

    @NotNull
    public List<RootUrlInfo> getAllCopies() {
        return new ArrayList<RootUrlInfo>(this.myFile2UrlMap.values());
    }

    @Nullable
    public String getRootForPath(@NotNull String path) {
        return (String)ContainerUtil.find(this.myFile2UrlMap.headMap(path, true).descendingKeySet(), root -> SystemInfo.isFileSystemCaseSensitive ? path.startsWith((String)root) : StringUtil.startsWithIgnoreCase((String)path, (String)root));
    }

    @NotNull
    public Collection<Url> getUrls() {
        return this.myUrl2FileMap.keySet();
    }

    @Nullable
    public RootUrlInfo byFile(@NotNull String path) {
        return this.myFile2UrlMap.get(path);
    }

    @Nullable
    public RootUrlInfo byUrl(@NotNull Url url) {
        return this.myUrl2FileMap.get(url);
    }

    public boolean isEmpty() {
        return this.myUrl2FileMap.isEmpty();
    }

    public void reportLonelyRoots(@NotNull Collection<VirtualFile> roots) {
        this.myLonelyRoots.addAll(roots);
    }

    @NotNull
    public List<VirtualFile> getLonelyRoots() {
        return this.myLonelyRoots;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnMapping mapping = (SvnMapping)o;
        if (!this.myFile2UrlMap.equals(mapping.myFile2UrlMap)) {
            return false;
        }
        if (!this.myLonelyRoots.equals(mapping.myLonelyRoots)) {
            return false;
        }
        return this.myUrl2FileMap.equals(mapping.myUrl2FileMap);
    }

    public int hashCode() {
        int result = this.myLonelyRoots.hashCode();
        result = 31 * result + this.myFile2UrlMap.hashCode();
        result = 31 * result + this.myUrl2FileMap.hashCode();
        return result;
    }
}

