/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.PluginVcsMappingListener;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopiesHolder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnCompatibilityChecker;
import org.jetbrains.idea.svn.SvnCopyRootSimple;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnMapping;
import org.jetbrains.idea.svn.SvnMappingSavedPart;
import org.jetbrains.idea.svn.SvnRootsDetector;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnUtilKtKt;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.UniqueRootsFilter;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;

@State(name="SvnFileUrlMappingImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class SvnFileUrlMappingImpl
implements SvnFileUrlMapping,
PersistentStateComponent<SvnMappingSavedPart>,
Disposable {
    private static final Logger LOG = Logger.getInstance(SvnFileUrlMappingImpl.class);
    @NotNull
    private final Object myMonitor = new Object();
    @NotNull
    private final SvnMapping myMapping = new SvnMapping();
    @NotNull
    private final SvnMapping myMoreRealMapping = new SvnMapping();
    @NotNull
    private final List<RootUrlInfo> myErrorRoots = new ArrayList<RootUrlInfo>();
    @NotNull
    private final MyRootsHelper myRootsHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final NestedCopiesHolder myNestedCopiesHolder = new NestedCopiesHolder();
    private boolean myInitialized;
    private boolean myInitedReloaded;
    @NotNull
    private final MergingUpdateQueue myRefreshQueue = new MergingUpdateQueue("Refresh Working Copies", 100, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);

    private SvnFileUrlMappingImpl(@NotNull Project project) {
        this.myProject = project;
        this.myRootsHelper = new MyRootsHelper(project, ProjectLevelVcsManager.getInstance((Project)project));
    }

    public void dispose() {
    }

    @Override
    @Nullable
    public Url getUrlForFile(@NotNull File file) {
        Url result = null;
        RootUrlInfo rootUrlInfo = this.getWcRootForFilePath(VcsUtil.getFilePath((File)file));
        if (rootUrlInfo != null) {
            try {
                result = SvnUtil.append(rootUrlInfo.getUrl(), SvnUtil.getRelativePath(rootUrlInfo.getPath(), file.getAbsolutePath()));
            }
            catch (SvnBindException e) {
                LOG.info((Throwable)((Object)e));
            }
        }
        return result;
    }

    @Override
    @Nullable
    public File getLocalPath(@NotNull Url url) {
        RootUrlInfo parentInfo = this.getWcRootForUrl(url);
        return parentInfo != null ? new File(parentInfo.getIoFile(), SvnUtil.getRelativeUrl(parentInfo.getUrl(), url)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForFilePath(@NotNull FilePath path) {
        Object object = this.myMonitor;
        synchronized (object) {
            String root = this.myMoreRealMapping.getRootForPath(FileUtil.toSystemDependentName((String)path.toString()));
            return root != null ? this.myMoreRealMapping.byFile(root) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForUrl(@NotNull Url url) {
        Object object = this.myMonitor;
        synchronized (object) {
            RootUrlInfo result = null;
            Url rootUrl = (Url)ContainerUtil.find(this.myMoreRealMapping.getUrls(), parentRootUrl -> SvnUtil.isAncestor(parentRootUrl, url));
            if (rootUrl != null && (result = this.myMoreRealMapping.byUrl(rootUrl)) == null) {
                LOG.info("Inconsistent maps for url:" + url + " found root url: " + rootUrl);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<RootUrlInfo> getAllWcInfos() {
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMoreRealMapping.getAllCopies();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<RootUrlInfo> getErrorRoots() {
        Object object = this.myMonitor;
        synchronized (object) {
            return new ArrayList<RootUrlInfo>(this.myErrorRoots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> result) {
        List<VirtualFile> lonelyRoots;
        List<VirtualFile> cachedRoots;
        if (MyRootsHelper.isInProgress()) {
            return new ArrayList<VirtualFile>(result);
        }
        Object object = this.myMonitor;
        synchronized (object) {
            cachedRoots = this.myMoreRealMapping.getUnderVcsRoots();
            lonelyRoots = this.myMoreRealMapping.getLonelyRoots();
        }
        ((SvnCompatibilityChecker)this.myProject.getService(SvnCompatibilityChecker.class)).checkAndNotify(lonelyRoots);
        return new ArrayList<VirtualFile>(cachedRoots.isEmpty() ? result : cachedRoots);
    }

    public void acceptNestedData(@NotNull Set<NestedCopyInfo> set) {
        this.myNestedCopiesHolder.add(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean init() {
        Object object = this.myMonitor;
        synchronized (object) {
            boolean result = this.myInitialized;
            this.myInitialized = true;
            return result;
        }
    }

    public void scheduleRefresh() {
        this.myRefreshQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"refresh", () -> this.refresh()));
    }

    void scheduleRefresh(@NotNull Runnable callback) {
        this.myRefreshQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)callback, () -> {
            try {
                this.refresh();
            }
            finally {
                callback.run();
            }
        }));
    }

    private void refresh() {
        VirtualFile[] roots;
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        SvnRootsDetector rootsDetector = new SvnRootsDetector(this, vcs, this.myNestedCopiesHolder);
        SvnRootsDetector.Result result = rootsDetector.detectCopyRoots(roots = this.myRootsHelper.execute(), this.init());
        if (result != null) {
            SvnUtilKtKt.putWcDbFilesToVfs(result.getTopRoots());
            new NewRootsApplier(result).apply();
        }
    }

    @Override
    public VirtualFile @NotNull [] getNotFilteredRoots() {
        return this.myRootsHelper.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMapping.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnMappingSavedPart getState() {
        SvnMappingSavedPart result = new SvnMappingSavedPart();
        SvnMapping mapping = new SvnMapping();
        SvnMapping realMapping = new SvnMapping();
        Object object = this.myMonitor;
        synchronized (object) {
            mapping.copyFrom(this.myMapping);
            realMapping.copyFrom(this.myMoreRealMapping);
        }
        mapping.getAllCopies().forEach(result::add);
        realMapping.getAllCopies().forEach(result::addReal);
        return result;
    }

    public void loadState(@NotNull SvnMappingSavedPart state) {
        ProjectLevelVcsManager.getInstance((Project)this.myProject).runAfterInitialization(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            SvnMapping mapping = new SvnMapping();
            SvnMapping realMapping = new SvnMapping();
            try {
                this.fillMapping(mapping, state.getMappingRoots());
                this.fillMapping(realMapping, state.getMoreRealMappingRoots());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.info(t);
                return;
            }
            Object object = this.myMonitor;
            synchronized (object) {
                this.myMapping.copyFrom(mapping);
                this.myMoreRealMapping.copyFrom(realMapping);
            }
        }));
    }

    private void fillMapping(@NotNull SvnMapping mapping, @NotNull List<SvnCopyRootSimple> list) {
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (SvnCopyRootSimple simple : list) {
            SvnVcs vcs;
            Info info2;
            VirtualFile copyRoot = lfs.findFileByIoFile(new File(simple.myCopyRoot));
            VirtualFile vcsRoot = lfs.findFileByIoFile(new File(simple.myVcsRoot));
            if (copyRoot == null || vcsRoot == null || (info2 = (vcs = SvnVcs.getInstance(this.myProject)).getInfo(copyRoot)) == null || info2.getRepositoryRootUrl() == null) continue;
            Node node = new Node(copyRoot, info2.getUrl(), info2.getRepositoryRootUrl());
            mapping.add(new RootUrlInfo(node, SvnFormatSelector.findRootAndGetFormat(info2.getFile()), vcsRoot));
        }
    }

    private final class NewRootsApplier {
        @NotNull
        private final SvnRootsDetector.Result myResult;
        @NotNull
        private final SvnMapping myNewMapping = new SvnMapping();
        @NotNull
        private final SvnMapping myNewFilteredMapping = new SvnMapping();

        private NewRootsApplier(SvnRootsDetector.Result result) {
            this.myResult = result;
        }

        public void apply() {
            this.myNewMapping.addAll(this.myResult.getTopRoots());
            this.myNewMapping.reportLonelyRoots(this.myResult.getLonelyRoots());
            this.myNewFilteredMapping.addAll(new UniqueRootsFilter().filter(this.myResult.getTopRoots()));
            this.runUpdateMappings();
        }

        private void runUpdateMappings() {
            ReadAction.run(() -> {
                if (!SvnFileUrlMappingImpl.this.myProject.isDisposed()) {
                    boolean mappingsChanged = this.updateMappings();
                    this.notifyRootsReloaded(mappingsChanged);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateMappings() {
            boolean mappingsChanged;
            Object object = SvnFileUrlMappingImpl.this.myMonitor;
            synchronized (object) {
                mappingsChanged = !SvnFileUrlMappingImpl.this.myMoreRealMapping.equals(this.myNewFilteredMapping);
                mappingsChanged |= !SvnFileUrlMappingImpl.this.myErrorRoots.equals(this.myResult.getErrorRoots());
                SvnFileUrlMappingImpl.this.myMapping.copyFrom(this.myNewMapping);
                SvnFileUrlMappingImpl.this.myMoreRealMapping.copyFrom(this.myNewFilteredMapping);
                SvnFileUrlMappingImpl.this.myErrorRoots.clear();
                SvnFileUrlMappingImpl.this.myErrorRoots.addAll(this.myResult.getErrorRoots());
            }
            return mappingsChanged;
        }

        private void notifyRootsReloaded(boolean mappingsChanged) {
            if (mappingsChanged || !SvnFileUrlMappingImpl.this.myInitedReloaded) {
                SvnFileUrlMappingImpl.this.myInitedReloaded = true;
                ((Consumer)BackgroundTaskUtil.syncPublisher((Project)SvnFileUrlMappingImpl.this.myProject, SvnVcs.ROOTS_RELOADED)).consume((Object)true);
                ((PluginVcsMappingListener)BackgroundTaskUtil.syncPublisher((Project)SvnFileUrlMappingImpl.this.myProject, (Topic)ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN)).directoryMappingChanged();
            } else {
                ((Consumer)BackgroundTaskUtil.syncPublisher((Project)SvnFileUrlMappingImpl.this.myProject, SvnVcs.ROOTS_RELOADED)).consume((Object)false);
            }
        }
    }

    private static final class MyRootsHelper {
        @NotNull
        private static final ThreadLocal<Boolean> ourInProgress = ThreadLocal.withInitial(() -> Boolean.FALSE);
        @NotNull
        private final Project myProject;
        @NotNull
        private final ProjectLevelVcsManager myVcsManager;

        private MyRootsHelper(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
            this.myProject = project;
            this.myVcsManager = vcsManager;
        }

        public VirtualFile @NotNull [] execute() {
            try {
                ourInProgress.set(Boolean.TRUE);
                VirtualFile[] virtualFileArray = this.myVcsManager.getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(this.myProject));
                return virtualFileArray;
            }
            finally {
                ourInProgress.set(Boolean.FALSE);
            }
        }

        public static boolean isInProgress() {
            return ourInProgress.get();
        }
    }
}

