/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;

@Service
final class SvnCompatibilityChecker
implements Disposable {
    private final Project myProject;
    private static final long ourFrequency = 10L;
    private static final long ourInvocationMax = 10L;
    private static final long ourInitCounter = 3L;
    private long myCounter = 0L;
    private long myDownStartCounter = 3L;
    private long myInvocationCounter = 0L;
    private final Object myLock = new Object();

    SvnCompatibilityChecker(@NotNull Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndNotify(@NotNull List<VirtualFile> roots) {
        if (roots.isEmpty()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myInvocationCounter >= 10L) {
                return;
            }
            ++this.myCounter;
            --this.myDownStartCounter;
            if (this.myCounter <= 10L && this.myDownStartCounter < 0L) {
                return;
            }
            this.myCounter = 0L;
            ++this.myInvocationCounter;
        }
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this, () -> {
            List incompatible = ContainerUtil.filter((Collection)roots, SvnCompatibilityChecker::seemsVersioned);
            if (!incompatible.isEmpty()) {
                this.notify(incompatible);
            }
        });
    }

    public void dispose() {
    }

    private void notify(@NotNull List<VirtualFile> roots) {
        String message = roots.size() == 1 ? SvnBundle.message("notification.content.single.root.unsupported.format", roots.get(0).getPresentableName()) : SvnBundle.message("notification.content.multiple.roots.unsupported.format", new Object[0]);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (Disposer.isDisposed((Disposable)this)) {
                return;
            }
            new VcsBalloonProblemNotifier(this.myProject, message, MessageType.WARNING).run();
        }, ModalityState.NON_MODAL);
    }

    private static boolean seemsVersioned(@NotNull VirtualFile root) {
        ProgressManager.checkCanceled();
        return SvnUtil.seemsLikeVersionedDir(root);
    }
}

