/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class Node {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Url myUrl;
    @NotNull
    private final Url myRepositoryUrl;
    @Nullable
    private final SvnBindException myError;

    public Node(@NotNull VirtualFile file, @NotNull Url url, @NotNull Url repositoryUrl) {
        this(file, url, repositoryUrl, null);
    }

    public Node(@NotNull VirtualFile file, @NotNull Url url, @NotNull Url repositoryUrl, @Nullable SvnBindException error) {
        this.myFile = file;
        this.myUrl = url;
        this.myRepositoryUrl = repositoryUrl;
        this.myError = error;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public File getIoFile() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile());
    }

    @NotNull
    public Url getUrl() {
        return this.myUrl;
    }

    @NotNull
    public Url getRepositoryRootUrl() {
        return this.myRepositoryUrl;
    }

    @Nullable
    public SvnBindException getError() {
        return this.myError;
    }

    public boolean hasError() {
        return this.myError != null;
    }

    public boolean onUrl(@Nullable Url url) {
        return this.myUrl.equals(url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        if (this.myError != null ? node.myError == null || !this.myError.getMessage().equals(node.myError.getMessage()) : node.myError != null) {
            return false;
        }
        if (!this.myFile.equals(node.myFile)) {
            return false;
        }
        if (!this.myRepositoryUrl.equals(node.myRepositoryUrl)) {
            return false;
        }
        return this.myUrl.equals(node.myUrl);
    }

    public int hashCode() {
        int result = this.myFile.hashCode();
        result = 31 * result + this.myUrl.hashCode();
        result = 31 * result + this.myRepositoryUrl.hashCode();
        result = 31 * result + (this.myError != null ? this.myError.getMessage().hashCode() : 0);
        return result;
    }
}

