/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import com.google.archivepatcher.generator.bsdiff.BsDiffMatcher;
import com.google.archivepatcher.generator.bsdiff.BsUtil;
import com.google.archivepatcher.generator.bsdiff.DivSuffixSorter;
import com.google.archivepatcher.generator.bsdiff.Matcher;
import com.google.archivepatcher.generator.bsdiff.RandomAccessObject;
import com.google.archivepatcher.generator.bsdiff.RandomAccessObjectFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;

public class BsDiffPatchWriter {
    static final int DEFAULT_MINIMUM_MATCH_LENGTH = 16;

    private static void writeEntry(RandomAccessObject newData, RandomAccessObject oldData, int newPosition, int oldPosition, int diffLength, int extraLength, int oldPositionOffsetForNextEntry, OutputStream outputStream) throws IOException {
        int i;
        BsUtil.writeFormattedLong(diffLength, outputStream);
        BsUtil.writeFormattedLong(extraLength, outputStream);
        BsUtil.writeFormattedLong(oldPositionOffsetForNextEntry, outputStream);
        newData.seek(newPosition);
        oldData.seek(oldPosition);
        for (i = 0; i < diffLength; ++i) {
            outputStream.write(newData.readUnsignedByte() - oldData.readUnsignedByte());
        }
        if (extraLength > 0) {
            newData.seek(newPosition + diffLength);
            for (i = 0; i < extraLength; ++i) {
                outputStream.write(newData.readByte());
            }
        }
    }

    static void generatePatchWithMatcher(RandomAccessObject oldData, RandomAccessObject newData, Matcher matcher, OutputStream outputStream) throws IOException, InterruptedException {
        int lastNewPosition = 0;
        int lastOldPosition = 0;
        int newPosition = 0;
        int oldPosition = 0;
        while ((long)newPosition < newData.length()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Matcher.NextMatch nextMatch = matcher.next();
            if (nextMatch.didFindMatch) {
                newPosition = nextMatch.newPosition;
                oldPosition = nextMatch.oldPosition;
            } else {
                newPosition = (int)newData.length();
            }
            int backwardExtension = 0;
            if ((long)newPosition < newData.length()) {
                int score = 0;
                int bestScore = 0;
                for (int i = 1; newPosition - i >= lastNewPosition && oldPosition >= i; ++i) {
                    oldData.seek(oldPosition - i);
                    newData.seek(newPosition - i);
                    score = oldData.readByte() == newData.readByte() ? ++score : --score;
                    if (score <= bestScore) continue;
                    bestScore = score;
                    backwardExtension = i;
                }
            }
            int forwardExtension = 0;
            int score = 0;
            int bestScore = 0;
            oldData.seek(lastOldPosition);
            newData.seek(lastNewPosition);
            int i = 0;
            while (lastNewPosition + i < newPosition && (long)(lastOldPosition + i) < oldData.length()) {
                score = oldData.readByte() == newData.readByte() ? ++score : --score;
                if (score > bestScore) {
                    bestScore = score;
                    forwardExtension = i + 1;
                }
                ++i;
            }
            int overlap = lastNewPosition + forwardExtension - (newPosition - backwardExtension);
            if (overlap > 0) {
                int score2 = 0;
                int bestScore2 = 0;
                int backwardExtensionDecrement = 0;
                for (int i2 = 0; i2 < overlap; ++i2) {
                    newData.seek(lastNewPosition + forwardExtension - overlap + i2);
                    oldData.seek(lastOldPosition + forwardExtension - overlap + i2);
                    if (newData.readByte() == oldData.readByte()) {
                        ++score2;
                    }
                    newData.seek(newPosition - backwardExtension + i2);
                    oldData.seek(oldPosition - backwardExtension + i2);
                    if (newData.readByte() == oldData.readByte()) {
                        --score2;
                    }
                    if (score2 <= bestScore2) continue;
                    bestScore2 = score2;
                    backwardExtensionDecrement = i2 + 1;
                }
                forwardExtension -= overlap - backwardExtensionDecrement;
                backwardExtension -= backwardExtensionDecrement;
            }
            int oldPositionOffset = 0;
            if ((long)newPosition < newData.length()) {
                oldPositionOffset = oldPosition - backwardExtension - (lastOldPosition + forwardExtension);
            }
            int newNoMatchLength = newPosition - backwardExtension - (lastNewPosition + forwardExtension);
            BsDiffPatchWriter.writeEntry(newData, oldData, lastNewPosition, lastOldPosition, forwardExtension, newNoMatchLength, oldPositionOffset, outputStream);
            lastNewPosition = newPosition - backwardExtension;
            lastOldPosition = oldPosition - backwardExtension;
        }
    }

    public static void generatePatch(RandomAccessObject oldData, RandomAccessObject newData, OutputStream outputStream, RandomAccessObjectFactory randomAccessObjectFactory) throws IOException, InterruptedException {
        BsDiffPatchWriter.generatePatch(oldData, newData, outputStream, randomAccessObjectFactory, 16);
    }

    public static void generatePatch(byte[] oldData, byte[] newData, OutputStream outputStream) throws IOException, InterruptedException {
        BsDiffPatchWriter.generatePatch(oldData, newData, outputStream, 16);
    }

    public static void generatePatch(byte[] oldData, byte[] newData, OutputStream outputStream, int minimumMatchLength) throws IOException, InterruptedException {
        try (RandomAccessObject.RandomAccessByteArrayObject oldDataRAO = new RandomAccessObject.RandomAccessByteArrayObject(oldData);
             RandomAccessObject.RandomAccessByteArrayObject newDataRAO = new RandomAccessObject.RandomAccessByteArrayObject(newData);){
            BsDiffPatchWriter.generatePatch(oldDataRAO, newDataRAO, outputStream, new RandomAccessObjectFactory.RandomAccessByteArrayObjectFactory(), minimumMatchLength);
        }
    }

    public static void generatePatch(File oldData, File newData, OutputStream outputStream) throws IOException, InterruptedException {
        BsDiffPatchWriter.generatePatch(oldData, newData, outputStream, 16);
    }

    public static void generatePatch(File oldData, File newData, OutputStream outputStream, int minimumMatchLength) throws IOException, InterruptedException {
        try (RandomAccessFile oldDataRAF = new RandomAccessFile(oldData, "r");
             RandomAccessFile newDataRAF = new RandomAccessFile(newData, "r");
             RandomAccessObject.RandomAccessMmapObject oldDataRAO = new RandomAccessObject.RandomAccessMmapObject(oldDataRAF, "r");
             RandomAccessObject.RandomAccessMmapObject newDataRAO = new RandomAccessObject.RandomAccessMmapObject(newDataRAF, "r");){
            BsDiffPatchWriter.generatePatch(oldDataRAO, newDataRAO, outputStream, new RandomAccessObjectFactory.RandomAccessMmapObjectFactory("rw"), minimumMatchLength);
        }
        System.gc();
        System.runFinalization();
    }

    public static void generatePatch(RandomAccessObject oldData, RandomAccessObject newData, OutputStream outputStream, RandomAccessObjectFactory randomAccessObjectFactory, int minimumMatchLength) throws IOException, InterruptedException {
        outputStream.write("ENDSLEY/BSDIFF43".getBytes(StandardCharsets.US_ASCII));
        BsUtil.writeFormattedLong(newData.length(), outputStream);
        try (RandomAccessObject groupArray = new DivSuffixSorter(randomAccessObjectFactory).suffixSort(oldData);){
            BsDiffMatcher matcher = new BsDiffMatcher(oldData, newData, groupArray, minimumMatchLength);
            BsDiffPatchWriter.generatePatchWithMatcher(oldData, newData, matcher, outputStream);
        }
    }
}

