/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.MinimalCentralDirectoryMetadata;
import com.google.archivepatcher.generator.MinimalZipEntry;
import com.google.archivepatcher.shared.RandomAccessFileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;

class MinimalZipParser {
    public static final int EOCD_SIGNATURE = 101010256;
    public static final int CENTRAL_DIRECTORY_ENTRY_SIGNATURE = 33639248;
    public static final int LOCAL_ENTRY_SIGNATURE = 67324752;

    MinimalZipParser() {
    }

    private static int readByteOrDie(InputStream in) throws IOException {
        int result = in.read();
        if (result == -1) {
            throw new IOException("EOF");
        }
        return result;
    }

    private static void skipOrDie(InputStream in, long numBytes) throws IOException {
        long numLeft = numBytes;
        long numSkipped = 0L;
        while ((numSkipped = in.skip(numLeft)) > 0L) {
            numLeft -= numSkipped;
        }
        if (numLeft != 0L) {
            throw new IOException("Unable to skip");
        }
    }

    private static int read16BitUnsigned(InputStream in) throws IOException {
        int value = MinimalZipParser.readByteOrDie(in);
        return value |= MinimalZipParser.readByteOrDie(in) << 8;
    }

    private static long read32BitUnsigned(InputStream in) throws IOException {
        long value = MinimalZipParser.readByteOrDie(in);
        value |= (long)MinimalZipParser.readByteOrDie(in) << 8;
        value |= (long)MinimalZipParser.readByteOrDie(in) << 16;
        return value |= (long)MinimalZipParser.readByteOrDie(in) << 24;
    }

    private static void readOrDie(InputStream in, byte[] buffer, int offset, int length) throws IOException {
        int readThisRound;
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        for (int numRead = 0; numRead < length; numRead += readThisRound) {
            readThisRound = in.read(buffer, offset + numRead, length - numRead);
            if (numRead != -1) continue;
            throw new IOException("EOF");
        }
    }

    public static MinimalZipEntry parseCentralDirectoryEntry(InputStream in) throws IOException {
        if ((int)MinimalZipParser.read32BitUnsigned(in) != 33639248) {
            throw new ZipException("Bad central directory header");
        }
        MinimalZipParser.skipOrDie(in, 4L);
        int generalPurposeFlags = MinimalZipParser.read16BitUnsigned(in);
        int compressionMethod = MinimalZipParser.read16BitUnsigned(in);
        MinimalZipParser.skipOrDie(in, 4L);
        long crc32OfUncompressedData = MinimalZipParser.read32BitUnsigned(in);
        long compressedSize = MinimalZipParser.read32BitUnsigned(in);
        long uncompressedSize = MinimalZipParser.read32BitUnsigned(in);
        int fileNameLength = MinimalZipParser.read16BitUnsigned(in);
        int extrasLength = MinimalZipParser.read16BitUnsigned(in);
        int commentLength = MinimalZipParser.read16BitUnsigned(in);
        MinimalZipParser.skipOrDie(in, 8L);
        long fileOffsetOfLocalEntry = MinimalZipParser.read32BitUnsigned(in);
        byte[] fileNameBuffer = new byte[fileNameLength];
        MinimalZipParser.readOrDie(in, fileNameBuffer, 0, fileNameBuffer.length);
        MinimalZipParser.skipOrDie(in, extrasLength + commentLength);
        boolean generalPurposeFlagBit11 = (generalPurposeFlags & 0x400) != 0;
        return new MinimalZipEntry(compressionMethod, crc32OfUncompressedData, compressedSize, uncompressedSize, fileNameBuffer, generalPurposeFlagBit11, fileOffsetOfLocalEntry);
    }

    public static long parseLocalEntryAndGetCompressedDataOffset(InputStream in) throws IOException {
        if ((int)MinimalZipParser.read32BitUnsigned(in) != 67324752) {
            throw new ZipException("Bad local entry header");
        }
        int junkLength = 22;
        MinimalZipParser.skipOrDie(in, junkLength);
        int fileNameLength = MinimalZipParser.read16BitUnsigned(in);
        int extrasLength = MinimalZipParser.read16BitUnsigned(in);
        return 4 + junkLength + 2 + 2 + fileNameLength + extrasLength;
    }

    public static long locateStartOfEocd(RandomAccessFileInputStream in, int searchBufferLength) throws IOException {
        int maxBufferSize = (int)Math.min((long)searchBufferLength, in.length());
        byte[] buffer = new byte[maxBufferSize];
        long rangeStart = in.length() - (long)buffer.length;
        in.setRange(rangeStart, (long)buffer.length);
        MinimalZipParser.readOrDie((InputStream)in, buffer, 0, buffer.length);
        int offset = MinimalZipParser.locateStartOfEocd(buffer);
        if (offset == -1) {
            return -1L;
        }
        return rangeStart + (long)offset;
    }

    public static int locateStartOfEocd(byte[] buffer) {
        int last4Bytes = 0;
        for (int offset = buffer.length - 1; offset >= 0; --offset) {
            last4Bytes <<= 8;
            if ((last4Bytes |= buffer[offset]) != 101010256) continue;
            return offset;
        }
        return -1;
    }

    public static MinimalCentralDirectoryMetadata parseEocd(InputStream in) throws IOException, ZipException {
        if ((int)MinimalZipParser.read32BitUnsigned(in) != 101010256) {
            throw new ZipException("Bad eocd header");
        }
        MinimalZipParser.skipOrDie(in, 6L);
        int numEntriesInCentralDirectory = MinimalZipParser.read16BitUnsigned(in);
        if (numEntriesInCentralDirectory == 65535) {
            throw new ZipException("No support for zip64");
        }
        long lengthOfCentralDirectory = MinimalZipParser.read32BitUnsigned(in);
        long offsetOfCentralDirectory = MinimalZipParser.read32BitUnsigned(in);
        return new MinimalCentralDirectoryMetadata(numEntriesInCentralDirectory, offsetOfCentralDirectory, lengthOfCentralDirectory);
    }
}

