/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.Retry;
import org.jetbrains.idea.maven.aether.ThrowingSupplier;
import org.slf4j.Logger;

public final class RetryProvider {
    private static final Random RANDOM = new Random();
    private static final double EXP_BACKOFF_FACTOR = 2.0;
    private static final double EXP_BACKOFF_JITTER = 0.3;
    private static final Retry DISABLED_SINGLETON = new Retry(){

        @Override
        public <R> R retry(@NotNull ThrowingSupplier<? extends R> supplier, @NotNull Logger logger) throws Exception {
            return supplier.get();
        }
    };

    public static Retry disabled() {
        return DISABLED_SINGLETON;
    }

    public static Retry withExponentialBackOff(final long initialDelayMs, final long backoffLimitMs, final int maxAttempts) {
        if (initialDelayMs <= 0L || backoffLimitMs <= 0L || maxAttempts <= 0) {
            throw new IllegalArgumentException("Wrong arguments provided: initialDelayMs=" + initialDelayMs + "backoffLimitMs=" + backoffLimitMs + " maxAttempts=" + maxAttempts);
        }
        return new Retry(){

            @Override
            public <R> R retry(@NotNull ThrowingSupplier<? extends R> supplier, @NotNull Logger logger) throws Exception {
                return (R)RetryProvider.exponentialBackOffRetry(initialDelayMs, backoffLimitMs, maxAttempts, supplier, logger);
            }
        };
    }

    private RetryProvider() {
    }

    private static <R> R exponentialBackOffRetry(long initialDelayMs, long backoffLimitMs, int maxAttempts, @NotNull ThrowingSupplier<? extends R> supplier, @NotNull Logger logger) throws Exception {
        long effectiveDelay = initialDelayMs;
        for (int i = 1; i <= maxAttempts; ++i) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                if (i == maxAttempts) {
                    logger.info("Retry attempts limit exceeded, tried " + maxAttempts + " times. Cause: " + e.getMessage());
                    throw e;
                }
                logger.info("Attempt " + i + " of " + maxAttempts + " failed, retrying in " + effectiveDelay + "ms. Cause: " + e.getMessage());
                effectiveDelay = RetryProvider.exponentialBackOff(effectiveDelay, backoffLimitMs);
                continue;
            }
        }
        throw new RuntimeException("Should not be reached");
    }

    private static long exponentialBackOff(long effectiveDelayMs, long backoffLimitMs) {
        try {
            Thread.sleep(effectiveDelayMs);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Unexpected thread interrupt", ex);
        }
        long nextRawDelay = (long)Math.min((double)effectiveDelayMs * 2.0, (double)backoffLimitMs);
        long jitter = (long)(RANDOM.nextDouble() * (double)nextRawDelay * 0.3);
        long jitterSign = RANDOM.nextBoolean() ? 1L : -1L;
        return nextRawDelay + jitter * jitterSign;
    }
}

