/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.CloudMatrixProgressAnimator;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestTreeRenderer;
import com.intellij.execution.testframework.PoolOfTestIcons;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.sm.SmRunnerBundle;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.testframework.sm.runner.ui.SMPoolOfTestIcons;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestsPresentationUtil {
    @NonNls
    private static final String DOUBLE_SPACE = "  ";
    @NonNls
    private static final String SECONDS_SUFFIX = " s";
    @NonNls
    private static final String MILLISECONDS_SUFFIX = " ms";
    @NonNls
    private static final String WORLD_CREATION_TIME = "0 s";
    @NonNls
    private static final String DURATION_UNKNOWN = "Unknown";
    @NonNls
    private static final String DURATION_NO_TESTS = "No tests";
    @NonNls
    private static final String DURATION_NOT_RUN = "Not run";
    @NonNls
    private static final String DURATION_RUNNING_PREFIX = "Running tests...";
    @NonNls
    private static final String DURATION_TERMINATED_PREFIX = "Terminated";
    @NonNls
    private static final String COLON = ": ";
    public static final SimpleTextAttributes PASSED_ATTRIBUTES = new SimpleTextAttributes(1, TestsUIUtil.PASSED_COLOR);
    public static final SimpleTextAttributes DEFFECT_ATTRIBUTES = new SimpleTextAttributes(1, Color.RED);
    public static final SimpleTextAttributes TERMINATED_ATTRIBUTES = new SimpleTextAttributes(1, Color.ORANGE);
    @NonNls
    private static final String RESULTS_NO_TESTS = "No tests were found";
    @NonNls
    private static final String NO_NAME_TEST = "<no name>";
    @NonNls
    private static final String UNKNOWN_TESTS_COUNT = "<...>";
    @NonNls
    static final String DEFAULT_TESTS_CATEGORY = "Tests";

    private GoogleCloudTestsPresentationUtil() {
    }

    public static String getProgressStatus_Text(long startTime, long endTime, int testsTotal, int testsCount, int failuresCount, @Nullable Set<String> allCategories, boolean isFinished) {
        StringBuilder sb = new StringBuilder();
        if (endTime == 0L) {
            sb.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.running", (Object[])new Object[0]));
        } else {
            sb.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.done", (Object[])new Object[0]));
        }
        if (allCategories != null && (allCategories.size() > 1 || allCategories.size() == 1 && !DEFAULT_TESTS_CATEGORY.equals(allCategories.iterator().next()))) {
            sb.append(' ');
            boolean first = true;
            for (String category : allCategories) {
                if (StringUtil.isEmpty((String)category)) continue;
                if (!first) {
                    sb.append(", ");
                }
                char firstChar = category.charAt(0);
                sb.append(first ? firstChar : Character.toLowerCase(firstChar));
                sb.append(category.substring(1));
                first = false;
            }
        }
        sb.append(' ').append(testsCount).append(' ');
        sb.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.of", (Object[])new Object[0]));
        sb.append(' ').append(testsTotal != 0 ? Integer.valueOf(testsTotal) : (!isFinished ? UNKNOWN_TESTS_COUNT : Integer.valueOf(0)));
        if (failuresCount > 0) {
            sb.append(DOUBLE_SPACE);
            sb.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.failed", (Object[])new Object[0]));
            sb.append(' ').append(failuresCount);
        }
        if (endTime != 0L) {
            long time = endTime - startTime;
            sb.append(DOUBLE_SPACE);
            sb.append('(').append(GoogleCloudTestsPresentationUtil.convertToSecondsOrMs(time)).append(')');
        }
        sb.append(DOUBLE_SPACE);
        return sb.toString();
    }

    public static void formatRootNodeWithChildren(GoogleCloudTestProxy.GoogleCloudRootTestProxy testProxy, GoogleCloudTestTreeRenderer renderer) {
        renderer.setIcon(GoogleCloudTestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        String text = magnitude == TestStateInfo.Magnitude.RUNNING_INDEX ? SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.running.tests", (Object[])new Object[0]) : (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX ? SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", (Object[])new Object[0]) : (magnitude == TestStateInfo.Magnitude.TIMEOUT_INDEX ? "Timed out" : (magnitude == TestStateInfo.Magnitude.INFRASTRUCTURE_FAILURE_INDEX ? "Infrastructure failure" : (magnitude == TestStateInfo.Magnitude.TRIGGERING_ERROR_INDEX ? "Triggering error" : SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.test.results", (Object[])new Object[0])))));
        renderer.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public static void formatRootNodeWithoutChildren(GoogleCloudTestProxy.GoogleCloudRootTestProxy testProxy, GoogleCloudTestTreeRenderer renderer) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        if (magnitude == TestStateInfo.Magnitude.RUNNING_INDEX) {
            renderer.setIcon(GoogleCloudTestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.instantiating.tests", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.NOT_RUN_INDEX) {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.not.test.results", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.TERMINATED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.TERMINATED_ICON);
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.was.terminated", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (magnitude == TestStateInfo.Magnitude.PASSED_INDEX) {
            renderer.setIcon(PoolOfTestIcons.PASSED_ICON);
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.all.tests.passed", (Object[])new Object[0]), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        } else if (!testProxy.getChildren().isEmpty()) {
            GoogleCloudTestsPresentationUtil.formatRootNodeWithChildren(testProxy, renderer);
        } else {
            renderer.setIcon(PoolOfTestIcons.NOT_RAN);
            renderer.append(testProxy.isTestsReporterAttached() ? SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.no.tests.were.found", (Object[])new Object[0]) : SmRunnerBundle.message((String)"sm.test.runner.ui.tests.tree.presentation.labels.test.reporter.not.attached", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    public static void formatTestProxy(GoogleCloudTestProxy testProxy, GoogleCloudTestTreeRenderer renderer) {
        renderer.setIcon(GoogleCloudTestsPresentationUtil.getIcon(testProxy, renderer.getConsoleProperties()));
        renderer.append(testProxy.getPresentableName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    @NotNull
    public static String getPresentableName(GoogleCloudTestProxy testProxy) {
        String parentName;
        String name;
        GoogleCloudTestProxy parent = testProxy.getParent();
        String presentationCandidate = name = testProxy.getName();
        if (parent != null && name.startsWith(parentName = parent.getName()) && (presentationCandidate = name.substring(parentName.length())).startsWith(".")) {
            presentationCandidate = presentationCandidate.substring(1);
        }
        presentationCandidate = presentationCandidate.trim();
        if (StringUtil.isEmpty((String)(presentationCandidate = presentationCandidate.replaceAll("\\s+", " ")))) {
            return NO_NAME_TEST;
        }
        return presentationCandidate;
    }

    @NotNull
    public static String getPresentableNameTrimmedOnly(@NotNull GoogleCloudTestProxy testProxy) {
        String name = testProxy.getName();
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.isEmpty()) {
            name = NO_NAME_TEST;
        }
        return name;
    }

    @Nullable
    private static Icon getIcon(GoogleCloudTestProxy testProxy, TestConsoleProperties consoleProperties) {
        TestStateInfo.Magnitude magnitude = testProxy.getMagnitudeInfo();
        boolean hasErrors = testProxy.hasErrors();
        switch (magnitude) {
            case ERROR_INDEX: {
                return PoolOfTestIcons.ERROR_ICON;
            }
            case FAILED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.FAILED_E_ICON : PoolOfTestIcons.FAILED_ICON;
            }
            case IGNORED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.IGNORED_E_ICON : PoolOfTestIcons.IGNORED_ICON;
            }
            case NOT_RUN_INDEX: {
                return PoolOfTestIcons.NOT_RAN;
            }
            case COMPLETE_INDEX: 
            case PASSED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.PASSED_E_ICON : PoolOfTestIcons.PASSED_ICON;
            }
            case SCHEDULED_INDEX: {
                return testProxy.isActiveScheduled() ? CloudMatrixProgressAnimator.getCurrentFrame() : AllIcons.Process.Step_passive;
            }
            case TIMEOUT_INDEX: {
                return AllIcons.Debugger.KillProcess;
            }
            case INFRASTRUCTURE_FAILURE_INDEX: {
                return AllIcons.Debugger.Db_exception_breakpoint;
            }
            case TRIGGERING_ERROR_INDEX: {
                return AllIcons.Debugger.Db_invalid_breakpoint;
            }
            case RUNNING_INDEX: {
                if (consoleProperties.isPaused()) {
                    return hasErrors ? SMPoolOfTestIcons.PAUSED_E_ICON : AllIcons.RunConfigurations.TestPaused;
                }
                int frameIndex = TestsProgressAnimator.getCurrentFrameIndex();
                return hasErrors ? SMPoolOfTestIcons.RUNNING_E_ICON : TestsProgressAnimator.FRAMES[frameIndex];
            }
            case SKIPPED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.SKIPPED_E_ICON : PoolOfTestIcons.SKIPPED_ICON;
            }
            case TERMINATED_INDEX: {
                return hasErrors ? SMPoolOfTestIcons.TERMINATED_E_ICON : PoolOfTestIcons.TERMINATED_ICON;
            }
        }
        return null;
    }

    @Nullable
    public static String getTestStatusPresentation(GoogleCloudTestProxy proxy) {
        return proxy.getMagnitudeInfo().getTitle();
    }

    public static void appendSuiteStatusColorPresentation(GoogleCloudTestProxy proxy, ColoredTableCellRenderer renderer) {
        int passedCount = 0;
        int errorsCount = 0;
        int failedCount = 0;
        int ignoredCount = 0;
        if (proxy.isLeaf()) {
            renderer.append(RESULTS_NO_TESTS, proxy.wasLaunched() ? PASSED_ATTRIBUTES : DEFFECT_ATTRIBUTES);
            return;
        }
        List<GoogleCloudTestProxy> allTestCases = proxy.getAllTests();
        for (GoogleCloudTestProxy testOrSuite : allTestCases) {
            if (testOrSuite.isSuite()) continue;
            switch (testOrSuite.getMagnitudeInfo()) {
                case COMPLETE_INDEX: 
                case PASSED_INDEX: {
                    ++passedCount;
                    break;
                }
                case ERROR_INDEX: {
                    ++errorsCount;
                    break;
                }
                case FAILED_INDEX: {
                    ++failedCount;
                    break;
                }
                case IGNORED_INDEX: 
                case SKIPPED_INDEX: {
                    ++ignoredCount;
                    break;
                }
            }
        }
        String separator = " ";
        if (failedCount > 0) {
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tabs.statistics.columns.results.count.msg.failed", (Object[])new Object[]{failedCount}) + " ", DEFFECT_ATTRIBUTES);
        }
        if (errorsCount > 0) {
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tabs.statistics.columns.results.count.msg.errors", (Object[])new Object[]{errorsCount}) + " ", DEFFECT_ATTRIBUTES);
        }
        if (ignoredCount > 0) {
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tabs.statistics.columns.results.count.msg.ignored", (Object[])new Object[]{ignoredCount}) + " ", SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
        }
        if (passedCount > 0) {
            renderer.append(SmRunnerBundle.message((String)"sm.test.runner.ui.tabs.statistics.columns.results.count.msg.passed", (Object[])new Object[]{passedCount}), PASSED_ATTRIBUTES);
        }
    }

    @Nullable
    public static String getDurationPresentation(GoogleCloudTestProxy proxy) {
        switch (proxy.getMagnitudeInfo()) {
            case ERROR_INDEX: 
            case FAILED_INDEX: 
            case IGNORED_INDEX: 
            case COMPLETE_INDEX: 
            case PASSED_INDEX: 
            case SKIPPED_INDEX: {
                return GoogleCloudTestsPresentationUtil.getDurationTimePresentation(proxy);
            }
            case NOT_RUN_INDEX: {
                return DURATION_NOT_RUN;
            }
            case RUNNING_INDEX: {
                return GoogleCloudTestsPresentationUtil.getDurationWithPrefixPresentation(proxy, DURATION_RUNNING_PREFIX);
            }
            case TERMINATED_INDEX: {
                return GoogleCloudTestsPresentationUtil.getDurationWithPrefixPresentation(proxy, DURATION_TERMINATED_PREFIX);
            }
        }
        return DURATION_UNKNOWN;
    }

    private static String getDurationWithPrefixPresentation(GoogleCloudTestProxy proxy, String prefix) {
        if (proxy.getDuration() != null) {
            return prefix + COLON + GoogleCloudTestsPresentationUtil.getDurationTimePresentation(proxy);
        }
        return "<" + prefix + ">";
    }

    private static String getDurationTimePresentation(GoogleCloudTestProxy proxy) {
        Long duration = proxy.getDuration();
        if (duration == null) {
            return proxy.isSuite() && proxy.isLeaf() ? DURATION_NO_TESTS : DURATION_UNKNOWN;
        }
        return GoogleCloudTestsPresentationUtil.convertToSecondsOrMs((long)duration);
    }

    private static String convertToSecondsOrMs(@NotNull Long duration) {
        if (duration == 0L) {
            return WORLD_CREATION_TIME;
        }
        if (duration < 100L) {
            return String.valueOf(duration) + MILLISECONDS_SUFFIX;
        }
        return String.valueOf(duration.floatValue() / 1000.0f) + SECONDS_SUFFIX;
    }

    public static void appendTestStatusColorPresentation(GoogleCloudTestProxy proxy, ColoredTableCellRenderer renderer) {
        String title = GoogleCloudTestsPresentationUtil.getTestStatusPresentation(proxy);
        TestStateInfo.Magnitude info = proxy.getMagnitudeInfo();
        switch (info) {
            case COMPLETE_INDEX: 
            case PASSED_INDEX: {
                renderer.append(title, PASSED_ATTRIBUTES);
                break;
            }
            case RUNNING_INDEX: {
                renderer.append(title, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                break;
            }
            case NOT_RUN_INDEX: {
                renderer.append(title, SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES);
                break;
            }
            case IGNORED_INDEX: 
            case SKIPPED_INDEX: {
                renderer.append(title, SimpleTextAttributes.EXCLUDED_ATTRIBUTES);
                break;
            }
            case ERROR_INDEX: 
            case FAILED_INDEX: {
                renderer.append(title, DEFFECT_ATTRIBUTES);
                break;
            }
            case TERMINATED_INDEX: {
                renderer.append(title, TERMINATED_ATTRIBUTES);
                break;
            }
        }
    }
}

