/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.launcher;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.storage.Storage;
import com.google.api.services.testing.Testing;
import com.google.api.services.testing.model.AndroidDeviceCatalog;
import com.google.api.services.testing.model.TestEnvironmentCatalog;
import com.google.api.services.toolresults.Toolresults;
import com.google.gct.login.GoogleLogin;
import com.google.gct.testing.CloudTestingUtils;
import org.jetbrains.annotations.NotNull;

public class CloudAuthenticator {
    private static final String APPLICATION_NAME = "GCTL";
    private static CloudAuthenticator instance;
    private HttpTransport myHttpTransport;
    private Credential myCredential;
    private Storage myStorage;
    private CloudResourceManager myCloudResourceManager;
    private Testing myTest;
    private Toolresults myToolresults;
    private long myLastDiscoveryServiceInvocationTimestamp = -1L;

    @NotNull
    public static CloudAuthenticator getInstance() {
        if (instance == null) {
            instance = new CloudAuthenticator();
        }
        return instance;
    }

    @VisibleForTesting
    public static void setInstance(CloudAuthenticator testInstance) {
        instance = testInstance;
    }

    public Storage getPublicStorage() {
        if (this.myHttpTransport == null) {
            this.myHttpTransport = this.createHttpTransport();
        }
        return new Storage.Builder(this.myHttpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), null).setApplicationName(APPLICATION_NAME).build();
    }

    @NotNull
    public Storage getStorage() {
        this.prepareCredential();
        if (this.myStorage == null) {
            this.myStorage = new Storage.Builder(this.myHttpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)this.myCredential).setApplicationName(APPLICATION_NAME).build();
        }
        return this.myStorage;
    }

    public void recreateTestAndToolResults(String testBackendUrl, String toolResultsBackendUrl) {
        this.prepareCredential();
        this.myTest = new Testing.Builder(this.myHttpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)this.myCredential).setApplicationName(APPLICATION_NAME).setRootUrl(testBackendUrl).build();
        this.myToolresults = new Toolresults.Builder(this.myHttpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)this.myCredential).setApplicationName(APPLICATION_NAME).setRootUrl(toolResultsBackendUrl).build();
    }

    @NotNull
    public CloudResourceManager getCloudResourceManager() {
        this.prepareCredential();
        if (this.myCloudResourceManager == null) {
            this.myCloudResourceManager = new CloudResourceManager.Builder(this.myHttpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)this.myCredential).setApplicationName(APPLICATION_NAME).build();
        }
        return this.myCloudResourceManager;
    }

    @NotNull
    public Testing getTest() {
        return this.getTest(null);
    }

    @NotNull
    public Testing getTest(String endpoint) {
        this.prepareCredential();
        if (this.myTest == null) {
            Testing.Builder builder = new Testing.Builder(this.myHttpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)this.myCredential).setApplicationName(APPLICATION_NAME);
            if (endpoint != null) {
                builder.setRootUrl(endpoint);
            }
            this.myTest = builder.build();
        }
        return this.myTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidDeviceCatalog getAndroidDeviceCatalogForEnvironment(String endpoint) {
        long currentTimestamp = System.currentTimeMillis();
        try {
            AndroidDeviceCatalog catalog = ((TestEnvironmentCatalog)this.getTest(endpoint).testEnvironmentCatalog().get("ANDROID").execute()).getAndroidDeviceCatalog();
            if (catalog.getVersions().isEmpty() || catalog.getModels().isEmpty() || catalog.getRuntimeConfiguration().getLocales().isEmpty() || catalog.getRuntimeConfiguration().getOrientations().isEmpty()) {
                this.showDeviceCatalogError("Android device catalog is empty for some dimensions", currentTimestamp);
            }
            AndroidDeviceCatalog androidDeviceCatalog = catalog;
            return androidDeviceCatalog;
        }
        catch (Exception e) {
            this.showDeviceCatalogError("Exception while getting Android device catalog\n\n" + e.getMessage(), currentTimestamp);
            AndroidDeviceCatalog androidDeviceCatalog = null;
            return androidDeviceCatalog;
        }
        finally {
            this.myLastDiscoveryServiceInvocationTimestamp = currentTimestamp;
        }
    }

    public AndroidDeviceCatalog getAndroidDeviceCatalog() {
        return this.getAndroidDeviceCatalogForEnvironment(null);
    }

    private void showDeviceCatalogError(String errorMessageSuffix, long currentTimestamp) {
        if (currentTimestamp - this.myLastDiscoveryServiceInvocationTimestamp > 1000L) {
            CloudTestingUtils.showErrorMessage(null, "Error retrieving android device catalog", "Failed to retrieve available firebase devices! Please try again later.\n" + errorMessageSuffix);
        }
    }

    @NotNull
    public Toolresults getToolresults() {
        this.prepareCredential();
        if (this.myToolresults == null) {
            this.myToolresults = new Toolresults.Builder(this.myHttpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)this.myCredential).setApplicationName(APPLICATION_NAME).build();
        }
        return this.myToolresults;
    }

    public void prepareCredential() {
        if (this.myHttpTransport == null) {
            this.myHttpTransport = this.createHttpTransport();
        }
        if (this.myCredential == null) {
            if (!CloudAuthenticator.authorize()) {
                throw new RuntimeException("Failed to authorize to Google Cloud!");
            }
            this.myCredential = GoogleLogin.getInstance().getCredential();
        }
    }

    @NotNull
    private HttpTransport createHttpTransport() {
        try {
            return GoogleNetHttpTransport.newTrustedTransport();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            throw new RuntimeException("Failed to acquire HTTP transport for Google Cloud Storage!");
        }
    }

    public static boolean authorize() {
        GoogleLogin googleLogin = GoogleLogin.getInstance();
        Credential credential = googleLogin.getCredential();
        if (credential == null) {
            googleLogin.logIn();
            credential = googleLogin.getCredential();
            if (credential == null) {
                return false;
            }
        }
        return true;
    }

    public static boolean isUserLoggedIn() {
        return GoogleLogin.getInstance().getCredential() != null;
    }
}

