/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxTargetProvider;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.google.gct.testing.android.CloudConfiguration;
import com.google.gct.testing.android.CloudMatrixTestRunningState;
import com.google.gct.testing.android.CloudTargetUtil;
import com.google.gct.testing.android.CloudTestMatrixTargetConfigurable;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudTestMatrixTargetProvider
extends DeployTargetProvider {
    @NotNull
    public String getId() {
        return TargetSelectionMode.FIREBASE_DEVICE_MATRIX.name();
    }

    @NotNull
    public String getDisplayName() {
        return "Firebase Test Lab Device Matrix";
    }

    @NotNull
    public DeployTargetState createState() {
        return new State();
    }

    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        return new CloudTestMatrixTargetConfigurable(project, parentDisposable, context);
    }

    protected boolean isApplicable(boolean testConfiguration) {
        return testConfiguration;
    }

    @NotNull
    public DeployTarget getDeployTarget(@NotNull Project project) {
        return new DeployTarget(){

            public boolean hasCustomRunProfileState(@NotNull Executor executor) {
                return !(executor instanceof DefaultDebugExecutor);
            }

            public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull DeployTargetState state) throws ExecutionException {
                RunProfile runProfile = env.getRunProfile();
                if (!(runProfile instanceof AndroidTestRunConfiguration)) {
                    return null;
                }
                AndroidTestRunConfiguration runConfiguration = (AndroidTestRunConfiguration)runProfile;
                AndroidFacet facet = AndroidFacet.getInstance((Module)((AndroidRunConfigurationModule)runConfiguration.getConfigurationModule()).getModule());
                State cloudTargetState = (State)state;
                return new CloudMatrixTestRunningState(env, facet, runConfiguration, cloudTargetState.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID, cloudTargetState.SELECTED_CLOUD_MATRIX_PROJECT_ID);
            }

            @Nullable
            public DeviceFutures getDevices(@NotNull Project project) {
                DeviceAndSnapshotComboBoxTargetProvider provider = new DeviceAndSnapshotComboBoxTargetProvider();
                return provider.getDeployTarget(project).getDevices(project);
            }
        };
    }

    public static final class State
    extends DeployTargetState {
        public int SELECTED_CLOUD_MATRIX_CONFIGURATION_ID = -1;
        public String SELECTED_CLOUD_MATRIX_PROJECT_ID = "";

        @NotNull
        public List<ValidationError> validate(@NotNull AndroidFacet facet) {
            return CloudTargetUtil.validate(facet, CloudConfiguration.Kind.MATRIX, this.SELECTED_CLOUD_MATRIX_PROJECT_ID, this.SELECTED_CLOUD_MATRIX_CONFIGURATION_ID);
        }
    }
}

