/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.tools.idea.run.AndroidProcessText;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.google.gct.testing.CloudConfigurationHelper;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloudMatrixTestRunningState
implements RunProfileState {
    @NotNull
    private final ExecutionEnvironment myEnvironment;
    @NotNull
    private final AndroidFacet myFacet;
    private final int myMatrixConfigurationId;
    @NotNull
    private final String myCloudProjectId;
    @NotNull
    private final AndroidTestRunConfiguration myConfiguration;
    @NotNull
    private final ProcessHandler myProcessHandler = new DefaultDebugProcessHandler();

    public CloudMatrixTestRunningState(@NotNull ExecutionEnvironment environment, @NotNull AndroidFacet facet, @NotNull AndroidTestRunConfiguration configuration, int matrixConfigurationId, @NotNull String cloudProjectId) {
        this.myEnvironment = environment;
        this.myFacet = facet;
        this.myConfiguration = configuration;
        this.myMatrixConfigurationId = matrixConfigurationId;
        this.myCloudProjectId = cloudProjectId;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner runner) throws ExecutionException {
        AndroidProcessText.attach((ProcessHandler)this.myProcessHandler);
        return CloudConfigurationHelper.executeCloudMatrixTests(this.myMatrixConfigurationId, this.myCloudProjectId, this, executor);
    }

    @NotNull
    public ExecutionEnvironment getEnvironment() {
        return this.myEnvironment;
    }

    @NotNull
    public AndroidFacet getFacet() {
        return this.myFacet;
    }

    @NotNull
    public AndroidTestRunConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }
}

