/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.android;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.android.tools.idea.run.TargetDeviceFilter;
import com.android.tools.idea.run.TargetSelectionMode;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetConfigurable;
import com.android.tools.idea.run.editor.DeployTargetConfigurableContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class CloudDebuggingTargetProvider
extends DeployTargetProvider {
    private String myCloudDeviceSerialNumber;

    @NotNull
    public String getId() {
        return TargetSelectionMode.FIREBASE_DEVICE_DEBUGGING.name();
    }

    @NotNull
    public String getDisplayName() {
        return "Firebase Test Lab Debugging Device";
    }

    @NotNull
    public DeployTargetState createState() {
        return new State();
    }

    public DeployTargetConfigurable createConfigurable(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull DeployTargetConfigurableContext context) {
        return DeployTargetConfigurable.DEFAULT_CONFIGURABLE;
    }

    @NotNull
    public DeployTarget getDeployTarget(@NotNull Project project) {
        return new DeployTarget(){

            public boolean hasCustomRunProfileState(@NotNull Executor executor) {
                return false;
            }

            public RunProfileState getRunProfileState(@NotNull Executor executor, @NotNull ExecutionEnvironment env, @NotNull DeployTargetState state) throws ExecutionException {
                return null;
            }

            @NotNull
            public DeviceFutures getDevices(@NotNull Project project) {
                return DeviceFutures.forDevices((Iterable)DeviceSelectionUtils.getAllCompatibleDevices((Predicate)new TargetDeviceFilter(){

                    public boolean matchesDevice(@NotNull IDevice device) {
                        if (device.isEmulator()) {
                            return false;
                        }
                        return device.getSerialNumber().equals(CloudDebuggingTargetProvider.this.myCloudDeviceSerialNumber);
                    }
                }));
            }
        };
    }

    protected boolean isApplicable(boolean testConfiguration) {
        return false;
    }

    public void setCloudDeviceSerialNumber(String cloudDeviceSerialNumber) {
        this.myCloudDeviceSerialNumber = cloudDeviceSerialNumber;
    }

    public static final class State
    extends DeployTargetState {
        @NotNull
        public List<ValidationError> validate(@NotNull AndroidFacet facet) {
            return Lists.newArrayList();
        }
    }
}

