/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

import com.android.tools.analytics.UsageTracker;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gct.testing.CloudConfigurationHelper;
import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.ConfigurationInstance;
import com.google.gct.testing.ConfigurationResult;
import com.google.gct.testing.ScreenshotComparisonDialog;
import com.google.gct.testing.TestName;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestResultsViewer;
import com.google.gct.testing.results.GoogleCloudTestTreeView;
import com.google.gct.testing.results.GoogleCloudTestingResultsForm;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ShowScreenshotsAction
extends AnAction {
    private static final String TEXT = "View Screenshots";
    private static final String DESCRIPTION = "Open the Screenshot Comparison Tool";
    private static final Icon ICON = AllIcons.Actions.Share;
    public static final Function<AbstractTestProxy, TestName> TO_TEST_NAMES = new Function<AbstractTestProxy, TestName>(){

        public TestName apply(@Nullable AbstractTestProxy input) {
            return ShowScreenshotsAction.getTestNameForNode(input);
        }
    };

    public ShowScreenshotsAction() {
        super(TEXT, DESCRIPTION, ICON);
        this.getTemplatePresentation().setEnabled(false);
    }

    public void actionPerformed(AnActionEvent e) {
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.CLOUD_TESTING).setKind(AndroidStudioEvent.EventKind.CLOUD_TESTING_COMPARE_SCREENSHOTS_OPENED));
        GoogleCloudTestTreeView sender = (GoogleCloudTestTreeView)((Object)e.getData(GoogleCloudTestTreeView.CLOUD_TEST_RUNNER_VIEW));
        if (sender == null) {
            return;
        }
        GoogleCloudTestResultsViewer resultsViewer = sender.getResultsViewer();
        GoogleCloudTestProxy.GoogleCloudRootTestProxy rootNode = ((GoogleCloudTestingResultsForm)resultsViewer).getTestsRootNode();
        AbstractTestProxy selectedLeaf = this.getFirstLeaf(((GoogleCloudTestingResultsForm)resultsViewer).getTreeView().getSelectedTest());
        if (selectedLeaf.getParent() == null || selectedLeaf.getParent().getParent() == null) {
            this.showNoScreenshotsWarning(e);
            return;
        }
        AbstractTestProxy selectedConfigurationNode = selectedLeaf.getParent().getParent();
        ConfigurationInstance configurationInstance = ConfigurationInstance.parseFromResultsViewerDisplayString(selectedConfigurationNode.getName());
        Map<String, ConfigurationResult> results = CloudConfigurationHelper.getCloudResultsAdapter(rootNode.getTestRunId()).getResults();
        if (results.get(configurationInstance.getEncodedString()).getScreenshotMetadata().isEmpty()) {
            this.showNoScreenshotsWarning(e);
            return;
        }
        AbstractTestProxy anotherConfigurationNode = this.findClosestNeighborWithResults(selectedConfigurationNode);
        ConfigurationInstance anotherConfigurationInstance = anotherConfigurationNode == null ? null : ConfigurationInstance.parseFromResultsViewerDisplayString(anotherConfigurationNode.getName());
        ArrayList allTests = Lists.newArrayList((Iterable)Iterables.transform((Iterable)selectedLeaf.getParent().getChildren(), TO_TEST_NAMES));
        ScreenshotComparisonDialog dialog = new ScreenshotComparisonDialog((Project)e.getData(PlatformDataKeys.PROJECT), rootNode, CloudConfigurationHelper.getSelectedCloudConfiguration(rootNode.getTestRunId()), configurationInstance, anotherConfigurationInstance, allTests, ShowScreenshotsAction.getTestNameForNode(selectedLeaf), results);
        dialog.showDialog();
    }

    private void showNoScreenshotsWarning(AnActionEvent e) {
        CloudTestingUtils.showBalloonMessage((Project)e.getData(PlatformDataKeys.PROJECT), "Screenshots are not yet available for this configuration", MessageType.WARNING, 3);
    }

    private AbstractTestProxy findClosestNeighborWithResults(AbstractTestProxy givenConfigurationNode) {
        AbstractTestProxy configurationNode;
        List allConfigurationNodes = givenConfigurationNode.getParent().getChildren();
        int givenConfigurationIndex = 0;
        Iterator iterator = allConfigurationNodes.iterator();
        while (iterator.hasNext() && (configurationNode = (AbstractTestProxy)iterator.next()) != givenConfigurationNode) {
            ++givenConfigurationIndex;
        }
        int forwardIndex = givenConfigurationIndex + 1;
        int backwardIndex = givenConfigurationIndex - 1;
        while (forwardIndex < allConfigurationNodes.size() || backwardIndex >= 0) {
            AbstractTestProxy neighborConfiguration;
            if (forwardIndex < allConfigurationNodes.size()) {
                neighborConfiguration = (AbstractTestProxy)allConfigurationNodes.get(forwardIndex);
                if (this.hasTestResults(neighborConfiguration)) {
                    return neighborConfiguration;
                }
                ++forwardIndex;
            }
            if (backwardIndex < 0) continue;
            neighborConfiguration = (AbstractTestProxy)allConfigurationNodes.get(backwardIndex);
            if (this.hasTestResults(neighborConfiguration)) {
                return neighborConfiguration;
            }
            --backwardIndex;
        }
        return null;
    }

    private boolean hasTestResults(AbstractTestProxy configuration) {
        return configuration.getAllTests().size() > configuration.getChildren().size() + 1;
    }

    private static TestName getTestNameForNode(AbstractTestProxy testNode) {
        return new TestName(testNode.getParent().getName(), testNode.getName());
    }

    private AbstractTestProxy getFirstLeaf(AbstractTestProxy testNode) {
        if (!testNode.isLeaf()) {
            return this.getFirstLeaf((AbstractTestProxy)testNode.getChildren().get(0));
        }
        return testNode;
    }

    public void update(AnActionEvent actionEvent) {
        GoogleCloudTestTreeView sender = (GoogleCloudTestTreeView)((Object)actionEvent.getData(GoogleCloudTestTreeView.CLOUD_TEST_RUNNER_VIEW));
        if (sender == null) {
            return;
        }
        AbstractTestProxy selectedNode = ((GoogleCloudTestingResultsForm)sender.getResultsViewer()).getTreeView().getSelectedTest();
        if (selectedNode == null || selectedNode instanceof GoogleCloudTestProxy.GoogleCloudRootTestProxy) {
            actionEvent.getPresentation().setEnabled(false);
        } else {
            actionEvent.getPresentation().setEnabled(true);
        }
    }
}

