/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.sync;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.MemoryProbe;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.NdkProjectInfo;
import com.android.tools.ndk.sync.NativeWorkspaceImpl;
import com.android.tools.ndk.sync.NativeWorkspaceModifier;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleCppSyncStats;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0017J\b\u0010\u0013\u001a\u00020\u0012H\u0017J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/ndk/sync/NativeWorkspaceModificationTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "nativeWorkspaceModifiers", "", "Lcom/android/tools/ndk/sync/NativeWorkspaceModifier;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;Ljava/util/Collection;)V", "nativeModuleStats", "", "Lcom/google/wireless/android/sdk/stats/GradleCppSyncStats$NativeModuleStats;", "nativeWorkspace", "Lcom/android/tools/ndk/sync/NativeWorkspaceImpl;", "startedMs", "", "onFinished", "", "onSuccess", "run", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Companion", "android-ndk"})
public final class NativeWorkspaceModificationTask
extends Task.Modal {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Collection<NativeWorkspaceModifier> nativeWorkspaceModifiers;
    private long startedMs;
    @NotNull
    private final List<GradleCppSyncStats.NativeModuleStats> nativeModuleStats;
    @NotNull
    private final NativeWorkspaceImpl nativeWorkspace;
    @NotNull
    private static final Logger logger;

    public NativeWorkspaceModificationTask(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Collection<? extends NativeWorkspaceModifier> nativeWorkspaceModifiers) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkNotNullParameter(nativeWorkspaceModifiers, (String)"nativeWorkspaceModifiers");
        super(project, "Resolving C/C++ Configurations", true);
        this.nativeWorkspaceModifiers = nativeWorkspaceModifiers;
        this.nativeModuleStats = new ArrayList();
        this.nativeWorkspace = new NativeWorkspaceImpl(project, modelsProvider, false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public void run(@NotNull ProgressIndicator indicator) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.startedMs = System.currentTimeMillis();
        indicator.setIndeterminate(false);
        Ref.IntRef index = new Ref.IntRef();
        index.element = 1;
        Iterable $this$groupBy$iv = this.nativeWorkspaceModifiers;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            NativeWorkspaceModifier it = (NativeWorkspaceModifier)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getModule();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        destination$iv$iv.forEach(new BiConsumer(this, indicator, index){
            final /* synthetic */ NativeWorkspaceModificationTask this$0;
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Ref.IntRef $index;
            {
                this.this$0 = $receiver;
                this.$indicator = $indicator;
                this.$index = $index;
            }

            /*
             * WARNING - void declaration
             */
            public final void accept(@NotNull String module, @NotNull List<? extends NativeWorkspaceModifier> modifiers) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
                NativeWorkspaceModificationTask.access$getNativeWorkspace$p(this.this$0).setModule(module);
                Iterable iterable = modifiers;
                ProgressIndicator progressIndicator = this.$indicator;
                Ref.IntRef intRef = this.$index;
                NativeWorkspaceModificationTask nativeWorkspaceModificationTask = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    NativeWorkspaceModifier modifier = (NativeWorkspaceModifier)element$iv;
                    boolean bl = false;
                    progressIndicator.checkCanceled();
                    progressIndicator.setText("Processing module " + module + "...");
                    int n = intRef.element;
                    intRef.element = n + 1;
                    progressIndicator.setFraction(0.5 * (double)n / (double)NativeWorkspaceModificationTask.access$getNativeWorkspaceModifiers$p(nativeWorkspaceModificationTask).size());
                    modifier.modify(NativeWorkspaceModificationTask.access$getNativeWorkspace$p(nativeWorkspaceModificationTask));
                }
                ((Collection)NativeWorkspaceModificationTask.access$getNativeModuleStats$p(this.this$0)).add(NativeWorkspaceModificationTask.access$getNativeWorkspace$p(this.this$0).getStatsForCurrentModule());
            }
        });
        this.nativeWorkspace.preCommit((ProgressIndicator)new StandardProgressIndicator(indicator){
            private final /* synthetic */ StandardProgressIndicator $$delegate_0;
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                Intrinsics.checkNotNull((Object)$indicator, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.StandardProgressIndicator");
                this.$$delegate_0 = (StandardProgressIndicator)$indicator;
            }

            public void cancel() {
                this.$$delegate_0.cancel();
            }

            public void checkCanceled() {
                this.$$delegate_0.checkCanceled();
            }

            public double getFraction() {
                return this.$$delegate_0.getFraction();
            }

            @NotNull
            public ModalityState getModalityState() {
                return this.$$delegate_0.getModalityState();
            }

            @NlsContexts.ProgressText
            public String getText() {
                return this.$$delegate_0.getText();
            }

            @NlsContexts.ProgressDetails
            public String getText2() {
                return this.$$delegate_0.getText2();
            }

            public boolean isCanceled() {
                return this.$$delegate_0.isCanceled();
            }

            public boolean isIndeterminate() {
                return this.$$delegate_0.isIndeterminate();
            }

            public boolean isModal() {
                return this.$$delegate_0.isModal();
            }

            public boolean isPopupWasShown() {
                return this.$$delegate_0.isPopupWasShown();
            }

            public boolean isRunning() {
                return this.$$delegate_0.isRunning();
            }

            public boolean isShowing() {
                return this.$$delegate_0.isShowing();
            }

            public void popState() {
                this.$$delegate_0.popState();
            }

            public void pushState() {
                this.$$delegate_0.pushState();
            }

            public void setIndeterminate(boolean p0) {
                this.$$delegate_0.setIndeterminate(p0);
            }

            public void setModalityProgress(@Nullable ProgressIndicator p0) {
                this.$$delegate_0.setModalityProgress(p0);
            }

            public void setText(@NlsContexts.ProgressText String p0) {
                this.$$delegate_0.setText(p0);
            }

            public void setText2(@NlsContexts.ProgressDetails String p0) {
                this.$$delegate_0.setText2(p0);
            }

            public void start() {
                this.$$delegate_0.start();
            }

            public void stop() {
                this.$$delegate_0.stop();
            }

            public void setFraction(double fraction) {
                this.$indicator.setFraction(fraction * 0.5 + 0.5);
            }
        });
    }

    @UiThread
    public void onSuccess() {
        super.onSuccess();
        if (!this.getProject().isDisposed()) {
            this.nativeWorkspace.commit();
        }
    }

    @UiThread
    public void onFinished() {
        boolean hasNative;
        super.onFinished();
        this.nativeWorkspace.dispose();
        boolean bl = hasNative = !this.nativeWorkspaceModifiers.isEmpty();
        if (hasNative) {
            GradleCppSyncStats.Builder builder;
            AndroidStudioEvent.Builder builder2;
            long syncTimeMs = System.currentTimeMillis() - this.startedMs;
            logger.info("Updating model took " + (double)this.startedMs / 1000.0 + "s");
            AndroidStudioEvent.Builder $this$onFinished_u24lambda_u2d2 = builder2 = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.GRADLE_SYNC).setKind(AndroidStudioEvent.EventKind.GRADLE_CPP_SYNC_COMPLETED);
            boolean bl2 = false;
            GradleCppSyncStats.Builder $this$onFinished_u24lambda_u2d2_u24lambda_u2d1 = builder = $this$onFinished_u24lambda_u2d2.getGradleCppSyncStatsBuilder();
            boolean bl3 = false;
            $this$onFinished_u24lambda_u2d2_u24lambda_u2d1.setNativeWorkspaceSyncTimeMs(syncTimeMs);
            $this$onFinished_u24lambda_u2d2_u24lambda_u2d1.addAllSyncedNativeModuleStats((Iterable)this.nativeModuleStats);
            if (Random.Default.nextInt(100) == 0) {
                Object[] objectArray = new String[]{"com.jetbrains.cidr.lang.", String.class.getPackage().getName() + ".", File.class.getPackage().getName() + ".", com.google.common.collect.ImmutableList.class.getPackage().getName() + ".", ImmutableList.class.getPackage().getName() + ".", List.class.getPackage().getName() + ".", Object.class.getPackage().getName() + ".", ArrayList.class.getPackage().getName() + "."};
                MemoryProbe memoryProbe = new MemoryProbe(CollectionsKt.listOf((Object[])objectArray), null, null, false, null, 30, null);
                OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(project)");
                long size = memoryProbe.check((Object)oCWorkspace);
                $this$onFinished_u24lambda_u2d2_u24lambda_u2d1.setCidrWorkspaceSize((int)size);
                logger.info("OCWorkspace size = " + (double)size / 1024.0 / 1024.0 + "MiB");
            }
            AndroidStudioEvent.Builder builder3 = builder2;
            Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder()\n           \u2026          }\n            }");
            UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder3, (Project)this.getProject()));
        } else {
            logger.info("NDK support for project '" + this.getProject().getName() + "' is disabled because the project doesn't contain any valid native configurations.");
        }
        NdkProjectInfo.get(this.getProject()).setHasNdkModules(hasNative);
        NdkHelper.disableCppLanguageSupport(this.getProject(), !hasNative);
    }

    public static final /* synthetic */ NativeWorkspaceImpl access$getNativeWorkspace$p(NativeWorkspaceModificationTask $this) {
        return $this.nativeWorkspace;
    }

    public static final /* synthetic */ List access$getNativeModuleStats$p(NativeWorkspaceModificationTask $this) {
        return $this.nativeModuleStats;
    }

    public static final /* synthetic */ Collection access$getNativeWorkspaceModifiers$p(NativeWorkspaceModificationTask $this) {
        return $this.nativeWorkspaceModifiers;
    }

    static {
        Logger logger = Logger.getInstance(NativeWorkspaceModificationTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(NativeWorksp\u2026ficationTask::class.java)");
        NativeWorkspaceModificationTask.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/ndk/sync/NativeWorkspaceModificationTask$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

