/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp;

import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.MapTypeNameFormatter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.SetTypeNameFormatter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.SharedPtrTypeNameFormatter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.SimpleContainerTypeNameFormatter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.StringTypeNameFormatter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.UniquePtrTypeNameFormatter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.UnorderedMapTypeNameFormatter;
import com.android.tools.ndk.run.lldb.renderers.formatters.libstdcpp.UnorderedSetTypeNameFormatter;
import java.util.regex.Pattern;

public class LibStdCppTypeNameFormatters {
    public static void register() {
        TypeNameFormatterCategory category = TypeNameFormatterCategory.createTypeNameFormatterCategory("libstdcpp");
        category.registerTypeNameFormatter("std::string", Pattern.compile("^std::basic_string<.+>$"), new StringTypeNameFormatter());
        category.registerTypeNameFormatter("std::deque", Pattern.compile("^std::deque<.+>$"), new SimpleContainerTypeNameFormatter("std::deque"));
        category.registerTypeNameFormatter("std::forward_list", Pattern.compile("^std::forward_list<.+>$"), new SimpleContainerTypeNameFormatter("std::forward_list"));
        category.registerTypeNameFormatter("std::list", Pattern.compile("^std::list<.+>$"), new SimpleContainerTypeNameFormatter("std::list"));
        category.registerTypeNameFormatter("std::vector", Pattern.compile("^std::vector<.+>$"), new SimpleContainerTypeNameFormatter("std::vector"));
        category.registerTypeNameFormatter("std::map", Pattern.compile("^std::map<.+>$"), new MapTypeNameFormatter("std::map"));
        category.registerTypeNameFormatter("std::multimap", Pattern.compile("^std::multimap<.+>$"), new MapTypeNameFormatter("std::multimap"));
        category.registerTypeNameFormatter("std::set", Pattern.compile("^std::set<.+>$"), new SetTypeNameFormatter("std::set"));
        category.registerTypeNameFormatter("std::multiset", Pattern.compile("^std::multiset<.+>$"), new SetTypeNameFormatter("std::multiset"));
        category.registerTypeNameFormatter("std::unordered_map", Pattern.compile("^std::unordered_map<.+>$"), new UnorderedMapTypeNameFormatter("std::unordered_map"));
        category.registerTypeNameFormatter("std::unordered_multimap", Pattern.compile("^std::unordered_multimap<.+>$"), new UnorderedMapTypeNameFormatter("std::unordered_multimap"));
        category.registerTypeNameFormatter("std::unordered_set", Pattern.compile("^std::unordered_set<.+>$"), new UnorderedSetTypeNameFormatter("std::unordered_set"));
        category.registerTypeNameFormatter("std::unordered_multiset", Pattern.compile("^std::unordered_multiset<.+>$"), new UnorderedSetTypeNameFormatter("std::unordered_multiset"));
        category.registerTypeNameFormatter("std::unique_ptr", Pattern.compile("^std::unique_ptr<.+>$"), new UniquePtrTypeNameFormatter());
        category.registerTypeNameFormatter("std::shared_ptr", Pattern.compile("^std::shared_ptr<.+>$"), new SharedPtrTypeNameFormatter());
    }
}

