/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers;

import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import com.android.utils.Pair;

class ConstTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private static final String CONST_PREFIX = "const ";
    private static final int CONST_PREFIX_LENGTH = "const ".length();
    private TypeNameFormatterCategory.TypeNameFormatter myNonConstFormatter = null;

    public static Pair<String, Boolean> getNonConstTypeName(String typeName) {
        if (typeName.startsWith(CONST_PREFIX)) {
            return Pair.of((Object)typeName.substring(CONST_PREFIX_LENGTH), (Object)Boolean.TRUE);
        }
        return Pair.of((Object)typeName, (Object)Boolean.FALSE);
    }

    public ConstTypeNameFormatter(TypeNameFormatterCategory.TypeNameFormatter nonConstFormatter) {
        this.myNonConstFormatter = nonConstFormatter;
    }

    @Override
    public String format(String rawTypeName) {
        return CONST_PREFIX + this.myNonConstFormatter.format((String)ConstTypeNameFormatter.getNonConstTypeName(rawTypeName).getFirst());
    }
}

