/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.Client;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.repository.Revision;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.ndk.NativeCompilerSetting;
import com.android.tools.idea.ndk.NativeWorkspaceService;
import com.android.tools.ndk.configuration.CxxSyncUtilsKt;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.LaunchNativeDebuggerNotifier;
import com.android.tools.ndk.run.lldb.UtilsKt;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0003\u001a\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a(\u0010\r\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0001\u00a8\u0006\u0010"}, d2={"checkRunAsUnderRestrictedUser", "", "client", "Lcom/android/ddmlib/Client;", "getClientABIs", "", "Lcom/android/sdklib/devices/Abi;", "maybeShowBrokenNdkMessage", "project", "Lcom/intellij/openapi/project/Project;", "maybeShowMustExpandNativeLibsMessage", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "verify", "clientShellHelper", "Lcom/android/tools/ndk/run/ClientShellHelper;", "android-ndk"})
public final class UtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Abi> getClientABIs(@NotNull Client client) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Logger logger = Logger.getInstance((String)"getClientABIs");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(\"getClientABIs\")");
        Logger LOG = logger;
        String string = client.getClientData().getAbi();
        int clientAddrByteSize = (string != null ? StringsKt.startsWith$default((String)string, (String)"64-bit", (boolean)false, (int)2, null) : false) ? 8 : 4;
        List list = client.getDevice().getAbis();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"client.device.abis");
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var6_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Abi it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Abi abi = Abi.getEnum((String)it);
            if (abi == null) {
                LOG.warn("Failed to get abi by name: " + it);
            }
            if (abi == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Abi it = (Abi)element$iv$iv;
            boolean bl = false;
            if (!(it.getAddressSizeInBytes() == clientAddrByteSize)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List abis = (List)destination$iv$iv;
        LOG.info("ABIs supported by app: " + abis);
        return abis;
    }

    @WorkerThread
    public static final void verify(@NotNull Project project, @NotNull ClientShellHelper clientShellHelper, @NotNull Client client, @NotNull AndroidFacet facet) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)clientShellHelper, (String)"clientShellHelper");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        if (clientShellHelper.isRestrictedUser()) {
            UtilsKt.checkRunAsUnderRestrictedUser(client);
        }
        UtilsKt.maybeShowBrokenNdkMessage(project, client);
        UtilsKt.maybeShowMustExpandNativeLibsMessage(project, facet);
    }

    private static final void maybeShowBrokenNdkMessage(Project project, Client client) {
        boolean hasBrokenNdkABI;
        block8: {
            boolean bl;
            Iterable $this$any$iv = UtilsKt.getClientABIs(client);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Abi it = (Abi)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.toString(), (Object)"x86")) continue;
                    bl = true;
                    break block8;
                }
                bl = hasBrokenNdkABI = false;
            }
        }
        if (!hasBrokenNdkABI) {
            return;
        }
        NativeWorkspaceService nativeWorkspaceService = NativeWorkspaceService.Companion.getInstance(project);
        Optional anyFileSetting2 = nativeWorkspaceService.getCompilerSettings((Function1)maybeShowBrokenNdkMessage.anyFileSetting.1.INSTANCE).findFirst();
        if (!anyFileSetting2.isPresent()) {
            return;
        }
        File cc = ((NativeCompilerSetting)anyFileSetting2.get()).getCompilerExe();
        String string = cc.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"cc.name");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"clang", (boolean)false, (int)2, null)) {
            return;
        }
        Pair<File, Revision> pair = CxxSyncUtilsKt.findNdkFolderFromFileInNdk(cc);
        if (pair == null) {
            return;
        }
        Revision second = (Revision)pair.component2();
        if (second.getMajor() > 16) {
            return;
        }
        LaunchNativeDebuggerNotifier.INSTANCE.notifyWarning(project, "While debugging with an x86 device, the version of Clang included in NDK r16 and lower has a known issue that prevents function argument values from displaying correctly. To avoid this issue, either use an x86_64 device, or update the NDK to r17 or higher.");
    }

    private static final void maybeShowMustExpandNativeLibsMessage(Project project, AndroidFacet facet) {
        String extractNativeLibs2 = (String)ReadAction.compute((ThrowableComputable)new ThrowableComputable(facet){
            final /* synthetic */ AndroidFacet $facet;
            {
                this.$facet = $facet;
            }

            public final String compute() {
                Manifest manifest = Manifest.getMainManifest((AndroidFacet)this.$facet);
                if (manifest == null) {
                    return null;
                }
                Manifest manifest2 = manifest;
                Application app = manifest2.getApplication();
                if (app == null || app.getXmlTag() == null) {
                    return null;
                }
                XmlTag xmlTag = app.getXmlTag();
                Intrinsics.checkNotNull((Object)xmlTag);
                return xmlTag.getAttributeValue("extractNativeLibs", "http://schemas.android.com/apk/res/android");
            }
        });
        if (StringsKt.equals((String)"false", (String)extractNativeLibs2, (boolean)true)) {
            LaunchNativeDebuggerNotifier.INSTANCE.notifyWarning(project, "Android Studio cannot debug native libraries that are not extracted from the APK. When debugging your app, set extractNativeLibs=\"true\" in your app's manifest.");
        }
    }

    @WorkerThread
    private static final void checkRunAsUnderRestrictedUser(Client client) throws ExecutionException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            client.getDevice().executeShellCommand("run-as", (IShellOutputReceiver)receiver);
        }
        catch (Exception e) {
            throw new ExecutionException("Error executing adb command: run-as");
        }
        String string = receiver.getOutput();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"receiver.output");
        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"--user", (boolean)false, (int)2, null)) {
            boolean bl = false;
            String string2 = "Native debugging under restricted user is not supported yet.";
            throw new IllegalStateException(string2.toString());
        }
    }
}

