/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.Client;
import com.android.sdklib.devices.Abi;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.InjectorSessionStarterImpl;
import com.android.tools.ndk.run.lldb.RunAsSessionStarterImpl;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.SessionStarterType;
import com.android.tools.ndk.run.lldb.ShellSessionStarterImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001aB\u0010\u0011\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a`\u0010\u0012\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001aB\u0010\u001c\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u00a8\u0006 "}, d2={"newInjectorSessionStarter", "Lcom/android/tools/ndk/run/lldb/SessionStarter;", "jdwpConnector", "Lcom/android/tools/ndk/run/jdwp/JdwpConnector;", "client", "Lcom/android/ddmlib/Client;", "clientShellHelper", "Lcom/android/tools/ndk/run/ClientShellHelper;", "restrictedPtraceScope", "", "serverPath", "Ljava/io/File;", "startScriptPath", "nativeAndroidDebuggerState", "Lcom/android/tools/ndk/run/editor/NativeAndroidDebuggerState;", "project", "Lcom/intellij/openapi/project/Project;", "newRunAsSessionStarter", "newSessionStarter", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "clientABIs", "", "Lcom/android/sdklib/devices/Abi;", "lldbServer", "startServerScript", "type", "Lcom/android/tools/ndk/run/lldb/SessionStarterType;", "newShellSessionStarter", "resumeVMOnSessionStarted", "", "sessionStarter", "android-ndk"})
public final class SessionStarterUtilKt {
    @NotNull
    public static final SessionStarter newSessionStarter(@Nullable JdwpConnector jdwpConnector, @NotNull AndroidFacet facet, @NotNull Client client, @NotNull ClientShellHelper clientShellHelper, @NotNull List<? extends Abi> clientABIs, @NotNull File lldbServer, @NotNull File startServerScript, @NotNull SessionStarterType type, @NotNull NativeAndroidDebuggerState nativeAndroidDebuggerState, @NotNull Project project) throws ExecutionException {
        SessionStarter sessionStarter;
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clientShellHelper, (String)"clientShellHelper");
        Intrinsics.checkNotNullParameter(clientABIs, (String)"clientABIs");
        Intrinsics.checkNotNullParameter((Object)lldbServer, (String)"lldbServer");
        Intrinsics.checkNotNullParameter((Object)startServerScript, (String)"startServerScript");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)nativeAndroidDebuggerState), (String)"nativeAndroidDebuggerState");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AndroidNativeAppDebugProcess.verifyNativeModel(facet, clientABIs);
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                if (jdwpConnector == null) {
                    boolean bl = false;
                    String string = "JDWP Connector must not be null when injector session starter is required";
                    throw new IllegalStateException(string.toString());
                }
                sessionStarter = SessionStarterUtilKt.newInjectorSessionStarter(jdwpConnector, client, clientShellHelper, type == SessionStarterType.INJECTOR_YAMA, lldbServer, startServerScript, nativeAndroidDebuggerState, project);
                break;
            }
            case 3: {
                sessionStarter = SessionStarterUtilKt.newShellSessionStarter(jdwpConnector, client, clientShellHelper, lldbServer, startServerScript, nativeAndroidDebuggerState, project);
                break;
            }
            case 4: {
                sessionStarter = SessionStarterUtilKt.newRunAsSessionStarter(jdwpConnector, client, clientShellHelper, lldbServer, startServerScript, nativeAndroidDebuggerState, project);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sessionStarter;
    }

    private static final SessionStarter newShellSessionStarter(JdwpConnector jdwpConnector, Client client, ClientShellHelper clientShellHelper, File serverPath, File startScriptPath, NativeAndroidDebuggerState nativeAndroidDebuggerState, Project project) throws ExecutionException {
        SessionStarter sessionStarter = new ShellSessionStarterImpl(client, clientShellHelper, serverPath, startScriptPath, nativeAndroidDebuggerState, project);
        SessionStarterUtilKt.resumeVMOnSessionStarted(sessionStarter, jdwpConnector);
        return sessionStarter;
    }

    private static final SessionStarter newRunAsSessionStarter(JdwpConnector jdwpConnector, Client client, ClientShellHelper clientShellHelper, File serverPath, File startScriptPath, NativeAndroidDebuggerState nativeAndroidDebuggerState, Project project) throws ExecutionException {
        SessionStarter sessionStarter = new RunAsSessionStarterImpl(client, clientShellHelper, serverPath, startScriptPath, nativeAndroidDebuggerState, project);
        SessionStarterUtilKt.resumeVMOnSessionStarted(sessionStarter, jdwpConnector);
        return sessionStarter;
    }

    private static final SessionStarter newInjectorSessionStarter(JdwpConnector jdwpConnector, Client client, ClientShellHelper clientShellHelper, boolean restrictedPtraceScope, File serverPath, File startScriptPath, NativeAndroidDebuggerState nativeAndroidDebuggerState, Project project) throws ExecutionException {
        return new InjectorSessionStarterImpl(jdwpConnector, client, clientShellHelper, restrictedPtraceScope, serverPath, startScriptPath, nativeAndroidDebuggerState, project);
    }

    private static final void resumeVMOnSessionStarted(SessionStarter sessionStarter, JdwpConnector jdwpConnector) {
        if (jdwpConnector == null) {
            return;
        }
        sessionStarter.addEventListener(new SessionStarter.EventListener(jdwpConnector){
            final /* synthetic */ JdwpConnector $jdwpConnector;
            {
                this.$jdwpConnector = $jdwpConnector;
            }

            public final void sessionStarted() {
                this.$jdwpConnector.Connect();
            }
        });
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SessionStarterType.values().length];
            nArray[SessionStarterType.INJECTOR.ordinal()] = 1;
            nArray[SessionStarterType.INJECTOR_YAMA.ordinal()] = 2;
            nArray[SessionStarterType.ROOT_SHELL.ordinal()] = 3;
            nArray[SessionStarterType.RUN_AS_SHELL.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

