/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.SyncService;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.lldb.PtraceScope;
import com.android.tools.ndk.run.lldb.SessionStarterType;
import com.google.common.base.Charsets;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"createPtraceScopeTempFile", "Ljava/io/File;", "getDeviceDisplayName", "", "device", "Lcom/android/ddmlib/IDevice;", "getPtraceScope", "Lcom/android/tools/ndk/run/lldb/PtraceScope;", "getSessionStarterType", "Lcom/android/tools/ndk/run/lldb/SessionStarterType;", "clientShellHelper", "Lcom/android/tools/ndk/run/ClientShellHelper;", "isRootedDevice", "", "isRunAsOK", "android-ndk"})
public final class SessionStarterTypeKt {
    @NotNull
    public static final SessionStarterType getSessionStarterType(@NotNull IDevice device, @NotNull ClientShellHelper clientShellHelper) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)clientShellHelper, (String)"clientShellHelper");
        Logger logger = Logger.getInstance(SessionStarterType.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(SessionStarterType::class.java)");
        Logger LOG = logger;
        if (Boolean.getBoolean("lldb.session-starter.runas")) {
            LOG.info("Using run-as to start debug session due to system property");
            return SessionStarterType.RUN_AS_SHELL;
        }
        if (Boolean.getBoolean("lldb.session-starter.jdwp")) {
            LOG.info("Using injector to start debug session due to system property");
            return SessionStarterType.INJECTOR;
        }
        boolean isInjectorSupported = device.getVersion().getApiLevel() <= 28;
        PtraceScope ptraceScope = SessionStarterTypeKt.getPtraceScope(device);
        if (ptraceScope != PtraceScope.ALLOWED) {
            LOG.info("YAMA is on - ptrace_scope set to " + ptraceScope);
            if (ptraceScope == PtraceScope.RESTRICTED && isInjectorSupported) {
                LOG.info("Using injector-yama to start debug session");
                return SessionStarterType.INJECTOR_YAMA;
            }
            LOG.error(StringsKt.trimIndent((String)("\n            Unsupported device: " + SessionStarterTypeKt.getDeviceDisplayName(device) + "\n            Native debugging is blocked on this device (ptrace_scope=" + ptraceScope + ").\n            See native debugger requirements at: https://developer.android.com/studio/debug#debug-types\n            ")));
            throw new ExecutionException("Unsupported device. This device cannot be debugged using the native debugger. See log file for details.");
        }
        if (SessionStarterTypeKt.isRootedDevice(device)) {
            LOG.info("Rooted device, using shell to start debug session");
            return SessionStarterType.ROOT_SHELL;
        }
        if (SessionStarterTypeKt.isRunAsOK(device, clientShellHelper)) {
            LOG.info("Using run-as to start debug session");
            return SessionStarterType.RUN_AS_SHELL;
        }
        if (isInjectorSupported) {
            LOG.info("Non-rooted device, run-as not working, resorting to injector to start debug session");
            return SessionStarterType.INJECTOR;
        }
        LOG.error(StringsKt.trimIndent((String)("\n        Unsupported device (Non-rooted device, run-as not working, injector not supported): " + SessionStarterTypeKt.getDeviceDisplayName(device) + "\n        Native debugging is not supported on this device.\n        See native debugger requirements at: https://developer.android.com/studio/debug#debug-types\n        ")));
        throw new ExecutionException("Unsupported device. This device cannot be debugged using the native debugger. See log file for details.");
    }

    private static final String getDeviceDisplayName(IDevice device) {
        String deviceModel = device.getProperty("ro.product.model");
        String deviceAPILevel = device.getProperty("ro.build.version.sdk");
        String deviceManufacturer = device.getProperty("ro.product.manufacturer");
        String string = "manufacturer=%s, model=%s, API=%s";
        Object[] objectArray = new Object[]{deviceManufacturer, deviceModel, deviceAPILevel};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final boolean isRootedDevice(IDevice device) throws ExecutionException {
        boolean bl;
        try {
            bl = device.isRoot();
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final PtraceScope getPtraceScope(IDevice device) {
        PtraceScope ptraceScope;
        File localPtraceScopeFile;
        SyncService syncService;
        Logger LOG;
        block25: {
            block26: {
                PtraceScope ptraceScope2;
                block24: {
                    Logger logger = Logger.getInstance(SessionStarterType.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(SessionStarterType::class.java)");
                    LOG = logger;
                    syncService = null;
                    localPtraceScopeFile = null;
                    try {
                        syncService = device.getSyncService();
                        if (syncService == null) {
                            throw new ExecutionException("Failed to get SyncService");
                        }
                        SyncService.FileStat ptraceScopeStat = syncService.statFile("/proc/sys/kernel/yama/ptrace_scope");
                        if (ptraceScopeStat == null || ptraceScopeStat.getMode() == 0) {
                            ptraceScope2 = PtraceScope.ALLOWED;
                            break block24;
                        }
                        localPtraceScopeFile = SessionStarterTypeKt.createPtraceScopeTempFile();
                        device.pullFile("/proc/sys/kernel/yama/ptrace_scope", localPtraceScopeFile.getPath());
                        String string = com.google.common.io.Files.asCharSource((File)localPtraceScopeFile, (Charset)Charsets.UTF_8).read();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asCharSource(localPtrace\u2026e, Charsets.UTF_8).read()");
                        String $this$trim$iv = string;
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        int scope = Integer.parseInt(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
                        switch (scope) {
                            case 0: {
                                PtraceScope ptraceScope3 = PtraceScope.ALLOWED;
                                break;
                            }
                            case 1: {
                                PtraceScope ptraceScope3 = PtraceScope.RESTRICTED;
                                break;
                            }
                            case 2: {
                                PtraceScope ptraceScope3 = PtraceScope.ADMIN_ONLY;
                                break;
                            }
                            default: {
                                PtraceScope ptraceScope3 = ptraceScope = PtraceScope.DISABLED;
                            }
                        }
                        if (localPtraceScopeFile == null) break block25;
                        break block26;
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                        return PtraceScope.ALLOWED;
                    }
                }
                syncService.close();
                return ptraceScope2;
            }
            try {
                Files.delete(localPtraceScopeFile.toPath());
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }
        syncService.close();
        return ptraceScope;
        finally {
            if (localPtraceScopeFile != null) {
                try {
                    Files.delete(localPtraceScopeFile.toPath());
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            SyncService syncService2 = syncService;
            if (syncService2 != null) {
                syncService2.close();
            }
        }
    }

    private static final File createPtraceScopeTempFile() throws IOException {
        File file = File.createTempFile("ptrace_scope", String.valueOf(System.currentTimeMillis()));
        file.deleteOnExit();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return file;
    }

    private static final boolean isRunAsOK(IDevice device, ClientShellHelper clientShellHelper) throws ExecutionException {
        boolean bl;
        try {
            String output;
            String string = device.getProperty("ro.product.model");
            if (string == null) {
                return false;
            }
            String deviceModel = string;
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            String string2 = "getprop %s";
            Object[] objectArray = new Object[]{"ro.product.model"};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            String string4 = clientShellHelper.getRunAsCommand(string3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"clientShellHelper.getRun\u2026evice.PROP_DEVICE_MODEL))");
            String runAsCommand = string4;
            device.executeShellCommand(runAsCommand, (IShellOutputReceiver)receiver);
            String string5 = receiver.getOutput();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"receiver.output");
            String $this$trim$iv = string5;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl2 = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!StringsKt.contains$default((CharSequence)(output = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (CharSequence)deviceModel, (boolean)false, (int)2, null)) {
                Logger.getInstance(SessionStarterType.class).warn("run-as for the selected device appears to be broken, output was : " + output);
                return false;
            }
            bl = true;
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
        return bl;
    }
}

