/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.AppRunConfiguration;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.deployable.SwappableProcessHandler;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.LaunchNativeDebuggerNotifier;
import com.android.tools.ndk.run.editor.AutoAndroidDebuggerState;
import com.android.tools.ndk.run.editor.HybridAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebugger;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.android.tools.ndk.run.lldb.LLDBUsageTracker;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.SessionStarterType;
import com.android.tools.ndk.run.lldb.SessionStarterTypeKt;
import com.android.tools.ndk.run.lldb.SessionStarterUtilKt;
import com.android.tools.ndk.run.lldb.UtilsKt;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.ExecutionSearchScopes;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001al\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002\u001ad\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bH\u0002\u001a\u001a\u0010 \u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\nH\u0002\u001aF\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\n2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001aN\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0+*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010-2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010/\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u00060"}, d2={"type", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$DebuggerType;", "Lcom/android/tools/ndk/run/editor/NativeAndroidDebugger;", "getType", "(Lcom/android/tools/ndk/run/editor/NativeAndroidDebugger;)Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$DebuggerType;", "createDebugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "client", "Lcom/android/ddmlib/Client;", "clientShellHelper", "Lcom/android/tools/ndk/run/ClientShellHelper;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "needsJdwpConnector", "", "project", "Lcom/intellij/openapi/project/Project;", "debugger", "debuggerState", "Lcom/android/tools/ndk/run/editor/NativeAndroidDebuggerState;", "sessionStarterType", "Lcom/android/tools/ndk/run/lldb/SessionStarterType;", "sessionId", "", "finishAndroidProcess", "Lkotlin/Function1;", "Lcom/android/ddmlib/IDevice;", "", "getDebugProcessStarter", "Lcom/intellij/xdebugger/XDebugProcessStarter;", "getPackageNameOverride", "module", "Lcom/intellij/openapi/module/Module;", "getRunParameters", "Lcom/jetbrains/cidr/execution/RunParameters;", "clientABIs", "", "Lcom/android/sdklib/devices/Abi;", "sessionStarter", "Lcom/android/tools/ndk/run/lldb/SessionStarter;", "targetAbi", "Lorg/jetbrains/concurrency/Promise;", "consoleViewToReuse", "Lcom/intellij/execution/ui/ConsoleView;", "destroyRunningProcess", "state", "android-ndk"})
public final class DebugProcessStarterKt {
    @NotNull
    public static final Promise<XDebugProcessStarter> getDebugProcessStarter(@NotNull NativeAndroidDebugger $this$getDebugProcessStarter, @NotNull Project project, @NotNull Client client, @Nullable ConsoleView consoleViewToReuse, @NotNull Function1<? super IDevice, Unit> destroyRunningProcess, @NotNull NativeAndroidDebuggerState state, @NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getDebugProcessStarter), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter(destroyRunningProcess, (String)"destroyRunningProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        AsyncPromise promise = new AsyncPromise();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String sessionId = string;
        boolean isNewProcess = client.getClientData().getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING;
        AsyncPromise $this$catchError$iv = promise;
        boolean $i$f$catchError = false;
        try {
            boolean bl = false;
            Module module = facet.getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
            ClientShellHelper clientShellHelper = new ClientShellHelper(client, DebugProcessStarterKt.getPackageNameOverride(module, client));
            UtilsKt.verify(project, clientShellHelper, client, facet);
            IDevice iDevice = client.getDevice();
            Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"client.device");
            SessionStarterType sessionStarterType = SessionStarterTypeKt.getSessionStarterType(iDevice, clientShellHelper);
            boolean needsJdwpConnector = isNewProcess || $this$getDebugProcessStarter.needsJdwpConnectorOnAttach(sessionStarterType);
            LLDBUsageTracker.sessionStarted(client.getDevice(), DebugProcessStarterKt.getType($this$getDebugProcessStarter), sessionId, state instanceof AutoAndroidDebuggerState, sessionStarterType);
            promise.setResult((Object)DebugProcessStarterKt.getDebugProcessStarter(project, $this$getDebugProcessStarter, state, client, facet, needsJdwpConnector, clientShellHelper, sessionStarterType, sessionId, destroyRunningProcess));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable e$iv) {
            $this$catchError$iv.setError(e$iv);
            Object var16_17 = null;
        }
        return (Promise)promise.onError(new Consumer(sessionId){
            final /* synthetic */ String $sessionId;
            {
                this.$sessionId = $sessionId;
            }

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LLDBUsageTracker.sessionFailed(it, this.$sessionId, 0L, 1L);
            }
        });
    }

    private static final AndroidStudioEvent.DebuggerType getType(NativeAndroidDebugger $this$type) {
        return $this$type instanceof HybridAndroidDebugger ? AndroidStudioEvent.DebuggerType.HYBRID : AndroidStudioEvent.DebuggerType.NATIVE;
    }

    private static final String getPackageNameOverride(Module module, Client client) {
        ApplicationIdProvider applicationIdProvider = ProjectSystemUtil.getModuleSystem((Module)module).getApplicationIdProvider();
        List appIds = new ArrayList();
        try {
            String string = applicationIdProvider.getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationIdProvider.packageName");
            String packageName = string;
            appIds.add(packageName);
        }
        catch (ApkProvisionException e) {
            throw new ExecutionException((Throwable)e);
        }
        try {
            String testPackageName = applicationIdProvider.getTestPackageName();
            if (testPackageName != null) {
                appIds.add(testPackageName);
            }
        }
        catch (ApkProvisionException e) {
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            LaunchNativeDebuggerNotifier.INSTANCE.notifyWarning(project, "Unable to obtain test package name, will not connect debugger if tests don't instantiate main application");
        }
        return appIds.contains(client.getClientData().getPackageName()) ? null : (String)appIds.get(0);
    }

    private static final XDebugProcessStarter getDebugProcessStarter(Project project, NativeAndroidDebugger debugger, NativeAndroidDebuggerState debuggerState, Client client, AndroidFacet facet, boolean needsJdwpConnector, ClientShellHelper clientShellHelper, SessionStarterType sessionStarterType, String sessionId, Function1<? super IDevice, Unit> finishAndroidProcess) {
        return new XDebugProcessStarter(client, debugger, clientShellHelper, facet, needsJdwpConnector, project, debuggerState, sessionStarterType, sessionId, finishAndroidProcess){
            final /* synthetic */ Client $client;
            final /* synthetic */ NativeAndroidDebugger $debugger;
            final /* synthetic */ ClientShellHelper $clientShellHelper;
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ boolean $needsJdwpConnector;
            final /* synthetic */ Project $project;
            final /* synthetic */ NativeAndroidDebuggerState $debuggerState;
            final /* synthetic */ SessionStarterType $sessionStarterType;
            final /* synthetic */ String $sessionId;
            final /* synthetic */ Function1<IDevice, Unit> $finishAndroidProcess;
            {
                this.$client = $client;
                this.$debugger = $debugger;
                this.$clientShellHelper = $clientShellHelper;
                this.$facet = $facet;
                this.$needsJdwpConnector = $needsJdwpConnector;
                this.$project = $project;
                this.$debuggerState = $debuggerState;
                this.$sessionStarterType = $sessionStarterType;
                this.$sessionId = $sessionId;
                this.$finishAndroidProcess = $finishAndroidProcess;
            }

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                try {
                    IDevice device = this.$client.getDevice();
                    String deviceModel = device.getProperty("ro.product.model");
                    String deviceAPILevel = device.getProperty("ro.build.version.sdk");
                    String deviceCodename = device.getProperty("ro.build.version.codename");
                    String deviceManufacturer = device.getProperty("ro.product.manufacturer");
                    Logger.getInstance(((Object)((Object)this.$debugger)).getClass()).info("Launching native debug session on device: manufacturer=" + deviceManufacturer + ", model=" + deviceModel + ", API=" + deviceAPILevel + ", codename=" + deviceCodename + ", ABIs=" + device.getAbis());
                    CidrDebugProcess debugProcess = DebugProcessStarterKt.access$createDebugProcess(session, this.$client, this.$clientShellHelper, this.$facet, this.$needsJdwpConnector, this.$project, this.$debugger, this.$debuggerState, this.$sessionStarterType, this.$sessionId, this.$finishAndroidProcess);
                    ProcessHandler processHandler = debugProcess.getProcessHandler();
                    Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"debugProcess.processHandler");
                    ProcessHandler nativeSessionProcessHandler = processHandler;
                    nativeSessionProcessHandler.putCopyableUserData(SwappableProcessHandler.EXTENSION_KEY, (Object)new SwappableProcessHandler(this.$clientShellHelper, this.$client){
                        final /* synthetic */ ClientShellHelper $clientShellHelper;
                        final /* synthetic */ Client $client;
                        {
                            this.$clientShellHelper = $clientShellHelper;
                            this.$client = $client;
                        }

                        public Executor getExecutor() {
                            return DefaultDebugExecutor.getDebugExecutorInstance();
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public boolean isRunningWith(@NotNull RunConfiguration runConfiguration, @NotNull ExecutionTarget executionTarget) {
                            boolean sameRunningApp;
                            Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
                            Intrinsics.checkNotNullParameter((Object)executionTarget, (String)"executionTarget");
                            boolean bl = sameRunningApp = runConfiguration instanceof AppRunConfiguration && Intrinsics.areEqual((Object)this.$clientShellHelper.getPackageName(), (Object)((AppRunConfiguration)runConfiguration).getAppId());
                            if (!sameRunningApp) {
                                return false;
                            }
                            if (executionTarget instanceof AndroidExecutionTarget) {
                                boolean bl2;
                                block5: {
                                    void $this$any$iv;
                                    Collection collection = ((AndroidExecutionTarget)executionTarget).getRunningDevices();
                                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"executionTarget.runningDevices");
                                    Iterable iterable = collection;
                                    Client client = this.$client;
                                    boolean $i$f$any = false;
                                    if (((Collection)$this$any$iv).isEmpty()) {
                                        bl2 = false;
                                    } else {
                                        for (T element$iv : $this$any$iv) {
                                            IDevice d = (IDevice)element$iv;
                                            boolean bl3 = false;
                                            if (!Intrinsics.areEqual((Object)d, (Object)client.getDevice())) continue;
                                            bl2 = true;
                                            break block5;
                                        }
                                        bl2 = false;
                                    }
                                }
                                return bl2;
                            }
                            return false;
                        }
                    });
                    return (XDebugProcess)debugProcess;
                }
                catch (Throwable e) {
                    LLDBUsageTracker.sessionFailed(e, this.$sessionId, 0L, 1L);
                    throw e;
                }
            }
        };
    }

    private static final CidrDebugProcess createDebugProcess(XDebugSession session, Client client, ClientShellHelper clientShellHelper, AndroidFacet facet, boolean needsJdwpConnector, Project project, NativeAndroidDebugger debugger, NativeAndroidDebuggerState debuggerState, SessionStarterType sessionStarterType, String sessionId, Function1<? super IDevice, Unit> finishAndroidProcess) throws ExecutionException {
        boolean launchMode;
        Object sessionStarter = null;
        List<Abi> clientABIs = UtilsKt.getClientABIs(client);
        JdwpConnector jdwpConnector = null;
        Logger logger = Logger.getInstance(((Object)((Object)debugger)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(debugger::class.java)");
        Logger LOG = logger;
        boolean bl = launchMode = client.getClientData().getDebuggerConnectionStatus() == ClientData.DebuggerStatus.WAITING;
        if (needsJdwpConnector) {
            jdwpConnector = new JdwpConnector(project, facet, client, clientShellHelper, launchMode, session);
        } else {
            LOG.info(((Object)StringsKt.trim((CharSequence)("\n       Not creating JDWP connector. Debugger is " + ((Object)((Object)debugger)).getClass().getName() + ".\n       Session starter type is : " + sessionStarterType))).toString());
        }
        ModulePathManager.FileWithAbi lldbServer = ModulePathManager.findLLDBServer(facet, debuggerState, clientABIs);
        File file = ModulePathManager.getLldbAndroidFile("start_lldb_server.sh");
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getLldbAndroidFile(Const\u2026LLDB_SERVER_START_SCRIPT)");
        File startServerScript = file;
        if (lldbServer == null) {
            LOG.error("LLDB server not found");
            String string = "LLDB server for architectures [%s] not found";
            Object[] objectArray = new Object[]{clientABIs};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new ExecutionException(string2);
        }
        Object object = new Object[]{lldbServer.getFile().getAbsolutePath()};
        LOG.info(String.format("Found LLDB server: \"%s\"", object));
        try {
            File file2 = lldbServer.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"lldbServer.file");
            object = SessionStarterUtilKt.newSessionStarter(jdwpConnector, facet, client, clientShellHelper, clientABIs, file2, startServerScript, sessionStarterType, debuggerState, project);
        }
        catch (Exception e) {
            throw new ExecutionException((Throwable)e);
        }
        sessionStarter = object;
        Abi abi = lldbServer.getAbi();
        Intrinsics.checkNotNullExpressionValue((Object)abi, (String)"lldbServer.abi");
        RunParameters runParameters = DebugProcessStarterKt.getRunParameters(client, clientABIs, (SessionStarter)sessionStarter, abi, debugger, debuggerState, facet);
        TextConsoleBuilderFactory textConsoleBuilderFactory = TextConsoleBuilderFactory.getInstance();
        GlobalSearchScope globalSearchScope = ExecutionSearchScopes.executionScope((Collection)CollectionsKt.listOf((Object)facet.getModule()));
        Intrinsics.checkNotNull((Object)globalSearchScope);
        TextConsoleBuilder textConsoleBuilder = textConsoleBuilderFactory.createBuilder(project, globalSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"getInstance()\n    .creat\u2026Of(facet.module))!!\n    )");
        TextConsoleBuilder consoleBuilder = textConsoleBuilder;
        AndroidNativeAppDebugProcess androidNativeAppDebugProcess = debugger.newAndroidNativeAppDebugProcess(sessionId, runParameters, session, consoleBuilder, (SessionStarter)sessionStarter, client, jdwpConnector, !launchMode, lldbServer.getAbi());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)androidNativeAppDebugProcess), (String)"debugger.newAndroidNativ\u2026e,\n    lldbServer.abi\n  )");
        AndroidNativeAppDebugProcess nativeDebugProcess = androidNativeAppDebugProcess;
        nativeDebugProcess.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(launchMode, finishAndroidProcess, client){
            final /* synthetic */ boolean $launchMode;
            final /* synthetic */ Function1<IDevice, Unit> $finishAndroidProcess;
            final /* synthetic */ Client $client;
            {
                this.$launchMode = $launchMode;
                this.$finishAndroidProcess = $finishAndroidProcess;
                this.$client = $client;
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$launchMode) {
                    Function1<IDevice, Unit> function1 = this.$finishAndroidProcess;
                    Client client = this.$client;
                    boolean $i$f$executeOnPooledThread = false;
                    Intrinsics.checkNotNullExpressionValue((Object)ApplicationManager.getApplication().executeOnPooledThread(new Runnable(function1, client){
                        final /* synthetic */ Function1 $finishAndroidProcess$inlined;
                        final /* synthetic */ Client $client$inlined;
                        {
                            this.$finishAndroidProcess$inlined = function1;
                            this.$client$inlined = client;
                        }

                        public final void run() {
                            boolean bl = false;
                            IDevice iDevice = this.$client$inlined.getDevice();
                            Intrinsics.checkNotNullExpressionValue((Object)iDevice, (String)"client.device");
                            this.$finishAndroidProcess$inlined.invoke((Object)iDevice);
                        }
                    }), (String)"ApplicationManager.getAp\u2026PooledThread { action() }");
                }
            }
        });
        ProcessTerminatedListener.attach((ProcessHandler)nativeDebugProcess.getProcessHandler(), (Project)project);
        nativeDebugProcess.start();
        return nativeDebugProcess;
    }

    private static final RunParameters getRunParameters(Client client, List<? extends Abi> clientABIs, SessionStarter sessionStarter, Abi targetAbi, NativeAndroidDebugger debugger, NativeAndroidDebuggerState debuggerState, AndroidFacet facet) {
        IDevice device = client.getDevice();
        List<String> list = debugger.getPostAttachCommands();
        Intrinsics.checkNotNullExpressionValue(list, (String)"debugger.postAttachCommands");
        Collection collection = list;
        List<String> list2 = debuggerState.getUserPostAttachCommands();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"debuggerState.userPostAttachCommands");
        List postAttachCommands = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        List<String> list3 = debugger.getStartupCommands(facet, targetAbi);
        Intrinsics.checkNotNullExpressionValue(list3, (String)"debugger.getStartupCommands(facet, targetAbi)");
        Collection collection2 = list3;
        List<String> list4 = debuggerState.getUserStartupCommands();
        Intrinsics.checkNotNullExpressionValue(list4, (String)"debuggerState.userStartupCommands");
        List startupCommands = CollectionsKt.plus((Collection)collection2, (Iterable)list4);
        AndroidLLDBDriverConfiguration configuration = new AndroidLLDBDriverConfiguration(facet, debuggerState, device, clientABIs, sessionStarter, startupCommands, postAttachCommands);
        return new RunParameters(configuration, device){
            final /* synthetic */ AndroidLLDBDriverConfiguration $configuration;
            final /* synthetic */ IDevice $device;
            {
                this.$configuration = $configuration;
                this.$device = $device;
            }

            @NotNull
            public Installer getInstaller() {
                String[] stringArray = new String[]{""};
                return (Installer)new TrivialInstaller(new GeneralCommandLine(stringArray));
            }

            @NotNull
            public DebuggerDriverConfiguration getDebuggerDriverConfiguration() {
                return (DebuggerDriverConfiguration)this.$configuration;
            }

            @NotNull
            public String getArchitectureId() {
                String string = NdkHelper.getArchitectureId(NdkHelper.getAbi(this.$device));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getArchitectureId(NdkHelper.getAbi(device))");
                return string;
            }
        };
    }

    public static final /* synthetic */ CidrDebugProcess access$createDebugProcess(XDebugSession session, Client client, ClientShellHelper clientShellHelper, AndroidFacet facet, boolean needsJdwpConnector, Project project, NativeAndroidDebugger debugger, NativeAndroidDebuggerState debuggerState, SessionStarterType sessionStarterType, String sessionId, Function1 finishAndroidProcess) {
        return DebugProcessStarterKt.createDebugProcess(session, client, clientShellHelper, facet, needsJdwpConnector, project, debugger, debuggerState, sessionStarterType, sessionId, (Function1<? super IDevice, Unit>)finishAndroidProcess);
    }
}

