/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.android.tools.idea.gradle.model.IdeBuildType;
import com.android.tools.idea.gradle.model.IdeBuildTypeContainer;
import com.android.tools.idea.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.run.ValidationError;
import com.google.common.collect.Lists;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidDebuggerState
extends AndroidDebuggerState {
    private static final String SYMBOL_DIRS = "symbol_dirs";
    private static final String SYMBOL_PATH = "symbol_path";
    private static final String STARTUP_COMMANDS = "startup_commands";
    private static final String STARTUP_COMMANDS_ATTR = "startup_commands_attr";
    private static final String POST_ATTACH_COMMANDS = "post_attach_commands";
    private static final String POST_ATTACH_COMMANDS_ATTR = "post_attach_commands_attr";
    private static final String SDK_CHECK_FAIL_WARNING = "SDK check failed.";
    private List<String> mySymbolDirs = Lists.newLinkedList();
    private List<String> myUserStartupCommands = Lists.newLinkedList();
    private List<String> myUserPostAttachCommands = Lists.newLinkedList();
    public boolean USE_JAVA_AWARE_DEBUGGER;
    public boolean SHOW_STATIC_VARS = true;
    public String WORKING_DIR = "";
    public String TARGET_LOGGING_CHANNELS = "lldb process:gdb-remote packets";
    public boolean SHOW_OPTIMIZED_WARNING = true;

    @NotNull
    public List<ValidationError> validate(@NotNull AndroidFacet facet, @Nullable Executor executor) {
        ArrayList errors = Lists.newArrayList();
        if (executor == null || !(executor instanceof DefaultDebugExecutor)) {
            return errors;
        }
        GradleAndroidModel androidModel = GradleAndroidModel.get((AndroidFacet)facet);
        if (androidModel != null && GradleFacet.isAppliedTo((Module)facet.getModule())) {
            IdeVariant selectedVariant = androidModel.getSelectedVariant();
            IdeBuildTypeContainer buildTypeContainer = androidModel.findBuildType(selectedVariant.getBuildType());
            if (buildTypeContainer == null) {
                errors.add(ValidationError.fatal((String)("Build type " + selectedVariant.getBuildType() + " not found")));
                return errors;
            }
            IdeBuildType buildType = buildTypeContainer.getBuildType();
            if (!buildType.isDebuggable()) {
                errors.add(ValidationError.fatal((String)"Build type isn't debuggable"));
            }
        }
        return errors;
    }

    @NotNull
    public List<String> getSymbolDirs() {
        return this.mySymbolDirs;
    }

    public void setSymbolDirs(@NotNull List<String> symDirs) {
        this.mySymbolDirs.clear();
        this.mySymbolDirs.addAll(symDirs);
    }

    public void addSymbolDir(@NotNull String symDir) {
        if (this.mySymbolDirs.indexOf(symDir) == -1) {
            this.mySymbolDirs.add(symDir);
        }
    }

    public boolean useJavaAwareDebugger() {
        return this.USE_JAVA_AWARE_DEBUGGER;
    }

    public boolean showStaticVars() {
        return this.SHOW_STATIC_VARS;
    }

    public void setShowStaticVars(boolean showStaticVars) {
        this.SHOW_STATIC_VARS = showStaticVars;
    }

    @NotNull
    public String getWorkingDir() {
        return this.WORKING_DIR;
    }

    public void setWorkingDir(@NotNull String workingDir) {
        this.WORKING_DIR = workingDir;
    }

    @NotNull
    public String getTargetLoggingChannels() {
        return this.TARGET_LOGGING_CHANNELS;
    }

    public void setTargetLoggingChannels(@NotNull String targetLoggingChannels) {
        this.TARGET_LOGGING_CHANNELS = targetLoggingChannels;
    }

    public boolean showOptimizedWarning() {
        return this.SHOW_OPTIMIZED_WARNING;
    }

    public void setShowOptimizedWarning(boolean value) {
        this.SHOW_OPTIMIZED_WARNING = value;
    }

    @NotNull
    public List<String> getUserStartupCommands() {
        return this.myUserStartupCommands;
    }

    public void setUserStartupCommands(@NotNull Collection<String> userStartupCommands) {
        this.myUserStartupCommands.clear();
        this.myUserStartupCommands.addAll(userStartupCommands);
    }

    @NotNull
    public List<String> getUserPostAttachCommands() {
        return this.myUserPostAttachCommands;
    }

    public void setUserPostAttachCommands(@NotNull Collection<String> userPostAttachCommands) {
        this.myUserPostAttachCommands.clear();
        this.myUserPostAttachCommands.addAll(userPostAttachCommands);
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.mySymbolDirs = JDOMExternalizer.loadStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH);
        this.myUserStartupCommands = JDOMExternalizer.loadStringsList((Element)element, (String)STARTUP_COMMANDS, (String)STARTUP_COMMANDS_ATTR);
        this.myUserPostAttachCommands = JDOMExternalizer.loadStringsList((Element)element, (String)POST_ATTACH_COMMANDS, (String)POST_ATTACH_COMMANDS_ATTR);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizer.saveStringsList((Element)element, (String)SYMBOL_DIRS, (String)SYMBOL_PATH, (String[])this.mySymbolDirs.toArray(new String[0]));
        JDOMExternalizer.saveStringsList((Element)element, (String)STARTUP_COMMANDS, (String)STARTUP_COMMANDS_ATTR, (String[])this.myUserStartupCommands.toArray(new String[0]));
        JDOMExternalizer.saveStringsList((Element)element, (String)POST_ATTACH_COMMANDS, (String)POST_ATTACH_COMMANDS_ATTR, (String[])this.myUserPostAttachCommands.toArray(new String[0]));
    }
}

