/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerConfigurable;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.android.tools.idea.execution.common.debug.DebugSessionStarter;
import com.android.tools.idea.execution.common.debug.impl.AndroidDebuggerImplBase;
import com.android.tools.idea.execution.common.debug.utils.FacetFinder;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.ndk.NdkHelper;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.android.tools.ndk.run.jdwp.JdwpConnector;
import com.android.tools.ndk.run.lldb.DebugProcessStarterKt;
import com.android.tools.ndk.run.lldb.SessionStarter;
import com.android.tools.ndk.run.lldb.SessionStarterType;
import com.google.common.collect.Lists;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class NativeAndroidDebugger
extends AndroidDebuggerImplBase<NativeAndroidDebuggerState> {
    public static final String ID = "Native";
    private static final Logger LOG = Logger.getInstance(NativeAndroidDebugger.class);

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return "Native Only";
    }

    @NotNull
    public NativeAndroidDebuggerState createState() {
        return new NativeAndroidDebuggerState();
    }

    @NotNull
    public AndroidDebuggerConfigurable<NativeAndroidDebuggerState> createConfigurable(@NotNull RunConfiguration runConfiguration) {
        return new NativeAndroidDebuggerConfigurable<NativeAndroidDebuggerState>(runConfiguration.getProject());
    }

    public boolean supportsProject(@NotNull Project project) {
        return GradleProjectInfo.getInstance((Project)project).isBuildWithGradle() || NdkHelper.isNdkProject(project);
    }

    public Promise<XDebugSession> attachToClient(@NotNull Project project, @NotNull Client client, @Nullable NativeAndroidDebuggerState state) {
        XDebugSession existingSession = this.getExistingSession(project, client);
        if (existingSession != null) {
            return Promises.resolvedPromise((Object)existingSession);
        }
        DebuggerSession debuggerSession = NativeAndroidDebugger.findJdwpDebuggerSession((Project)project, (String)NativeAndroidDebugger.getClientDebugPort((Client)client));
        if (debuggerSession != null) {
            debuggerSession.getProcess().stop(false);
        }
        NativeAndroidDebuggerState stateFinal = state != null ? state : this.createState();
        return DebugSessionStarter.INSTANCE.attachDebuggerToClientAndShowTab(project, client, (AndroidDebugger)this, (AndroidDebuggerState)stateFinal);
    }

    public Promise<XDebugProcessStarter> getDebugProcessStarterForExistingProcess(Project project, Client client, NativeAndroidDebuggerState state) {
        String processName = client.getClientData().getClientDescription();
        if (processName == null) {
            return Promises.rejectedPromise((String)"Process name not found");
        }
        AndroidFacet facet = FacetFinder.INSTANCE.findFacetForProcess(project, processName);
        if (facet == null) {
            return Promises.rejectedPromise((String)this.getFacetNotFoundError(processName));
        }
        return DebugProcessStarterKt.getDebugProcessStarter(this, project, client, null, (Function1<? super IDevice, Unit>)((Function1)device -> Unit.INSTANCE), state, facet);
    }

    public Promise<XDebugProcessStarter> getDebugProcessStarterForNewProcess(@NotNull Project project, @NotNull Client client, @NotNull NativeAndroidDebuggerState state, @Nullable ConsoleView consoleViewToReuse, @NotNull Function1<? super IDevice, Unit> destroyRunningProcess) {
        CidrDebuggerSettings.getInstance().setValuesFilterEnabled(false);
        CidrDebuggerSettings.getInstance().setLLDBNatvisRenderersEnabled(((Boolean)StudioFlags.ENABLE_LLDB_NATVIS.get()).booleanValue());
        String processName = client.getClientData().getClientDescription();
        if (processName == null) {
            return Promises.rejectedPromise((String)"Process name not found");
        }
        AndroidFacet facet = FacetFinder.INSTANCE.findFacetForProcess(project, processName);
        if (facet == null) {
            return Promises.rejectedPromise((String)this.getFacetNotFoundError(processName));
        }
        return DebugProcessStarterKt.getDebugProcessStarter(this, project, client, consoleViewToReuse, destroyRunningProcess, state, facet);
    }

    private String getFacetNotFoundError(String packageName) {
        return "Cannot find AndroidFacet that matches process name " + packageName;
    }

    @Nullable
    protected XDebugSession getExistingSession(@NotNull Project project, @NotNull Client client) {
        XDebugSession nativeDebugSession = NativeAndroidDebugger.findNativeDebugSession(project, client);
        if (nativeDebugSession != null) {
            if (NativeAndroidDebugger.activateDebugSessionWindow((Project)project, (RunContentDescriptor)nativeDebugSession.getRunContentDescriptor())) {
                return nativeDebugSession;
            }
            NativeAndroidDebugger.detachXDebugSession(nativeDebugSession);
        }
        return null;
    }

    @NotNull
    public AndroidNativeAppDebugProcess newAndroidNativeAppDebugProcess(@NotNull String sessionId, @NotNull RunParameters parameters, @NotNull XDebugSession session, @NotNull TextConsoleBuilder consoleBuilder, @NotNull SessionStarter sessionStarter, @NotNull Client client, @Nullable JdwpConnector jdwpConnector, boolean detachOnStop, @NotNull Abi lldbServerAbi) throws ExecutionException {
        return new AndroidNativeAppDebugProcess(sessionId, parameters, session, consoleBuilder, sessionStarter, jdwpConnector, client, detachOnStop, lldbServerAbi);
    }

    @NotNull
    public List<String> getStartupCommands(@NotNull AndroidFacet facet, @NotNull Abi targetAbi) {
        ArrayList<String> cmds = new ArrayList<String>();
        Map<String, String> sourceMap = AndroidNativeAppDebugProcess.getSourceMap(facet);
        if (!sourceMap.isEmpty()) {
            ArrayList<CallSite> arguments = new ArrayList<CallSite>(sourceMap.size() * 2);
            for (Map.Entry<String, String> entry : sourceMap.entrySet()) {
                arguments.add((CallSite)((Object)("\"" + entry.getKey() + "\"")));
                arguments.add((CallSite)((Object)("\"" + entry.getValue() + "\"")));
            }
            String argumentsStr = StringUtil.join(arguments, (String)" ");
            LOG.info("Set target.source-map: " + argumentsStr);
            Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("target.source-map", argumentsStr));
        }
        Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("auto-confirm", "true"));
        Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("plugin.jit-loader.gdb.enable", "off"));
        if (SystemInfo.isWindows) {
            Collections.addAll(cmds, NativeAndroidDebugger.prepareSetSettingsCommand("use-source-cache", "false"));
        }
        if (targetAbi == Abi.ARMEABI || targetAbi == Abi.ARMEABI_V7A || targetAbi == Abi.ARM64_V8A) {
            cmds.add("type format add -f c-string \"signed char *\"");
        }
        if (((Boolean)StudioFlags.ENABLE_LLDB_NATVIS.get()).booleanValue()) {
            cmds.add("type category enable jb_formatters");
        }
        return cmds;
    }

    @NotNull
    public List<String> getPostAttachCommands() {
        ArrayList cmds = Lists.newArrayList();
        cmds.add(NativeAndroidDebugger.prepareSetSettingsCommand("target.process.thread.step-avoid-regexp", "''"));
        cmds.add("type format add --format boolean jboolean");
        return cmds;
    }

    public boolean needsJdwpConnectorOnAttach(@NotNull SessionStarterType sessionStarterType) {
        return sessionStarterType == SessionStarterType.INJECTOR || sessionStarterType == SessionStarterType.INJECTOR_YAMA;
    }

    protected static void detachXDebugSession(@NotNull XDebugSession debugSession) {
        RunContentDescriptor descriptor = debugSession.getRunContentDescriptor();
        ProcessHandler processHandler = descriptor.getProcessHandler();
        if (processHandler != null) {
            processHandler.detachProcess();
        }
    }

    @Nullable
    protected static XDebugSession findNativeDebugSession(@NotNull Project project, @NotNull Client client) {
        return NativeAndroidDebugger.findXDebugSession(project, (NotNullFunction<XDebugProcess, Boolean>)((NotNullFunction)debugProcess -> {
            if (!(debugProcess instanceof AndroidNativeAppDebugProcess)) {
                return false;
            }
            AndroidNativeAppDebugProcess nativeDebugProcess = (AndroidNativeAppDebugProcess)((Object)debugProcess);
            return nativeDebugProcess.getClient().getClientData().getPid() == client.getClientData().getPid();
        }));
    }

    @Nullable
    protected static XDebugSession findXDebugSession(@NotNull Project project, @NotNull NotNullFunction<XDebugProcess, Boolean> debugProcessFilter) {
        for (XDebugSession debugSession : XDebuggerManager.getInstance((Project)project).getDebugSessions()) {
            XDebugProcess debugProcess = debugSession.getDebugProcess();
            if (!((Boolean)debugProcessFilter.fun((Object)debugProcess)).booleanValue()) continue;
            return debugSession;
        }
        return null;
    }

    @NotNull
    protected static String prepareSetSettingsCommand(String ... options) {
        return "settings set " + StringUtil.join((String[])options, (String)" ");
    }
}

