/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.android.tools.ndk.run.crash.NativeClientCrashReportingTask;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.diagnostic.AbstractMessage;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLogRecordFormatter;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.android.diagnostics.error.ErrorBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrashLoggingEvent
extends IdeaLoggingEvent {
    private final String mySignature;
    private final DeviceInfo myDeviceInfo;
    protected final List<Attachment> myAttachments;

    public CrashLoggingEvent(@NotNull String message, @NotNull Throwable throwable, @NotNull List<Attachment> attachments) {
        this(message, throwable, attachments, null, null);
    }

    public CrashLoggingEvent(@NotNull String message, @NotNull Throwable throwable, @NotNull List<Attachment> attachments, @Nullable DeviceInfo deviceInfo, @Nullable String signature) {
        super(message, throwable);
        this.mySignature = signature;
        this.myDeviceInfo = deviceInfo;
        this.myAttachments = attachments;
    }

    @NotNull
    public Object getData() {
        return new CrashData();
    }

    public RuntimeExceptionWithAttachments makeException() {
        return new CrashLoggingEventException(this.getMessage(), this.getThrowable(), this.myAttachments.toArray(new Attachment[0]));
    }

    public static class CrashLoggingEventException
    extends RuntimeExceptionWithAttachments {
        public CrashLoggingEventException(String message, @Nullable Throwable cause, Attachment ... attachments) {
            super(message, cause, attachments);
        }
    }

    private class CrashData
    extends AbstractMessage
    implements ErrorReportCustomizer {
        private CrashData() {
        }

        public Task.Backgroundable makeReportingTask(@Nullable Project project, @NotNull String title, boolean canBeCancelled, @NotNull ErrorBean bean, @NotNull Consumer<String> callback, @NotNull Consumer<Exception> errorCallback) {
            return new NativeClientCrashReportingTask(project, title, canBeCancelled, bean, callback, errorCallback, CrashLoggingEvent.this.myDeviceInfo, CrashLoggingEvent.this.mySignature);
        }

        @NotNull
        public List<Attachment> getAllAttachments() {
            return CrashLoggingEvent.this.myAttachments;
        }

        @NotNull
        public Throwable getThrowable() {
            return CrashLoggingEvent.this.getThrowable();
        }

        @NotNull
        public String getThrowableText() {
            return IdeaLogRecordFormatter.formatThrowable((Throwable)this.getThrowable());
        }

        @Nullable
        public String getMessage() {
            return CrashLoggingEvent.this.getMessage();
        }
    }
}

